package com.oauth.security.user;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
/**
 * @author Administrator
 */
@Service
@FeignClient(name = "microservice-admin")
public interface UserService {

  /**
   * 根据用户名查询用户信息
   * @param username
   * @return
   */
  @RequestMapping(value = "/sys/user/infoByName/{username}", method = RequestMethod.GET)
  String findByUserName(@PathVariable("username") String username);
}
