package com.devplatform.zuul;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.cloud.netflix.zuul.EnableZuulProxy;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
/**
 * springboot启动类
 * @author Administrator
 */
@SpringBootApplication(exclude = {DataSourceAutoConfiguration.class})
@EnableZuulProxy
@EnableGlobalMethodSecurity(prePostEnabled = true)
public class ZuulApplication {

  public static void main(String[] args) {
    SpringApplication.run(ZuulApplication.class, args);
  }

  //    /**
  //     * 资源过滤器
  //     * @return 资源过滤器
  //     */
  //    @Bean
  //    public AccessFilter accessFilter(){
  //        return new AccessFilter();
  //    }

}
