package com.devplatform.zuul.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * @author Administrator
 */

public class CsrFilter implements Filter {
    //  @Configuration
    /**
     * 日志
     */
    static final Logger logger = LogManager.getLogger(CsrFilter.class);

    @Value("${filter.referers}")
    private String referers;
    private String[] verifyReferer;

    /**
     * filter销毁方法
     */
    @Override
    public void destroy() {

    }

    /**
     * filter过滤
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException, ServletException {
        String referer = ((HttpServletRequest) request).getHeader("Referer");
        boolean b = false;
        logger.debug("referer:{}", referer);
        logger.debug("referers:{}", referers);
        for (String str : this.verifyReferer) {
            if (referer.trim().lastIndexOf(str) == 0) {
                b = true;
                chain.doFilter(request, response);
            }
        }
        if (!b) {
            logger.debug("疑似CSRF攻击，referer:{}", referer);
        }
    }

    /**
     * filter初始化
     */
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.verifyReferer = referers.split(",");
    }

}