package com.devplatform.zuul.filter;

import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;

/**
 * Created on 2018/5/5 0005.
 *
 * @author szy
 * @email i@suntray.com
 * @since 1.0
 */
@Configuration
@EnableResourceServer
public class SuntrayResourceServerConfiguration extends ResourceServerConfigurerAdapter {

  @Override
  public void configure(HttpSecurity http) throws Exception {
    http.csrf()
        .disable()
        .authorizeRequests()
        .antMatchers(
            "/websocket/",
            "/admin/captcha.jpg",
            "/admin/**",
            "/login",
            "/authorization/oauth/token",
            "/admin/druid/sql.html",
            "/admin/swagger-ui.html")
        .permitAll()
        .anyRequest()
        .authenticated()
        .antMatchers(HttpMethod.GET, "/api")
        // 拦截用户，必须具有所列权限
        .hasAuthority("ROLE_USER")
        .and()
        .headers()
        .frameOptions()
        .disable();
  }
}
