// layout
import layoutHeaderAside from '@/layout/header-aside'

const meta = {
  requiresAuth: true
}

/**
 * 在主框架内显示
 */
const frameIn = [

  {
    path: '/',
    redirect: { name: 'index' },
    component: layoutHeaderAside,
    children: [
      {
        path: 'index',
        name: 'index',
        component: () => import('@/pages/home')
      }
    ]
  },
// 数据看板
{
  path: '/kb',
  name: 'kb',
  meta,
  component: layoutHeaderAside,
  children: (pre => [
    { path: 'power', name: `${pre}power`, component: () => import('@/pages/kb/power'), meta: { ...meta, title: '用电数据' } },

    { path: 'indoor', name: `${pre}indoor`, component: () => import('@/pages/kb/indoor'), meta: { ...meta, title: '室内气象数据' } },
    { path: 'outdoor', name: `${pre}outdoor`, component: () => import('@/pages/kb/outdoor'), meta: { ...meta, title: '室外气象数据' } }
  ])('kb-')
},
  //设备管理
  {
    path: '/eq',
    name: 'eq',
    component: layoutHeaderAside,
    children: (pre => [
      { path: 'hall', name: `${pre}hall`, component: () => import('@/pages/eq/hall'), meta: { ...meta, title: '候车大厅控制' } },
      { path: 'office', name: `${pre}office`, component: () => import('@/pages/eq/office'), meta: { ...meta, title: '办公区域控制' } },
      { path: 'view', name: `${pre}view`, component: () => import('@/pages/eq/view'), meta: { ...meta, title: '设备概览' } }
    ])('eq-')
  },

// 数据分析
{
  path: '/analysis',
  name: 'analysis',
  meta,
  component: layoutHeaderAside,
  children: (pre => [
    { path: 'fault', name: `${pre}fault`, component: () => import('@/pages/analysis/fault'), meta: { ...meta, title: '设备故障报警' } },

    { path: 'energy', name: `${pre}energy`, component: () => import('@/pages/analysis/energy'), meta: { ...meta, title: '能耗数据分析' } },

    { path: 'indoor', name: `${pre}indoor`, component: () => import('@/pages/analysis/indoor'), meta: { ...meta, title: '室内气象分析' } },
    { path: 'outdoor', name: `${pre}outdoor`, component: () => import('@/pages/analysis/outdoor'), meta: { ...meta, title: '室外气象分析' } }
  ])('analysis-')
},
// 系统管理
{
  path: '/sys',
  name: 'sys',
  meta,
  component: layoutHeaderAside,
  children: (pre => [
    // 系统管理
    { path: 'admin', name: `${pre}admin`, component: () => import('@/pages/sys/user'), meta: { ...meta, title: '用户管理' } },
    { path: 'role', name: `${pre}role`, component: () => import('@/pages/sys/role'), meta: { ...meta, title: '角色管理' } },
    { path: 'logs', name: `${pre}logs`, component: () => import('@/pages/sys/logs'), meta: { ...meta, title: '系统日志' } },
    { path: 'commandlog', name: `${pre}commandlog`, component: () => import('@/pages/sys/commandlog'), meta: { ...meta, title: '历史指令' } },
    { path: 'point', name: `${pre}point`, component: () => import('@/pages/sys/point'), meta: { ...meta, title: '资源点管理' } },
    { path: 'points', name: `${pre}points`, component: () => import('@/pages/sys/points'), meta: { ...meta, title: '点位管理' } },
    { path: 'road', name: `${pre}road`, component: () => import('@/pages/sys/road'), meta: { ...meta, title: '线路站点管理' } },
    { path: 'parameter', name: `${pre}parameter`, component: () => import('@/pages/sys/parameter'), meta: { ...meta, title: '系统参数设置' } },
    { path: 'code', name: `${pre}code`, component: () => import('@/pages/sys/code'), meta: { ...meta, title: '代码生成' } },
    { path: 'dictionary', name: `${pre}dictionary`, component: () => import('@/pages/sys/dictionary'), meta: { ...meta, title: '数据字典' } }
  ])('sys-')
}

]

/**
 * 在主框架之外显示
 */
const frameOut = [
  // 页面重定向使用 必须保留
  {
    path: '/redirect/:path*',
    component: () => import('@/pages/redirect')
  },
  // 登录
  {
    path: '/login',
    name: 'login',
    component: () => import('@/pages/login')
  },
  {
    path: '/home',
    name: 'home',
    component: () => import('@/pages/home')
  }
]

/**
 * 错误页面
 */
const errorPage = [
  // 404
  {
    path: '*',
    name: '404',
    component: () => import('@/pages/error-page-404')
  }
]

// 导出需要显示菜单的
export const frameInRoutes = frameIn

// 重新组织后导出
export default [
  ...frameIn,
  ...frameOut,
  ...errorPage
]
