import Vue from 'vue'

// 防止重复提交指令
const preventReClick = Vue.directive('preventReClick', {
  inserted (el, binding) {
    var timer_t=null
    if(timer_t){
      clearTimeout(t)
    }
    el.addEventListener('click', () => {
      if (!el.disabled) {
        el.disabled = true
      timer_t=  setTimeout(() => { el.disabled = false }, binding.value || 3000)
      }
    })

  }
})

export { preventReClick }
