import vue from 'vue'
import toastComponent from './toast.vue'

// 组件构造器，构造出一个 vue组件实例
const ToastConstructor = vue.extend(toastComponent)

function showToast ({ tip, id, stationName, tierName, resourceName, occurrenceSite, level, times, type, explain, url, router, duration }) {
  const toastDom = new ToastConstructor({
    el: document.createElement('div'),
    data () {
      return {
        isShow: true, // 是否显示
        tip: tip,
        id: id, //主键id
        stationName: stationName, //站点名
        tierName: tierName, //站层名
        resourceName: resourceName, //资源点名
        occurrenceSite: occurrenceSite, //发生地点
        level: level, // 等级
        times: times, //时间
        type: type, // 类型
        explain: explain, //说明
        url: url, //图片地址
        router: router
      }
    }
  })
  // 添加节点
  document.body.appendChild(toastDom.$el)
  // 过渡时间
  setTimeout(() => {
    toastDom.isShow = false
  }, duration)
}
// 全局注册
function registryToast () {
  vue.prototype.$toast = showToast
}

export default registryToast
