// polyfill
import 'babel-polyfill'
// Vue
import Vue from 'vue'
import App from './App'
import { mapState } from 'vuex'
import VueDirectiveImagePreviewer from 'vue-directive-image-previewer'
import 'vue-directive-image-previewer/dist/assets/style.css'
// import Pug from 'pug'
// store
import store from '@/store/index'
// 模拟数据
// import '@/mock'
// 多国语
import i18n from './i18n'
// 核心插件
import d2Admin from '@/plugin/d2admin'

// [ 可选插件组件 ]D2-Crud
import D2Crud from '@d2-projects/d2-crud'
// [ 可选插件组件 ] 图表
import VCharts from 'v-charts'
// [ 可选插件组件 ] 图表
import echarts from 'echarts'
// [ 可选插件组件 ] 右键菜单
// import contentmenu from 'v-contextmenu'
// import 'v-contextmenu/dist/index.css'
// [ 可选插件组件 ] JSON 树状视图
import vueJsonTreeView from 'vue-json-tree-view'
// [ 可选插件组件 ] 网格布局组件
import { GridLayout, GridItem } from 'vue-grid-layout'
// [ 可选插件组件 ] 区域划分组件
import SplitPane from 'vue-splitpane'
import VueCropper from 'vue-cropper'
// 菜单和路由设置
import router from './router'
// import { menuHeader, menuAside } from '@/menu'
import { frameInRoutes } from '@/router/routes'
import httpRequest from '@/plugin/axios'
import { isAuth } from '@/util'
import elTableInfiniteScroll from 'el-table-infinite-scroll'
//重复点击校验
import { preventReClick } from '@/util/plugins'
// import './promission'
//自定义提示框
import toastRegistry from './components/toast/index'

import ElementUI from 'element-ui' //element-ui的全部组件
// import 'element-ui/lib/theme-chalk/index.css'
Vue.use(toastRegistry)//element-ui的css
Vue.use(ElementUI) //使用elementUI

//全局

// 核心插件
Vue.use(d2Admin)
Vue.use(VueDirectiveImagePreviewer, {
  zIndex: 9999, //层级显示
  previewSize: 6 //六倍图
})
Vue.use(VueCropper)
// 可选插件组件
Vue.use(D2Crud)
Vue.use(VCharts)
Vue.use(echarts)
// Vue.use(contentmenu)
Vue.use(vueJsonTreeView)
Vue.component('d2-grid-layout', GridLayout)
Vue.component('d2-grid-item', GridItem)
Vue.component('SplitPane', SplitPane)
//无限滚动组件
Vue.use(elTableInfiniteScroll)
// 挂载全局
Vue.prototype.$echarts = echarts //echarts统计插件
Vue.prototype.$http = httpRequest // ajax请求方法
Vue.prototype.isAuth = isAuth // 权限方法
Vue.prototype.$showLoading = (val) => { // 加载等待弹窗
  let loading = Vue.prototype.$loading({
    lock: true,
    text: '正在操作，请稍后...',
    spinner: 'el-icon-loading',
    background: 'rgba(0, 0, 0, 0.7)'
  })
  setTimeout(() => {
    loading.close()
  }, 3000)
  if (val === 'close') {
    loading.close()
  }
}

new Vue({
  router,
  store,
  i18n,
  render: h => h(App),
  computed: {
    ...mapState('d2admin/menu', [
      'header'
    ])
  },
  created () {
    // 处理路由 得到每一级的路由设置
    this.$store.commit('d2admin/page/init', frameInRoutes)
    // // 设置顶栏菜单
    // this.$store.commit('d2admin/menu/headerSet', menuHeader)
    // // 初始化菜单搜索功能
    // this.$store.commit('d2admin/search/init', menuHeader)
    const pattern = /[_`~^*|{}<>￥……*|&‘”“/#（）【】《》()——\\[\]$%+=]/ //这些字段不允许输入
    const testMark = function (s) {
      return pattern.test(s)
    }
    const replaceMark = function (s, isOutSpace) {
      let rs = ''
      for (let i = 0; i < s.length; i++) {
        rs = rs + s.substr(i, 1).replace(pattern, '')
        rs = rs.replace('-', '')
        // rs = rs.replace('\\', '');
        if (!isOutSpace) {
          rs = rs.replace(' ', '')
        }
      }
      return rs
    }
  
    const timeReplaceMark = function (obj) {
      if (testMark(obj.value)) {
        obj.value = replaceMark(obj.value, true)
      } else if (/'/.test(obj.value)) {
        const tempValue = obj.value.replace(/'/gi, '')
        if (tempValue == '') { //如果全是''，代表不是输入词语，可以替换
          obj.value = tempValue
        }
      } else if (/"/.test(obj.value)) {
        const tempValue = obj.value.replace(/"/gi, '')
        if (tempValue == '') { //如果全是''，代表不是输入词语，可以替换
          obj.value = tempValue
        }
      }
    }
    document.addEventListener('input', function (ev) {
      // console.log(ev);
      if (ev.target.type === 'text' || ev.target.type === 'textarea') {
        timeReplaceMark(ev.target)
      }
    },true)
  },
  beforeDestroy(){
    window.removeEventListener('input', function (ev) {
      // console.log(ev);
      if (ev.target.type === 'text' || ev.target.type === 'textarea') {
        timeReplaceMark(ev.target)
      }
    },true)
  },
  mounted () {
    // 展示系统信息
    this.$store.commit('d2admin/releases/versionShow')
    // 检查最新版本 // 临时关闭git的自动检查更新
    // this.$store.dispatch('d2admin/releases/checkUpdate')
    // 用户登录后从数据库加载一系列的设置
    this.$store.dispatch('d2admin/account/load')
    // 获取并记录用户 UA
    this.$store.commit('d2admin/ua/get')
    // 初始化全屏监听
    this.$store.dispatch('d2admin/fullscreen/listen')
  },
  watch: {
    // 监听路由 控制侧边栏显示

    // 现在没有侧边栏 不需要
    // '$route.matched' (val) {
    //   const _side = this.header.filter(menu => menu.path === val[0].path)
    //   this.$store.commit('d2admin/menu/asideSet', _side.length > 0 ? _side[0].list : [])
    // }
  }
}).$mount('#app')
