// 插件
import demoPlugins from './modules/demo-plugins'
// 组件
import demoComponents from './modules/demo-components'
// 组件
import demoCharts from './modules/demo-charts'
// 组件库
import demoElement from './modules/demo-element'
// 功能
import demoPlayground from './modules/demo-playground'
// 示例
import demoBusiness from './modules/demo-business'
// 会员管理
import mbManage from './modules/mb-manage'
// 竞赛管理
import ctManage from './modules/ct-manage'
// CRUD
import demoD2Crud from './modules/demo-d2-crud'
// 第三方网页
import demoFrame from './modules/demo-frame'
// 角色与权限
import sysUser from './modules/sys-user'

// 菜单 侧边栏
export const menuAside = [
  demoComponents,
  demoPlugins,
  demoCharts,
  demoElement,
  demoPlayground,
  demoBusiness,
  demoD2Crud,
  demoFrame,
  sysUser
]

// 菜单 顶栏
export const menuHeader = [
  {
    path: '/index',
    title: '首页',
    icon: 'home'
  },
  {
    title: '系统管理',
    icon: 'gear',
    children: [
      sysUser,
      { path: '/sys/org', title: '主办方管理', icon: 'globe' },
      {
        title: '系统设置',
        icon: 'link',
        children: [
          { path: '', title: '定时任务', icon: 'clock-o' },
          { path: '/sys/setting/code', title: '代码生成', icon: 'globe' },
          { path: '/sys/setting/log', title: '日志管理', icon: 'globe' }
        ]
      }
    ]
  },
  {
    title: '运营管理',
    icon: 'link',
    children: [
      { path: '/operation/place', title: '场馆管理', icon: 'users' },
      { path: '/operation/fee', title: '费用管理', icon: 'modx' },
      { path: '/operation/score', title: '积分榜管理', icon: 'reorder' }
    ]
  },
  {
    title: '财务管理',
    icon: 'link',
    children: [
      {
        title: '竞赛订单',
        icon: 'link',
        children: [
          { path: '/finance/competitionOrder/classification', title: '分级公共赛订单', icon: 'globe' },
          { path: '/finance/competitionOrder/club', title: '俱乐部公开赛订单', icon: 'globe' }
        ]
      }
    ]
  },
  {
    title: '组件',
    icon: 'puzzle-piece',
    children: [
      demoD2Crud,
      demoComponents,
      demoElement,
      demoCharts,
      demoPlugins,
      demoFrame
    ]
  },
  ctManage,
  mbManage,
  demoPlayground,
  demoBusiness,
]
