// layout
import layoutHeaderAside from '@/layout/header-aside'

const meta = {
  requiresAuth: true
}

/**
 * 在主框架内显示
 */
const frameIn = [

// 线路级 ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓

//监控中心
{
  path: '/routes/ol',
  name: 'routes-ol',
  meta,
  // redirect: { name: 'ol-demo' },
  component: layoutHeaderAside,
  children: (pre => [
    { path: 'index', name: `${pre}index`, component: () => import('@/pages/routes/ol/index'), meta: { ...meta, title: '监控中心' } }
  ])('routes-ol-')
},
//统计分析
{
  path: '/routes/analysis',
  name: 'routes-analysis',
  meta,
  // redirect: { name: 'ol-demo' },
  component: layoutHeaderAside,
  children: (pre => [
   { path: 'alarmAnalysis', name: `${pre}alarmAnalysis`, component: () => import('@/pages/routes/analysis/alarmAnalysis'), meta: { ...meta, title: '事件及设备报警统计' } },
   { path: 'passengerStatistics', name: `${pre}passengerStatistics`, component: () => import('@/pages/routes/analysis/passengerStatistics'), meta: { ...meta, title: '客流统计分析' } }
  ])('routes-analysis-')
},
// 设备管理
{
  path: '/routes/eq',
  name: 'routes-eq',
  meta,
  // redirect: { name: 'eq-equ' },
  component: layoutHeaderAside,
  children: (pre => [
    { path: 'equ', name: `${pre}equ`, component: () => import('@/pages/routes/eq/equ'), meta: { ...meta, title: '设备管理' } },
    // { path: 'eqm', name: `${pre}eqm`, component: () => import('@/pages/routes/eq/eqm'), meta: { ...meta, title: '全线设备监测' } },
    // { path: 'topology', name: `${pre}topology`, component: () => import('@/pages/routes/eq/topology'), meta: { ...meta, title: '设备拓扑监测' } },
    { path: 'alarm', name: `${pre}alarm`, component: () => import('@/pages/routes/eq/alarm'), meta: { ...meta, title: '告警信息' } },
    { path: 'chart', name: `${pre}chart`, component: () => import('@/pages/routes/eq/chart'), meta: { ...meta, title: '告警统计' } }
  ])('routes-eq-')
},
// 预案管理
{
  path: '/routes/plan',
  name: 'routes-plan',
  meta,
  // redirect: { name: 'plan-planRegister' },
  component: layoutHeaderAside,
  children: (pre => [
    { path: 'planRegister', name: `${pre}planRegister`, component: () => import('@/pages/routes/plan/planRegister'), meta: { ...meta, title: '预案登记' } },
    { path: 'eventDecision', name: `${pre}eventDecision`, component: () => import('@/pages/routes/plan/eventDecision'), meta: { ...meta, title: '事件登记信息' } }
  ])('routes-plan-')
},
// 应急数据管理
{
  path: '/routes/em',
  name: 'routes-em',
  meta,
  // redirect: { name: 'ol-demo' },
  component: layoutHeaderAside,
  children: (pre => [
   { path: 'org', name: `${pre}org`, component: () => import('@/pages/routes/em/org'), meta: { ...meta, title: '应急部门管理' } },
   { path: 'proficient', name: `${pre}proficient`, component: () => import('@/pages/routes/em/proficient'), meta: { ...meta, title: '应急团队管理' } },
   { path: 'material', name: `${pre}material`, component: () => import('@/pages/routes/em/material'), meta: { ...meta, title: '应急物资管理' } }
  ])('routes-em-')
},
//系统管理
{
  path: '/routes/sys',
  name: 'routes-sys',
  meta,
  // redirect: { name: 'ol-demo' },
  component: layoutHeaderAside,
  children: (pre => [
   { path: 'user', name: `${pre}user`, component: () => import('@/pages/routes/sys/user'), meta: { ...meta, title: '用户管理' } },
   { path: 'role', name: `${pre}role`, component: () => import('@/pages/routes/sys/role'), meta: { ...meta, title: '角色管理' } },
   { path: 'logs', name: `${pre}logs`, component: () => import('@/pages/routes/sys/logs'), meta: { ...meta, title: '系统日志' } },
   { path: 'dictionary', name: `${pre}dictionary`, component: () => import('@/pages/routes/sys/dictionary'), meta: { ...meta, title: '数据字典' } }
  ])('routes-sys-')
},

// 以下站点级 ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓
{
  path: '/',
  name: 'login',
  redirect: {
    // path: '/ol/demo'
    path: '/login'
  }
  // component: () => import('@/pages/ol/demo')
  // children: [{
  //   path: 'index',
  //   name: 'index',
  //   meta,
  //   component: () => import('@/pages/ol/demo')
  // }]
},
//地图demo
{
  path: '/ol',
  name: 'ol',
  meta,
  redirect: { name: 'ol-demo' },
  component: layoutHeaderAside,
  children: (pre => [
    { path: 'demo', name: `${pre}demo`, component: () => import('@/pages/ol/demo'), meta: { ...meta, title: '电子地图' } }
  ])('ol-')
},

// 视频监控
{
  path: '/monitor',
  name: 'monitor',
  meta,
  // redirect: { name: 'monitor-point' },
  component: layoutHeaderAside,
  children: (pre => [
    // { path: 'log', name: `${pre}log`, component: () => import('@/pages/monitor/log'), meta: { ...meta, title: '电子围栏报警' } },
    // { path: 'setting/sql', name: `${pre}sql`, component: () => import('@/pages/monitor/setting/sql'), meta: { ...meta, title: '报警信息列表' } },
    // 视频监控
    { path: 'point', name: `${pre}point`, component: () => import('@/pages/monitor/point'), meta: { ...meta, title: '电子地图' } },
    { path: 'monitor', name: `${pre}monitor`, component: () => import('@/pages/monitor/monitor'), meta: { ...meta, title: '实时监控' } },
    { path: 'rotation', name: `${pre}rotation`, component: () => import('@/pages/monitor/rotation'), meta: { ...meta, title: '视频轮播' } },
    { path: 'playback', name: `${pre}playback`, component: () => import('@/pages/monitor/playback'), meta: { ...meta, title: '视频回放' } },
    { path: 'instructions', name: `${pre}instructions`, component: () => import('@/pages/monitor/instructions'), meta: { ...meta, title: '历史指令' } }

  ])('monitor-')
},
// 报警中心
{
    path: '/alarms',
    name: 'alarms',
    meta,
    // redirect: { name: 'alarms-untreated' },
    component: layoutHeaderAside,
    children: (pre => [
      // 报警中心
      { path: 'untreated', name: `${pre}untreated`, component: () => import('@/pages/alarms/untreated'), meta: { ...meta, title: '未处理事件' } },
      { path: 'processed', name: `${pre}processed`, component: () => import('@/pages/alarms/processed'), meta: { ...meta, title: '已处理事件' } },
      { path: 'instruct', name: `${pre}instruct`, component: () => import('@/pages/alarms/instruct'), meta: { ...meta, title: '历史指令' } }

    ])('alarms-')
},
//出入口控制
{
  path: '/access',
  name: 'access',
  meta,
  // redirect: { name: 'access-point' },
  component: layoutHeaderAside,
  children: (pre => [
    // { path: 'log', name: `${pre}log`, component: () => import('@/pages/monitor/log'), meta: { ...meta, title: '电子围栏报警' } },
    // { path: 'setting/sql', name: `${pre}sql`, component: () => import('@/pages/monitor/setting/sql'), meta: { ...meta, title: '报警信息列表' } },
    // 视频监控
    { path: 'point', name: `${pre}point`, component: () => import('@/pages/access/point'), meta: { ...meta, title: '电子地图' } },
    { path: 'card', name: `${pre}card`, component: () => import('@/pages/access/card'), meta: { ...meta, title: '发卡查询' } },
    { path: 'instructions', name: `${pre}instructions`, component: () => import('@/pages/access/instructions'), meta: { ...meta, title: '历史指令' } }

  ])('access-')
},
//入侵报警
{
  path: '/police',
  name: 'police',
  meta,
  // redirect: { name: 'police-point' },
  component: layoutHeaderAside,
  children: (pre => [
    // { path: 'log', name: `${pre}log`, component: () => import('@/pages/monitor/log'), meta: { ...meta, title: '电子围栏报警' } },
    // { path: 'setting/sql', name: `${pre}sql`, component: () => import('@/pages/monitor/setting/sql'), meta: { ...meta, title: '报警信息列表' } },
    // 视频监控
    { path: 'point', name: `${pre}point`, component: () => import('@/pages/police/point'), meta: { ...meta, title: '电子地图' } },
    { path: 'instructions', name: `${pre}instructions`, component: () => import('@/pages/police/instructions'), meta: { ...meta, title: '历史指令' } }

  ])('police-')
},
//安全检查
{
  path: '/inspect',
  name: 'inspect',
  meta,
  // redirect: { name: 'inspect-point' },
  component: layoutHeaderAside,
  children: (pre => [
    // { path: 'log', name: `${pre}log`, component: () => import('@/pages/monitor/log'), meta: { ...meta, title: '电子围栏报警' } },
    // { path: 'setting/sql', name: `${pre}sql`, component: () => import('@/pages/monitor/setting/sql'), meta: { ...meta, title: '报警信息列表' } },
    // 视频监控
    { path: 'point', name: `${pre}point`, component: () => import('@/pages/inspect/point'), meta: { ...meta, title: '电子地图' } },
    { path: 'security', name: `${pre}security`, component: () => import('@/pages/inspect/security'), meta: { ...meta, title: '实时安检' } },
    { path: 'playback', name: `${pre}playback`, component: () => import('@/pages/inspect/playback'), meta: { ...meta, title: '安检视频回放' } },
    { path: 'instructions', name: `${pre}instructions`, component: () => import('@/pages/inspect/instructions'), meta: { ...meta, title: '历史指令' } }

  ])('inspect-')
},
//电子巡更
{
  path: '/patrol',
  name: 'patrol',
  meta,
  // redirect: { name: 'patrol-point' },
  component: layoutHeaderAside,
  children: (pre => [
    // { path: 'log', name: `${pre}log`, component: () => import('@/pages/monitor/log'), meta: { ...meta, title: '电子围栏报警' } },
    // { path: 'setting/sql', name: `${pre}sql`, component: () => import('@/pages/monitor/setting/sql'), meta: { ...meta, title: '报警信息列表' } },
    // 视频监控
    { path: 'spot', name: `${pre}spot`, component: () => import('@/pages/patrol/spot'), meta: { ...meta, title: '巡查点' } },
    { path: 'line', name: `${pre}line`, component: () => import('@/pages/patrol/line'), meta: { ...meta, title: '巡查线路' } },
    { path: 'plan', name: `${pre}plan`, component: () => import('@/pages/patrol/plan'), meta: { ...meta, title: '巡查计划' } },
    { path: 'result', name: `${pre}result`, component: () => import('@/pages/patrol/result'), meta: { ...meta, title: '巡查结果' } },
    { path: 'machine', name: `${pre}machine`, component: () => import('@/pages/patrol/machine'), meta: { ...meta, title: '巡查机管理' } },
    { path: 'data', name: `${pre}data`, component: () => import('@/pages/patrol/data'), meta: { ...meta, title: '漏检数据' } }

  ])('patrol-')
},
// 设备管理
{
  path: '/eq',
  name: 'eq',
  meta,
  // redirect: { name: 'eq-equ' },
  component: layoutHeaderAside,
  children: (pre => [
    { path: 'equ', name: `${pre}equ`, component: () => import('@/pages/eq/equ'), meta: { ...meta, title: '设备管理' } },
    { path: 'topology', name: `${pre}topology`, component: () => import('@/pages/eq/topology'), meta: { ...meta, title: '设备拓扑监测' } },
    { path: 'alarm', name: `${pre}alarm`, component: () => import('@/pages/eq/alarm'), meta: { ...meta, title: '告警信息' } },
    { path: 'chart', name: `${pre}chart`, component: () => import('@/pages/eq/chart'), meta: { ...meta, title: '告警统计' } }
  ])('eq-')
},
// 系统联动
{
  path: '/linkage',
  name: 'linkage',
  meta,
  // redirect: { name: 'linkage-rule' },
  component: layoutHeaderAside,
  children: (pre => [
    { path: 'rule', name: `${pre}rule`, component: () => import('@/pages/linkage/rule'), meta: { ...meta, title: '联动规则配置' } },
    { path: 'logs', name: `${pre}logs`, component: () => import('@/pages/linkage/logs'), meta: { ...meta, title: '联动日志' } },
    { path: 'baseEvent', name: `${pre}baseEvent`, component: () => import('@/pages/linkage/baseEvent'), meta: { ...meta, title: '事件' } },
    { path: 'baseAction', name: `${pre}baseAction`, component: () => import('@/pages/linkage/baseAction'), meta: { ...meta, title: '动作' } }
  ])('linkage-')
},

// 预案管理
{
    path: '/plan',
    name: 'plan',
    meta,
    // redirect: { name: 'plan-planRegister' },
    component: layoutHeaderAside,
    children: (pre => [
      { path: 'planRegister', name: `${pre}planRegister`, component: () => import('@/pages/plan/planRegister'), meta: { ...meta, title: '预案登记' } },
      { path: 'planAssociated', name: `${pre}planAssociated`, component: () => import('@/pages/plan/planAssociated'), meta: { ...meta, title: '预案关联' } },
      { path: 'eventRegister', name: `${pre}eventRegister`, component: () => import('@/pages/plan/eventRegister'), meta: { ...meta, title: '事件登记' } },
      { path: 'eventDecision', name: `${pre}eventDecision`, component: () => import('@/pages/plan/eventDecision'), meta: { ...meta, title: '事件决策' } }
    ])('plan-')
},
// 应急数据管理
{
  path: '/em',
  name: 'em',
  meta,
  // redirect: { name: 'em-org' },
  component: layoutHeaderAside,
  children: (pre => [
    { path: 'org', name: `${pre}org`, component: () => import('@/pages/em/org'), meta: { ...meta, title: '应急部门管理' } },
    { path: 'proficient', name: `${pre}proficient`, component: () => import('@/pages/em/proficient'), meta: { ...meta, title: '应急团队管理' } },
    //{ path: 'person', name: `${pre}person`, component: () => import('@/pages/em/person'), meta: { ...meta, title: '应急人员管理' } },
    { path: 'material', name: `${pre}material`, component: () => import('@/pages/em/material'), meta: { ...meta, title: '应急物资管理' } }
  ])('em-')
},
// 系统管理
{
  path: '/sys',
  name: 'sys',
  meta,
  // redirect: { name: 'sys-admin' },
  component: layoutHeaderAside,
  children: (pre => [
    // { path: 'log', name: `${pre}log`, component: () => import('@/pages/sys/log'), meta: { ...meta, title: '电子围栏报警' } },
    // { path: 'setting/sql', name: `${pre}sql`, component: () => import('@/pages/sys/setting/sql'), meta: { ...meta, title: '报警信息列表' } },
    // 系统管理
    // { path: 'org', name: `${pre}org`, component: () => import('@/pages/sys/org'), meta: { ...meta, title: '机构管理' } },
    { path: 'admin', name: `${pre}admin`, component: () => import('@/pages/sys/user'), meta: { ...meta, title: '用户管理' } },
    { path: 'role', name: `${pre}role`, component: () => import('@/pages/sys/role'), meta: { ...meta, title: '角色管理' } },
    { path: 'logs', name: `${pre}logs`, component: () => import('@/pages/sys/logs'), meta: { ...meta, title: '系统日志' } },
    { path: 'point', name: `${pre}point`, component: () => import('@/pages/sys/point'), meta: { ...meta, title: '资源点管理' } },
    { path: 'road', name: `${pre}road`, component: () => import('@/pages/sys/road'), meta: { ...meta, title: '线路站点管理' } },
    { path: 'preset', name: `${pre}preset`, component: () => import('@/pages/sys/preset'), meta: { ...meta, title: '预置点管理' } },
    { path: 'region', name: `${pre}region`, component: () => import('@/pages/sys/region'), meta: { ...meta, title: '防区维护' } },
    { path: 'datasource', name: `${pre}datasource`, component: () => import('@/pages/sys/datasource'), meta: { ...meta, title: '数据源维护' } },
    { path: 'takeover', name: `${pre}takeover`, component: () => import('@/pages/sys/takeover'), meta: { ...meta, title: '站点接管管理' } },
    { path: 'parameter', name: `${pre}parameter`, component: () => import('@/pages/sys/parameter'), meta: { ...meta, title: '系统参数设置' } },
    { path: 'code', name: `${pre}code`, component: () => import('@/pages/sys/code'), meta: { ...meta, title: '代码生成' } },
    { path: 'dictionary', name: `${pre}dictionary`, component: () => import('@/pages/sys/dictionary'), meta: { ...meta, title: '数据字典' } }
  ])('sys-')
}

]

/**
 * 在主框架之外显示
 */
const frameOut = [
  // 页面重定向使用 必须保留
  {
    path: '/redirect/:path*',
    component: () => import('@/pages/redirect')
  },
  // 登录
  {
    path: '/login',
    name: 'login',
    component: () => import('@/pages/login')
  }
]

/**
 * 错误页面
 */
const errorPage = [
  // 404
  {
    path: '*',
    name: '404',
    component: () => import('@/pages/error-page-404')
  }
]

// 导出需要显示菜单的
export const frameInRoutes = frameIn

// 重新组织后导出
export default [
  ...frameIn,
  ...frameOut,
  ...errorPage
]
