import Vue from 'vue'
import router from '@/router'
import store from '@/store'
import httpRequest from '@/plugin/axios'

/**
 * 获取uuid
 */
export function getUUID () {
  return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, c => {
    return (c === 'x' ? (Math.random() * 16 | 0) : ('r&0x3' | '0x8')).toString(16)
  })
}

/**
 * 是否有权限
 * @param {*} key
 */
export function isAuth (key) {
  let takeover = sessionStorage.getItem('takeover')
  if (takeover) {
    return false
  }

  let permissions=sessionStorage.getItem('permissions') || []
  let index = permissions.indexOf(key)
  return index !== -1
}

/**
 * 树形数据转换
 * @param {*} data
 * @param {*} id
 * @param {*} pid
 */
export function treeDataTranslate (data, id = 'id', pid = 'parentId') {
  var res = []
  var temp = {}
  for (var i = 0; i < data.length; i++) {
    temp[data[i][id]] = data[i]
  }
  for (var k = 0; k < data.length; k++) {
    if (temp[data[k][pid]] && data[k][id] !== data[k][pid]) {
      if (!temp[data[k][pid]]['children']) {
        temp[data[k][pid]]['children'] = []
      }
      if (!temp[data[k][pid]]['_level']) {
        temp[data[k][pid]]['_level'] = 1
      }
      data[k]['_level'] = temp[data[k][pid]]._level + 1
      temp[data[k][pid]]['children'].push(data[k])
    } else {
      res.push(data[k])
    }
  }
  return res
}

/**
 * 清除登录信息
 */
export function clearLoginInfo () {
  Vue.cookie.delete('token')
  store.commit('resetStore')
  router.options.isAddDynamicMenuRoutes = false
}

/**
 * jgg
 */
export function getPermissions () {
  // let type = ''
  // httpRequest({ url: httpRequest.adornUrl('/sysSystem/getSystem'), method: 'get' }).then((e) => {
  //   console.log(e.one.type, '类型')
  //   type = e.one.type.toString()
  // })

  // let urlData
  // if (type === '1') {
  //   urlData = httpRequest.adornUrl('/sys/menu/nav')
  //   } else if (type === '2') {
  //       urlData = httpRequest.adornUrl('/routes/sys/menu/nav')
  //   }

  httpRequest({
    url: httpRequest.adornUrl('/sys/menu/nav'),
    // url: urlData,
    method: 'get'
  }).then((data) => {
    if (data && data.code === 0) {
      // 设置顶栏菜单
      // console.log(data, '权限菜单')
      // console.log(data.nav, '需要添加的路由')
      store.dispatch('d2admin/menu/headerSetAsync', data.menuList)
      store.dispatch('d2admin/menu/setRouterList', data.nav)
      // console.log(store.state.d2admin.menu.routerList, '&&')
      // console.log(store.state.d2admin.menu.header, '&&')
      sessionStorage.setItem('menuList', JSON.stringify(data.menuList || '[]'))
      sessionStorage.setItem('permissions', JSON.stringify(data.permissions || '[]'))
      sessionStorage.setItem('routerList', JSON.stringify(data.nav || '[]'))
      // next({ ...to, replace: true })
    } else {
      sessionStorage.setItem('menuList', '[]')
      sessionStorage.setItem('permissions', '[]')
      sessionStorage.setItem('routerList', '[]')

      // next()
    }
  }).catch((e) => {
    console.log(`%c${e} 请求菜单列表和权限失败，跳转至登录页！！`, 'color:blue')
    // next({
    //   name: 'login'
    // })
  })
}
