// layout
import layoutHeaderAside from '@/layout/header-aside'

const meta = {
  requiresAuth: true
}

/**
 * 在主框架内显示
 */
const frameIn = [

// 以下站点级 ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓ ↓
{
  path: '/',
  name: 'login',
  redirect: {
    // path: '/ol/demo'
    path: '/login'
  }
  // component: () => import('@/pages/ol/demo')
  // children: [{
  //   path: 'index',
  //   name: 'index',
  //   meta,
  //   component: () => import('@/pages/ol/demo')
  // }]
},
//地图demo
{
  path: '/ol',
  name: 'ol',
  meta,
  // redirect: { name: 'ol-demo' },
  component: layoutHeaderAside,
  children: (pre => [
    { path: 'demo', name: `${pre}demo`, component: () => import('@/pages/ol/demo'), meta: { ...meta, title: '电子地图' } },
    { path: 'kanban', name: `${pre}kanban`, component: () => import('@/pages/ol/kanban'), meta: { ...meta, title: '数据看板' } }
  ])('ol-')
},

// 视频监控
{
  path: '/monitor',
  name: 'monitor',
  meta,
  // redirect: { name: 'monitor-point' },
  component: layoutHeaderAside,
  children: (pre => [
    // { path: 'log', name: `${pre}log`, component: () => import('@/pages/monitor/log'), meta: { ...meta, title: '电子围栏报警' } },
    // { path: 'setting/sql', name: `${pre}sql`, component: () => import('@/pages/monitor/setting/sql'), meta: { ...meta, title: '报警信息列表' } },
    // 视频监控
    { path: 'point', name: `${pre}point`, component: () => import('@/pages/monitor/point'), meta: { ...meta, title: '电子地图' } },
    { path: 'monitor', name: `${pre}monitor`, component: () => import('@/pages/monitor/monitor'), meta: { ...meta, title: '实时监控' } },
    { path: 'rotation', name: `${pre}rotation`, component: () => import('@/pages/monitor/rotation'), meta: { ...meta, title: '视频轮播' } },
    { path: 'playback', name: `${pre}playback`, component: () => import('@/pages/monitor/playback'), meta: { ...meta, title: '视频回放' } },
    { path: 'instructions', name: `${pre}instructions`, component: () => import('@/pages/monitor/instructions'), meta: { ...meta, title: '历史指令' } }

  ])('monitor-')
},
// 报警中心
{
    path: '/alarms',
    name: 'alarms',
    meta,
    // redirect: { name: 'alarms-untreated' },
    component: layoutHeaderAside,
    children: (pre => [
      // 报警中心
      { path: 'untreated', name: `${pre}untreated`, component: () => import('@/pages/alarms/untreated'), meta: { ...meta, title: '未处理事件' } }

    ])('alarms-')
},

//电子巡更
{
  path: '/patrol',
  name: 'patrol',
  meta,
  // redirect: { name: 'patrol-point' },
  component: layoutHeaderAside,
  children: (pre => [
    // { path: 'log', name: `${pre}log`, component: () => import('@/pages/monitor/log'), meta: { ...meta, title: '电子围栏报警' } },
    // { path: 'setting/sql', name: `${pre}sql`, component: () => import('@/pages/monitor/setting/sql'), meta: { ...meta, title: '报警信息列表' } },
    // 视频监控
    { path: 'spot', name: `${pre}spot`, component: () => import('@/pages/patrol/spot'), meta: { ...meta, title: '巡查点' } },
    { path: 'line', name: `${pre}line`, component: () => import('@/pages/patrol/line'), meta: { ...meta, title: '巡查线路' } },
    { path: 'plan', name: `${pre}plan`, component: () => import('@/pages/patrol/plan'), meta: { ...meta, title: '巡查计划' } },
    { path: 'result', name: `${pre}result`, component: () => import('@/pages/patrol/result'), meta: { ...meta, title: '巡查结果' } },
    { path: 'machine', name: `${pre}machine`, component: () => import('@/pages/patrol/machine'), meta: { ...meta, title: '巡查机管理' } },
    { path: 'data', name: `${pre}data`, component: () => import('@/pages/patrol/data'), meta: { ...meta, title: '漏检数据' } }

  ])('patrol-')
},
// 设备管理
{
  path: '/eq',
  name: 'eq',
  meta,
  // redirect: { name: 'eq-equ' },
  component: layoutHeaderAside,
  children: (pre => [
    { path: 'equ', name: `${pre}equ`, component: () => import('@/pages/eq/equ'), meta: { ...meta, title: '设备管理' } },
    { path: 'topology', name: `${pre}topology`, component: () => import('@/pages/eq/topology'), meta: { ...meta, title: '设备拓扑监测' } },
    { path: 'alarm', name: `${pre}alarm`, component: () => import('@/pages/eq/alarm'), meta: { ...meta, title: '告警信息' } },
    { path: 'chart', name: `${pre}chart`, component: () => import('@/pages/eq/chart'), meta: { ...meta, title: '告警统计' } },
    { path: 'type', name: `${pre}type`, component: () => import('@/pages/eq/type'), meta: { ...meta, title: '报警类型维护' } }
  ])('eq-')
},
// 系统管理
{
  path: '/sys',
  name: 'sys',
  meta,
  // redirect: { name: 'sys-admin' },
  component: layoutHeaderAside,
  children: (pre => [
    // { path: 'log', name: `${pre}log`, component: () => import('@/pages/sys/log'), meta: { ...meta, title: '电子围栏报警' } },
    // { path: 'setting/sql', name: `${pre}sql`, component: () => import('@/pages/sys/setting/sql'), meta: { ...meta, title: '报警信息列表' } },
    // 系统管理
    // { path: 'org', name: `${pre}org`, component: () => import('@/pages/sys/org'), meta: { ...meta, title: '机构管理' } },
    { path: 'admin', name: `${pre}admin`, component: () => import('@/pages/sys/user'), meta: { ...meta, title: '用户管理' } },
    { path: 'role', name: `${pre}role`, component: () => import('@/pages/sys/role'), meta: { ...meta, title: '角色管理' } },
    { path: 'logs', name: `${pre}logs`, component: () => import('@/pages/sys/logs'), meta: { ...meta, title: '系统日志' } },
    { path: 'point', name: `${pre}point`, component: () => import('@/pages/sys/point'), meta: { ...meta, title: '资源点管理' } },
    { path: 'road', name: `${pre}road`, component: () => import('@/pages/sys/road'), meta: { ...meta, title: '线路站点管理' } },
    { path: 'preset', name: `${pre}preset`, component: () => import('@/pages/sys/preset'), meta: { ...meta, title: '预置点管理' } },
    { path: 'room', name: `${pre}room`, component: () => import('@/pages/sys/room'), meta: { ...meta, title: '场景维护' } },
    { path: 'threshold', name: `${pre}threshold`, component: () => import('@/pages/sys/threshold'), meta: { ...meta, title: '阈值维护' } },
    { path: 'event', name: `${pre}event`, component: () => import('@/pages/sys/event'), meta: { ...meta, title: '报警类型维护' } },
    { path: 'datasource', name: `${pre}datasource`, component: () => import('@/pages/sys/datasource'), meta: { ...meta, title: '数据源维护' } },
    { path: 'parameter', name: `${pre}parameter`, component: () => import('@/pages/sys/parameter'), meta: { ...meta, title: '系统参数设置' } },
    { path: 'code', name: `${pre}code`, component: () => import('@/pages/sys/code'), meta: { ...meta, title: '代码生成' } },
    { path: 'dictionary', name: `${pre}dictionary`, component: () => import('@/pages/sys/dictionary'), meta: { ...meta, title: '数据字典' } }
  ])('sys-')
}

]

/**
 * 在主框架之外显示
 */
const frameOut = [
  // 页面重定向使用 必须保留
  {
    path: '/redirect/:path*',
    component: () => import('@/pages/redirect')
  },
  // 登录
  {
    path: '/login',
    name: 'login',
    component: () => import('@/pages/login')
  }
]

/**
 * 错误页面
 */
const errorPage = [
  // 404
  {
    path: '*',
    name: '404',
    component: () => import('@/pages/error-page-404')
  }
]

// 导出需要显示菜单的
export const frameInRoutes = frameIn

// 重新组织后导出
export default [
  ...frameIn,
  ...frameOut,
  ...errorPage
]
