
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;


-- ----------------------------
-- 1.Table structure for qrtz_calendars
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_calendars`;
CREATE TABLE `qrtz_calendars`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `CALENDAR_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `CALENDAR` blob NOT NULL,
  PRIMARY KEY (`SCHED_NAME`, `CALENDAR_NAME`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- 1.Records of qrtz_calendars
-- ----------------------------


-- ----------------------------
-- 2.Table structure for qrtz_locks
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_locks`;
CREATE TABLE `qrtz_locks`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `LOCK_NAME` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`SCHED_NAME`, `LOCK_NAME`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- 2.Records of qrtz_locks
-- ----------------------------
INSERT INTO `qrtz_locks` VALUES ('MyScheduler', 'STATE_ACCESS');
INSERT INTO `qrtz_locks` VALUES ('MyScheduler', 'TRIGGER_ACCESS');


-- ----------------------------
-- 3.Table structure for qrtz_paused_trigger_grps
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_paused_trigger_grps`;
CREATE TABLE `qrtz_paused_trigger_grps`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`SCHED_NAME`, `TRIGGER_GROUP`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- 3.Records of qrtz_paused_trigger_grps
-- ----------------------------

-- ----------------------------
-- 4.Table structure for qrtz_fired_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_fired_triggers`;
CREATE TABLE `qrtz_fired_triggers`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `ENTRY_ID` varchar(95) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `INSTANCE_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `FIRED_TIME` bigint NOT NULL,
  `SCHED_TIME` bigint NOT NULL,
  `PRIORITY` int NOT NULL,
  `STATE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `JOB_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `JOB_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `IS_NONCONCURRENT` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `REQUESTS_RECOVERY` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`, `ENTRY_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- 4.Records of qrtz_fired_triggers
-- ----------------------------


-- ----------------------------
-- 5.Table structure for qrtz_job_details
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_job_details`;
CREATE TABLE `qrtz_job_details`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `JOB_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `JOB_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `DESCRIPTION` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `JOB_CLASS_NAME` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `IS_DURABLE` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `IS_NONCONCURRENT` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `IS_UPDATE_DATA` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `REQUESTS_RECOVERY` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `JOB_DATA` blob NULL,
  PRIMARY KEY (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- 5.Records of qrtz_job_details
-- ----------------------------

-- ----------------------------
-- 6.Table structure for qrtz_scheduler_state
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_scheduler_state`;
CREATE TABLE `qrtz_scheduler_state`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `INSTANCE_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `LAST_CHECKIN_TIME` bigint NOT NULL,
  `CHECKIN_INTERVAL` bigint NOT NULL,
  PRIMARY KEY (`SCHED_NAME`, `INSTANCE_NAME`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- 6.Records of qrtz_scheduler_state
-- ----------------------------
INSERT INTO `qrtz_scheduler_state` VALUES ('MyScheduler', 'iZ2ze2s7w3i4i3oheb5vlyZ1702616791832', 1704700424804, 15000);

-- ----------------------------
-- 7.Table structure for qrtz_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_triggers`;
CREATE TABLE `qrtz_triggers`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `JOB_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `JOB_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `DESCRIPTION` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `NEXT_FIRE_TIME` bigint NULL DEFAULT NULL,
  `PREV_FIRE_TIME` bigint NULL DEFAULT NULL,
  `PRIORITY` int NULL DEFAULT NULL,
  `TRIGGER_STATE` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TRIGGER_TYPE` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `START_TIME` bigint NOT NULL,
  `END_TIME` bigint NULL DEFAULT NULL,
  `CALENDAR_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `MISFIRE_INSTR` smallint NULL DEFAULT NULL,
  `JOB_DATA` blob NULL,
  PRIMARY KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) USING BTREE,
  INDEX `SCHED_NAME`(`SCHED_NAME` ASC, `JOB_NAME` ASC, `JOB_GROUP` ASC) USING BTREE,
  CONSTRAINT `qrtz_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) REFERENCES `qrtz_job_details` (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- 7.Records of qrtz_triggers
-- ----------------------------

-- ----------------------------
-- 8.Table structure for qrtz_blob_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_blob_triggers`;
CREATE TABLE `qrtz_blob_triggers`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `BLOB_DATA` blob NULL,
  PRIMARY KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_blob_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- 8.Records of qrtz_blob_triggers
-- ----------------------------

-- ----------------------------
-- 9.Table structure for qrtz_cron_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_cron_triggers`;
CREATE TABLE `qrtz_cron_triggers`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `CRON_EXPRESSION` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TIME_ZONE_ID` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_cron_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- 9.Records of qrtz_cron_triggers
-- ----------------------------

-- ----------------------------
-- 10.Table structure for qrtz_simple_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simple_triggers`;
CREATE TABLE `qrtz_simple_triggers`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `REPEAT_COUNT` bigint NOT NULL,
  `REPEAT_INTERVAL` bigint NOT NULL,
  `TIMES_TRIGGERED` bigint NOT NULL,
  PRIMARY KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_simple_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- 10.Records of qrtz_simple_triggers
-- ----------------------------

-- ----------------------------
-- 11.Table structure for qrtz_simprop_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simprop_triggers`;
CREATE TABLE `qrtz_simprop_triggers`  (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `STR_PROP_1` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `STR_PROP_2` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `STR_PROP_3` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `INT_PROP_1` int NULL DEFAULT NULL,
  `INT_PROP_2` int NULL DEFAULT NULL,
  `LONG_PROP_1` bigint NULL DEFAULT NULL,
  `LONG_PROP_2` bigint NULL DEFAULT NULL,
  `DEC_PROP_1` decimal(13, 4) NULL DEFAULT NULL,
  `DEC_PROP_2` decimal(13, 4) NULL DEFAULT NULL,
  `BOOL_PROP_1` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `BOOL_PROP_2` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_simprop_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- 11.Records of qrtz_simprop_triggers
-- ----------------------------


-- ----------------------------
-- Table structure for sys_announcement
-- ----------------------------
DROP TABLE IF EXISTS `sys_announcement`;
CREATE TABLE `sys_announcement`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `titile` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '标题',
  `msg_content` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '内容',
  `start_time` datetime NULL DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime NULL DEFAULT NULL COMMENT '结束时间',
  `sender` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发布人',
  `priority` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '优先级（L低，M中，H高）',
  `msg_category` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '2' COMMENT '消息类型1:通知公告2:系统消息',
  `msg_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '通告对象类型（USER:指定用户，ALL:全体用户）',
  `send_status` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发布状态（0未发布，1已发布，2已撤销）',
  `send_time` datetime NULL DEFAULT NULL COMMENT '发布时间',
  `cancel_time` datetime NULL DEFAULT NULL COMMENT '撤销时间',
  `del_flag` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '删除状态（0，正常，1已删除）',
  `bus_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务类型(email:邮件 bpm:流程)',
  `bus_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务id',
  `open_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '打开方式(组件：component 路由：url)',
  `open_page` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组件/路由 地址',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `user_ids` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '指定用户',
  `msg_abstract` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '摘要',
  `dt_task_id` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '钉钉task_id，用于撤回消息',
  `tenant_id` int NULL DEFAULT 0 COMMENT '租户ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '系统通告表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_announcement
-- ----------------------------

-- ----------------------------
-- Table structure for sys_announcement_send
-- ----------------------------
DROP TABLE IF EXISTS `sys_announcement_send`;
CREATE TABLE `sys_announcement_send`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `annt_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '通告ID',
  `user_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户id',
  `read_flag` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '阅读状态（0未读，1已读）',
  `read_time` datetime NULL DEFAULT NULL COMMENT '阅读时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `star_flag` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '标星状态( 1为标星 空/0没有标星)'
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户通告阅读标记表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_announcement_send
-- ----------------------------

-- ----------------------------
-- Table structure for sys_category
-- ----------------------------
DROP TABLE IF EXISTS `sys_category`;
CREATE TABLE `sys_category`  (
  `id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `pid` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父级节点',
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类型名称',
  `code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '类型编码',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属部门',
  `has_child` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否有子节点',
  `tenant_id` int NULL DEFAULT 0 COMMENT '租户ID',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `index_code`(`code` ASC) USING BTREE,
  INDEX `idx_sc_code`(`code` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_category
-- ----------------------------
INSERT INTO `sys_category` VALUES ('1183693424827564034', '0', '物料树', 'B02', 'admin', '2019-10-14 18:37:59', 'admin', '2019-10-14 18:38:15', 'A01', '1', 0);
INSERT INTO `sys_category` VALUES ('1183693491043041282', '1183693424827564034', '上衣', 'B02A01', 'admin', '2019-10-14 18:38:15', 'admin', '2019-10-14 18:38:43', 'A01', '1', 0);
INSERT INTO `sys_category` VALUES ('1183693534173069314', '1183693424827564034', '裤子', 'B02A02', 'admin', '2019-10-14 18:38:25', NULL, NULL, 'A01', NULL, 0);
INSERT INTO `sys_category` VALUES ('1183693610534567937', '1183693491043041282', '秋衣', 'B02A01A01', 'admin', '2019-10-14 18:38:43', NULL, NULL, 'A01', NULL, 0);
INSERT INTO `sys_category` VALUES ('1183693700254924802', '1183693491043041282', '兵装', 'B02A01A02', 'admin', '2019-10-14 18:39:05', NULL, NULL, 'A01', NULL, 0);
INSERT INTO `sys_category` VALUES ('1183693773974011906', '1183693491043041282', '女装', 'B02A01A03', 'admin', '2019-10-14 18:39:22', NULL, NULL, 'A01', NULL, 0);
INSERT INTO `sys_category` VALUES ('1185039122143719425', '0', '电脑产品', 'A01', 'admin', '2019-10-18 11:45:18', 'admin', '2019-10-18 11:45:31', 'A01', '1', 0);
INSERT INTO `sys_category` VALUES ('1185039176799694850', '1185039122143719425', 'thinkpad', 'A01A01', 'admin', '2019-10-18 11:45:31', NULL, NULL, 'A01', NULL, 0);
INSERT INTO `sys_category` VALUES ('1185039255115739138', '1185039122143719425', 'mackbook', 'A01A02', 'admin', '2019-10-18 11:45:50', NULL, NULL, 'A01', NULL, 0);
INSERT INTO `sys_category` VALUES ('1185039299051073537', '1185039122143719425', '华为电脑', 'A01A03', 'admin', '2019-10-18 11:46:01', NULL, NULL, 'A01', NULL, 0);
INSERT INTO `sys_category` VALUES ('1230769196661510146', '0', '省', NULL, 'admin', '2020-02-21 16:20:16', 'admin', '2020-02-21 16:20:31', 'A01A03', '1', 0);
INSERT INTO `sys_category` VALUES ('1230769253267836929', '1230769196661510146', '安徽省', NULL, 'admin', '2020-02-21 16:20:31', 'admin', '2020-02-21 16:20:53', 'A01A03', '1', 0);
INSERT INTO `sys_category` VALUES ('1230769290609725441', '1230769196661510146', '山东省', NULL, 'admin', '2020-02-21 16:20:40', 'admin', '2020-02-21 16:21:23', 'A01A03', '1', 0);
INSERT INTO `sys_category` VALUES ('1230769347157331969', '1230769253267836929', '合肥市', NULL, 'admin', '2020-02-21 16:20:53', 'admin', '2020-02-21 16:21:08', 'A01A03', '1', 0);
INSERT INTO `sys_category` VALUES ('1230769407907631106', '1230769347157331969', '包河区', NULL, 'admin', '2020-02-21 16:21:08', NULL, NULL, 'A01A03', NULL, 0);
INSERT INTO `sys_category` VALUES ('1230769470889299970', '1230769290609725441', '济南市', NULL, 'admin', '2020-02-21 16:21:23', 'admin', '2020-02-21 16:21:41', 'A01A03', '1', 0);
INSERT INTO `sys_category` VALUES ('1230769547519234050', '1230769470889299970', 'A区', NULL, 'admin', '2020-02-21 16:21:41', NULL, NULL, 'A01A03', NULL, 0);
INSERT INTO `sys_category` VALUES ('1230769620021972993', '1230769470889299970', 'B区', NULL, 'admin', '2020-02-21 16:21:58', NULL, NULL, 'A01A03', NULL, 0);
INSERT INTO `sys_category` VALUES ('1230769769930592257', '1230769253267836929', '淮南市', NULL, 'admin', '2020-02-21 16:22:34', 'admin', '2020-02-21 16:22:54', 'A01A03', '1', 0);
INSERT INTO `sys_category` VALUES ('1230769855347593217', '1230769769930592257', 'C区', NULL, 'admin', '2020-02-21 16:22:54', NULL, NULL, 'A01A03', NULL, 0);
INSERT INTO `sys_category` VALUES ('1590548229606047745', '0', '物料树C', 'C02', 'admin', '2022-11-10 11:33:44', NULL, NULL, 'A01', '1', 0);
INSERT INTO `sys_category` VALUES ('1590548229652185090', '1590548229606047745', '上衣C', 'C02A01', 'admin', '2022-11-10 11:33:44', NULL, NULL, 'A01', '1', 0);
INSERT INTO `sys_category` VALUES ('1590548229668962305', '1590548229606047745', '裤子C', 'C02A02', 'admin', '2022-11-10 11:33:44', NULL, NULL, 'A01', NULL, 0);
INSERT INTO `sys_category` VALUES ('1590548229685739522', '1590548229652185090', '秋衣C', 'C02A01A01', 'admin', '2022-11-10 11:33:44', NULL, NULL, 'A01', NULL, 0);
INSERT INTO `sys_category` VALUES ('22a50b413c5e1ef661fb8aea9469cf52', 'e9ded10fd33e5753face506f4f1564b5', 'MacBook', 'B01-2-1', 'admin', '2019-06-10 15:43:13', NULL, NULL, 'A01', NULL, 0);
INSERT INTO `sys_category` VALUES ('5c8f68845e57f68ab93a2c8d82d26ae1', '0', '笔记本', 'B01', 'admin', '2019-06-10 15:34:11', 'admin', '2019-06-10 15:34:24', 'A01', '1', 0);
INSERT INTO `sys_category` VALUES ('937fd2e9aa13b8bab1da1ca36d3fd344', 'e9ded10fd33e5753face506f4f1564b5', '台式机', 'B01-2-2', 'admin', '2019-06-10 15:43:32', 'admin', '2019-08-21 12:01:59', 'A01', NULL, 0);
INSERT INTO `sys_category` VALUES ('e9ded10fd33e5753face506f4f1564b5', '5c8f68845e57f68ab93a2c8d82d26ae1', '苹果电脑', 'B01-2', 'admin', '2019-06-10 15:41:14', 'admin', '2019-06-10 15:43:13', 'A01', '1', 0);
INSERT INTO `sys_category` VALUES ('f39a06bf9f390ba4a53d11bc4e0018d7', '5c8f68845e57f68ab93a2c8d82d26ae1', '华为', 'B01-1', 'admin', '2019-06-10 15:34:24', 'admin', '2019-08-21 12:01:56', 'A01', NULL, 0);

-- ----------------------------
-- Table structure for sys_check_rule
-- ----------------------------
DROP TABLE IF EXISTS `sys_check_rule`;
CREATE TABLE `sys_check_rule`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `rule_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规则名称',
  `rule_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规则Code',
  `rule_json` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规则JSON',
  `rule_description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规则描述',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uk_scr_rule_code`(`rule_code` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_check_rule
-- ----------------------------
INSERT INTO `sys_check_rule` VALUES ('1224980593992388610', '通用编码规则', 'common', '[{\"digits\":\"1\",\"pattern\":\"^[a-z|A-Z]$\",\"message\":\"第一位只能是字母\"},{\"digits\":\"*\",\"pattern\":\"^[0-9|a-z|A-Z|_]{0,}$\",\"message\":\"只能填写数字、大小写字母、下划线\"},{\"digits\":\"*\",\"pattern\":\"^.{3,}$\",\"message\":\"最少输入3位数\"},{\"digits\":\"*\",\"pattern\":\"^.{3,12}$\",\"message\":\"最多输入12位数\"}]', '规则：1、首位只能是字母；2、只能填写数字、大小写字母、下划线；3、最少3位数，最多12位数。', 'admin', '2020-02-07 11:25:48', 'admin', '2020-02-05 16:58:27');
INSERT INTO `sys_check_rule` VALUES ('1225001845524004866', '负责的功能测试', 'test', '[{\"digits\":\"*\",\"pattern\":\"^.{3,12}$\",\"message\":\"只能输入3-12位字符\"},{\"digits\":\"3\",\"pattern\":\"^\\\\d{3}$\",\"message\":\"前3位必须是数字\"},{\"digits\":\"*\",\"pattern\":\"^[^pP]*$\",\"message\":\"不能输入P\"},{\"digits\":\"4\",\"pattern\":\"^@{4}$\",\"message\":\"第4-7位必须都为 @\"},{\"digits\":\"2\",\"pattern\":\"^#=$\",\"message\":\"第8-9位必须是 #=\"},{\"digits\":\"1\",\"pattern\":\"^O$\",\"message\":\"第10位必须为大写的O\"},{\"digits\":\"*\",\"pattern\":\"^.*。$\",\"message\":\"必须以。结尾\"}]', '包含长度校验、特殊字符校验等', 'admin', '2020-02-07 11:57:31', 'admin', '2020-02-05 18:22:54');

-- ----------------------------
-- Table structure for sys_comment
-- ----------------------------
DROP TABLE IF EXISTS `sys_comment`;
CREATE TABLE `sys_comment`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `table_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '表名',
  `table_data_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '数据id',
  `from_user_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '来源用户id',
  `to_user_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发送给用户id(允许为空)',
  `comment_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '评论id(允许为空，不为空时，则为回复)',
  `comment_content` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '回复内容',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_table_data_id`(`table_name` ASC, `table_data_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '系统评论回复表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_comment
-- ----------------------------

-- ----------------------------
-- Table structure for sys_data_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_data_log`;
CREATE TABLE `sys_data_log`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `data_table` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '表名',
  `data_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据ID',
  `data_content` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '数据内容',
  `data_version` int NULL DEFAULT NULL COMMENT '版本号',
  `type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'json' COMMENT '类型',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_sdl_data_table_id`(`data_table` ASC, `data_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_data_log
-- ----------------------------

-- ----------------------------
-- Table structure for sys_data_source
-- ----------------------------
DROP TABLE IF EXISTS `sys_data_source`;
CREATE TABLE `sys_data_source`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据源编码',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据源名称',
  `remark` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `db_type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据库类型',
  `db_driver` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '驱动类',
  `db_url` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据源地址',
  `db_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据库名称',
  `db_username` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户名',
  `db_password` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '密码',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属部门',
  `tenant_id` int NULL DEFAULT 0 COMMENT '租户ID',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uk_sdc_rule_code`(`code` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_data_source
-- ----------------------------
INSERT INTO `sys_data_source` VALUES ('1209779538310004737', 'local_mysql', 'MySQL5.7', '本地数据库MySQL5.7', '1', 'com.mysql.jdbc.Driver', 'jdbc:mysql://127.0.0.1:3306/jeecg-boot?characterEncoding=UTF-8&useUnicode=true&useSSL=false', 'jeecg-boot', 'root', 'f5b6775e8d1749483f2320627de0e706', 'admin', '2019-12-25 18:14:53', 'admin', '2020-07-10 16:54:42', 'A01', 0);

-- ----------------------------
-- Table structure for sys_depart
-- ----------------------------
DROP TABLE IF EXISTS `sys_depart`;
CREATE TABLE `sys_depart`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
  `parent_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父机构ID',
  `depart_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '机构/部门名称',
  `depart_name_en` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '英文名',
  `depart_name_abbr` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '缩写',
  `depart_order` int NULL DEFAULT 0 COMMENT '排序',
  `description` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `org_category` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '1' COMMENT '机构类别 1公司，2组织机构，2岗位',
  `org_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '机构类型 1一级部门 2子部门',
  `org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '机构编码',
  `mobile` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '手机号',
  `fax` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '传真',
  `address` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '地址',
  `memo` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `status` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '状态（1启用，0不启用）',
  `del_flag` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '删除状态（0，正常，1已删除）',
  `qywx_identifier` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '对接企业微信的ID',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `tenant_id` int NULL DEFAULT 0 COMMENT '租户ID',
  `iz_leaf` tinyint(1) NULL DEFAULT 0 COMMENT '是否有叶子节点: 1是0否',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uniq_depart_org_code`(`org_code` ASC) USING BTREE,
  INDEX `idx_sd_parent_id`(`parent_id` ASC) USING BTREE,
  INDEX `idx_sd_depart_order`(`depart_order` ASC) USING BTREE,
  INDEX `idx_sd_org_code`(`org_code` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '组织机构表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_depart
-- ----------------------------
INSERT INTO `sys_depart` VALUES ('1582683631414632450', 'c6d7cb4deeac411cb3384b1b31278596', '销售公关岗位', NULL, NULL, 0, NULL, '3', '2', 'A01A06', NULL, NULL, NULL, NULL, NULL, '0', NULL, 'admin', '2022-10-19 18:42:37', NULL, NULL, 0, 0);
INSERT INTO `sys_depart` VALUES ('1668512815523491841', '', '北京腾信软创', NULL, NULL, 0, NULL, '1', '1', 'A03', NULL, NULL, NULL, NULL, NULL, '0', NULL, 'admin', '2023-06-13 14:57:09', NULL, NULL, 0, 0);
INSERT INTO `sys_depart` VALUES ('1668512894611288066', '1668512815523491841', '研发组', NULL, NULL, 0, NULL, '2', '2', 'A03A01', NULL, NULL, NULL, NULL, NULL, '0', NULL, 'admin', '2023-06-13 14:57:28', NULL, NULL, 0, 1);
INSERT INTO `sys_depart` VALUES ('4f1765520d6346f9bd9c79e2479e5b12', 'c6d7cb4deeac411cb3384b1b31278596', '市场部', NULL, NULL, 0, NULL, '1', '2', 'A01A03', NULL, NULL, NULL, NULL, NULL, '0', NULL, 'admin', '2019-02-20 17:15:34', 'admin', '2019-02-26 16:36:18', 0, 0);
INSERT INTO `sys_depart` VALUES ('5159cde220114246b045e574adceafe9', '6d35e179cd814e3299bd588ea7daed3f', '研发部', NULL, NULL, 0, NULL, '1', '2', 'A02A02', NULL, NULL, NULL, NULL, NULL, '0', NULL, 'admin', '2019-02-26 16:44:38', 'admin', '2019-03-07 09:36:53', 0, 0);
INSERT INTO `sys_depart` VALUES ('57197590443c44f083d42ae24ef26a2c', 'c6d7cb4deeac411cb3384b1b31278596', '研发部', NULL, NULL, 0, NULL, '1', '2', 'A01A05', NULL, NULL, NULL, NULL, NULL, '0', NULL, 'admin', '2019-02-21 16:14:41', 'admin', '2019-03-27 19:05:49', 0, 0);
INSERT INTO `sys_depart` VALUES ('63775228b7b041a99825f79760590b7d', '57197590443c44f083d42ae24ef26a2c', '研发经理', NULL, NULL, 0, NULL, '3', '3', 'A01A05A01', NULL, NULL, NULL, NULL, NULL, '0', NULL, 'admin', '2020-05-02 15:29:09', NULL, NULL, 0, 0);
INSERT INTO `sys_depart` VALUES ('67fc001af12a4f9b8458005d3f19934a', 'c6d7cb4deeac411cb3384b1b31278596', '财务部', NULL, NULL, 0, NULL, '1', '2', 'A01A04', NULL, NULL, NULL, NULL, NULL, '0', NULL, 'admin', '2019-02-21 16:14:35', 'admin', '2019-02-25 12:49:41', 0, 0);
INSERT INTO `sys_depart` VALUES ('6d35e179cd814e3299bd588ea7daed3f', '', '北京卓尔互动', NULL, NULL, 0, NULL, '1', '1', 'A02', NULL, NULL, NULL, NULL, NULL, '0', NULL, 'admin', '2019-02-26 16:36:39', 'admin', '2020-05-02 18:21:22', 0, 0);
INSERT INTO `sys_depart` VALUES ('a7d7e77e06c84325a40932163adcdaa6', '6d35e179cd814e3299bd588ea7daed3f', '财务部', NULL, NULL, 0, NULL, '1', '2', 'A02A01', NULL, NULL, NULL, NULL, NULL, '0', NULL, 'admin', '2019-02-26 16:36:47', 'admin', '2022-10-14 18:57:56', 0, 0);
INSERT INTO `sys_depart` VALUES ('c6d7cb4deeac411cb3384b1b31278596', '', '北京国炬软件', NULL, NULL, 0, NULL, '1', '1', 'A01', NULL, NULL, NULL, NULL, NULL, '0', NULL, 'admin', '2019-02-11 14:21:51', 'admin', '2020-05-02 18:21:27', 0, 0);

-- ----------------------------
-- Table structure for sys_depart_permission
-- ----------------------------
DROP TABLE IF EXISTS `sys_depart_permission`;
CREATE TABLE `sys_depart_permission`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `depart_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门id',
  `permission_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '权限id',
  `data_rule_ids` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据规则id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '部门权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_depart_permission
-- ----------------------------
INSERT INTO `sys_depart_permission` VALUES ('1260925131934519297', '6d35e179cd814e3299bd588ea7daed3f', 'f0675b52d89100ee88472b6800754a08', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1260925131947102209', '6d35e179cd814e3299bd588ea7daed3f', '2aeddae571695cd6380f6d6d334d6e7d', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1260925131955490818', '6d35e179cd814e3299bd588ea7daed3f', '020b06793e4de2eee0007f603000c769', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1260925131959685121', '6d35e179cd814e3299bd588ea7daed3f', '1232123780958064642', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080246988802', '1668512894611288066', 'd7d6e2e4e2934f2c9385a623fd98c6f3', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080251183106', '1668512894611288066', '3f915b2769fc80648e92d04e84ca059d', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080251183107', '1668512894611288066', '1588513553652436993', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080267960321', '1668512894611288066', '1592114574275211265', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080267960322', '1668512894611288066', '1592114652566089729', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080267960323', '1668512894611288066', '1592114721138765826', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080267960324', '1668512894611288066', '1592114772665790465', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080267960325', '1668512894611288066', '1592114823467200514', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080272154626', '1668512894611288066', '1592114893302362114', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080272154627', '1668512894611288066', '1592114955650691074', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080272154628', '1668512894611288066', '1592115070432014338', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080276348929', '1668512894611288066', '1592115115361398786', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080276348930', '1668512894611288066', '1592115162379546625', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080276348931', '1668512894611288066', '1592115213910765570', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080276348932', '1668512894611288066', '1592135223910765570', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080276348933', '1668512894611288066', '1593185714482880514', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080280543234', '1668512894611288066', '15c92115213910765570', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080284737537', '1668512894611288066', '1d592115213910765570', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080284737538', '1668512894611288066', '1214376304951664642', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080284737539', '1668512894611288066', '1214462306546319362', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080284737540', '1668512894611288066', '1a0811914300741f4e11838ff37a1d3a', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080284737541', '1668512894611288066', '190c2b43bec6a5f7a4194a85db67d96a', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080284737542', '1668512894611288066', '1170592628746878978', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080288931842', '1668512894611288066', '45c966826eeff4c99b8f8ebfe74511fc', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513080288931844', '1668512894611288066', '1438782641187074050', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339949903874', '1668512894611288066', '1592113148350263298', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339958292481', '1668512894611288066', '1592120224120850434', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339958292482', '1668512894611288066', '1592120323667750914', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339958292483', '1668512894611288066', '1592120372296511490', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339958292484', '1668512894611288066', '1592120427007012865', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339958292485', '1668512894611288066', '1592120484120850434', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339958292486', '1668512894611288066', '1592120594695286785', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486785', '1668512894611288066', '1592120649007329281', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486786', '1668512894611288066', '1592112984361365505', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486787', '1668512894611288066', '1592115914493751297', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486788', '1668512894611288066', '1592118604640645122', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486789', '1668512894611288066', '1592118648315932674', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486790', '1668512894611288066', '1592116663936184322', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486791', '1668512894611288066', '1592119001883176961', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486792', '1668512894611288066', '1592120052866707457', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486793', '1668512894611288066', '1592115712466710529', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486794', '1668512894611288066', '1592117276539449345', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486795', '1668512894611288066', '1592117222764277761', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486796', '1668512894611288066', '1592117377299214337', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486797', '1668512894611288066', '1592117422006300673', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486798', '1668512894611288066', '1592120222727630849', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486799', '1668512894611288066', '1438469604861403137', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486800', '1668512894611288066', '1438782851980210178', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339962486801', '1668512894611288066', '1438782530717495298', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339966681089', '1668512894611288066', '1455735714507472898', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339966681090', '1668512894611288066', '1596141938193747970', NULL);
INSERT INTO `sys_depart_permission` VALUES ('1668513339966681091', '1668512894611288066', '1596335805278990338', NULL);

-- ----------------------------
-- Table structure for sys_depart_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_depart_role`;
CREATE TABLE `sys_depart_role`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `depart_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门id',
  `role_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门角色名称',
  `role_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门角色编码',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '部门角色表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_depart_role
-- ----------------------------
INSERT INTO `sys_depart_role` VALUES ('1260925293226479618', '6d35e179cd814e3299bd588ea7daed3f', 'roless', 'ssss', NULL, 'admin', '2020-05-14 21:29:51', NULL, NULL);

-- ----------------------------
-- Table structure for sys_depart_role_permission
-- ----------------------------
DROP TABLE IF EXISTS `sys_depart_role_permission`;
CREATE TABLE `sys_depart_role_permission`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `depart_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门id',
  `role_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '角色id',
  `permission_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '权限id',
  `data_rule_ids` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据权限ids',
  `operate_date` datetime NULL DEFAULT NULL COMMENT '操作时间',
  `operate_ip` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作ip',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_sdrp_role_per_id`(`role_id` ASC, `permission_id` ASC) USING BTREE,
  INDEX `idx_sdrp_role_id`(`role_id` ASC) USING BTREE,
  INDEX `idx_sdrp_per_id`(`permission_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '部门角色权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_depart_role_permission
-- ----------------------------
INSERT INTO `sys_depart_role_permission` VALUES ('1260925328689319938', NULL, '1260925293226479618', '2aeddae571695cd6380f6d6d334d6e7d', NULL, NULL, NULL);
INSERT INTO `sys_depart_role_permission` VALUES ('1260925328706097153', NULL, '1260925293226479618', '020b06793e4de2eee0007f603000c769', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for sys_depart_role_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_depart_role_user`;
CREATE TABLE `sys_depart_role_user`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `user_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户id',
  `drole_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '角色id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '部门角色用户表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_depart_role_user
-- ----------------------------

-- ----------------------------
-- Table structure for sys_dict
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict`;
CREATE TABLE `sys_dict`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `dict_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典名称',
  `dict_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典编码',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `del_flag` int NULL DEFAULT NULL COMMENT '删除状态',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `tenant_id` int NULL DEFAULT 0 COMMENT '租户ID',
  `low_app_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '低代码应用ID',
  `type` int(1) UNSIGNED ZEROFILL NULL DEFAULT 0 COMMENT '字典类型0为string,1为number',
  `operate_type` tinyint(1) NULL DEFAULT 0 COMMENT '0-编辑 1-冻结 2-可编辑不可删除',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uk_sd_dict_code`(`dict_code` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_dict
-- ----------------------------
INSERT INTO `sys_dict` VALUES ('1683378762893938689', '道床类型', 'track_bed_opt', '道床类型下拉数据', 1, 'admin', '2023-07-24 15:29:07', NULL, NULL, 0, NULL, 1, 0);
INSERT INTO `sys_dict` VALUES ('1683379205292347394', '道床类型', 'track_bed_opts', '道床类型下拉数据', 0, 'admin', '2023-07-24 15:30:53', NULL, NULL, 0, NULL, 1, 0);
INSERT INTO `sys_dict` VALUES ('1683379363111424001', '轨枕类型', 'sleeper_opts', '轨枕类型下拉数据', 0, 'admin', '2023-07-24 15:31:31', NULL, NULL, 0, NULL, 1, 0);
INSERT INTO `sys_dict` VALUES ('1683379532561305602', '扣件类型', 'fastener_opts', '扣件类型下拉数据', 0, 'admin', '2023-07-24 15:32:11', NULL, NULL, 0, NULL, 1, 0);
INSERT INTO `sys_dict` VALUES ('1683379669887012866', '标识牌类型', 'sign_board_opts', '标识牌类型下拉数据', 0, 'admin', '2023-07-24 15:32:44', NULL, NULL, 0, NULL, 1, 0);
INSERT INTO `sys_dict` VALUES ('1683381403808092162', '设备单元类型', 'equipment_unit_opts', '设备单元类型下拉数据', 0, 'admin', '2023-07-24 15:39:37', NULL, NULL, 0, NULL, 1, 0);
INSERT INTO `sys_dict` VALUES ('1683383335985532930', '设备超限类型', 'equipment_outlimit_opts', '超限类型', 0, 'admin', '2023-07-24 15:47:18', NULL, NULL, 0, NULL, 1, 0);
INSERT INTO `sys_dict` VALUES ('1683383531339436033', '设备速度等级', 'equipment_speed_opts', '速度等级', 0, 'admin', '2023-07-24 15:48:04', NULL, NULL, 0, NULL, 1, 0);
INSERT INTO `sys_dict` VALUES ('1688472789104132098', '12345', '12345', '', 1, 'admin', '2023-08-07 16:50:58', NULL, NULL, 0, NULL, 0, 0);

-- ----------------------------
-- Table structure for sys_dict_item
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_item`;
CREATE TABLE `sys_dict_item`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `dict_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字典id',
  `item_text` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典项文本',
  `item_value` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典项值',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `sort_order` int NULL DEFAULT NULL COMMENT '排序',
  `status` int NULL DEFAULT NULL COMMENT '状态（1启用 0不启用）',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `create_time` datetime NULL DEFAULT NULL,
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `update_time` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_sdi_role_dict_id`(`dict_id` ASC) USING BTREE,
  INDEX `idx_sdi_role_sort_order`(`sort_order` ASC) USING BTREE,
  INDEX `idx_sdi_status`(`status` ASC) USING BTREE,
  INDEX `idx_sdi_dict_val`(`dict_id` ASC, `item_value` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_dict_item
-- ----------------------------
INSERT INTO `sys_dict_item` VALUES ('1683378847593713666', '1683378762893938689', '长轨枕整体道床', '1', '', 1, 1, 'admin', '2023-07-24 15:29:28', NULL, NULL);
INSERT INTO `sys_dict_item` VALUES ('1683379015483314177', '1683378762893938689', '短轨枕整体道床', '2', '', 2, 1, 'admin', '2023-07-24 15:30:08', NULL, NULL);
INSERT INTO `sys_dict_item` VALUES ('1683383919530659841', '1683379205292347394', '长轨枕整体道床', '1', '11', 1, 1, 'admin', '2023-07-24 15:49:37', 'admin', '2023-07-24 15:52:47');
INSERT INTO `sys_dict_item` VALUES ('1683383980696195074', '1683379205292347394', '短轨枕整体道床', '2', '', 2, 1, 'admin', '2023-07-24 15:49:51', NULL, NULL);
INSERT INTO `sys_dict_item` VALUES ('1683387302295556097', '1683383531339436033', '0 ＜ V ≤ 80', '1', '', 1, 1, 'admin', '2023-07-24 16:03:03', NULL, NULL);
INSERT INTO `sys_dict_item` VALUES ('1683387415252357122', '1683383531339436033', '80 ＜V ≤ 120', '2', '', 2, 1, 'admin', '2023-07-24 16:03:30', NULL, NULL);
INSERT INTO `sys_dict_item` VALUES ('1683388895732617217', '1683379532561305602', 'DTVI2-1', '1', '', 1, 1, 'admin', '2023-07-24 16:09:23', NULL, NULL);
INSERT INTO `sys_dict_item` VALUES ('1683388951688826882', '1683379532561305602', 'I型弹条分开始可调扣件', '2', '', 2, 1, 'admin', '2023-07-24 16:09:37', NULL, NULL);
INSERT INTO `sys_dict_item` VALUES ('1683389003681419265', '1683379532561305602', '双层弹性垫板减震扣件', '3', '', 3, 1, 'admin', '2023-07-24 16:09:49', NULL, NULL);
INSERT INTO `sys_dict_item` VALUES ('1683389107343642625', '1683379363111424001', '混凝土长轨枕', '1', '', 1, 1, 'admin', '2023-07-24 16:10:14', NULL, NULL);
INSERT INTO `sys_dict_item` VALUES ('1683389239350972417', '1683379363111424001', '混凝土短轨枕', '2', '', 2, 1, 'admin', '2023-07-24 16:10:45', NULL, NULL);
INSERT INTO `sys_dict_item` VALUES ('1686193979352813569', '1683383531339436033', '120 ＜V ≤ 160', '3', '', 3, 1, 'admin', '2023-08-01 09:55:47', 'admin', '2023-08-01 09:55:47');
INSERT INTO `sys_dict_item` VALUES ('1686194034277224450', '1683383531339436033', '160 ＜V ≤ 200', '4', '', 4, 1, 'admin', '2023-08-01 09:56:00', 'admin', '2023-08-01 09:56:00');
INSERT INTO `sys_dict_item` VALUES ('1686708089592905729', '1683379669887012866', '等待', '1', '', 1, 1, 'admin', '2023-08-02 19:58:41', NULL, NULL);
INSERT INTO `sys_dict_item` VALUES ('1686708165518196738', '1683379669887012866', '严禁进入', '2', '', 1, 1, 'admin', '2023-08-02 19:58:59', NULL, NULL);

-- ----------------------------
-- Table structure for sys_files
-- ----------------------------
DROP TABLE IF EXISTS `sys_files`;
CREATE TABLE `sys_files`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `file_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件名称',
  `url` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件地址',
  `file_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文档类型（folder:文件夹 excel:excel doc:word ppt:ppt image:图片  archive:其他文档 video:视频 pdf:pdf）',
  `store_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件上传类型(temp/本地上传(临时文件) manage/知识库)',
  `parent_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父级id',
  `tenant_id` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '租户id',
  `file_size` double(13, 2) NULL DEFAULT NULL COMMENT '文件大小（kb）',
  `iz_folder` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否文件夹(1：是  0：否)',
  `iz_root_folder` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否为1级文件夹，允许为空 (1：是 )',
  `iz_star` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否标星(1：是  0：否)',
  `down_count` int NULL DEFAULT NULL COMMENT '下载次数',
  `read_count` int NULL DEFAULT NULL COMMENT '阅读次数',
  `share_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分享链接',
  `share_perms` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '分享权限(1.关闭分享 2.允许所有联系人查看 3.允许任何人查看)',
  `enable_down` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否允许下载(1：是  0：否)',
  `enable_updat` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否允许修改(1：是  0：否)',
  `del_flag` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '删除状态(0-正常,1-删除至回收站)',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_tenant_id`(`tenant_id` ASC) USING BTREE,
  INDEX `index_del_flag`(`del_flag` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '知识库-文档管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_files
-- ----------------------------
INSERT INTO `sys_files` VALUES ('1580814573568143361', '11.jpg', 'comment/11_1665730539114.jpg', 'image', 'temp', NULL, NULL, 10956.00, '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, '0', 'admin', '2022-10-14 14:55:39', NULL, NULL);
INSERT INTO `sys_files` VALUES ('1584493984691740674', 'jeecg-boot漏洞.pdf', 'comment/jeecg-boot漏洞_1666607779077.pdf', 'pdf', 'temp', NULL, NULL, 842789.00, '0', '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, '0', 'admin', '2022-10-24 18:36:19', NULL, NULL);

-- ----------------------------
-- Table structure for sys_fill_rule
-- ----------------------------
DROP TABLE IF EXISTS `sys_fill_rule`;
CREATE TABLE `sys_fill_rule`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `rule_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规则名称',
  `rule_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规则Code',
  `rule_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规则实现类',
  `rule_params` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规则参数',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uk_sfr_rule_code`(`rule_code` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_fill_rule
-- ----------------------------
INSERT INTO `sys_fill_rule` VALUES ('1202551334738382850', '机构编码生成', 'org_num_role', 'org.jeecg.modules.system.rule.OrgCodeRule', '{\"parentId\":\"c6d7cb4deeac411cb3384b1b31278596\"}', 'admin', '2019-12-09 10:37:06', 'admin', '2019-12-05 19:32:35');
INSERT INTO `sys_fill_rule` VALUES ('1202787623203065858', '分类字典编码生成', 'category_code_rule', 'org.jeecg.modules.system.rule.CategoryCodeRule', '{\"pid\":\"\"}', 'admin', '2022-10-13 16:47:52', 'admin', '2019-12-06 11:11:31');
INSERT INTO `sys_fill_rule` VALUES ('1260134137920090113', '订单流水号', 'shop_order_num', 'org.jeecg.modules.online.cgform.rule.OrderNumberRule', '{}', 'admin', '2020-12-07 18:29:50', 'admin', '2020-05-12 17:06:05');

-- ----------------------------
-- Table structure for sys_form_file
-- ----------------------------
DROP TABLE IF EXISTS `sys_form_file`;
CREATE TABLE `sys_form_file`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `table_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '表名',
  `table_data_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '数据id',
  `file_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '关联文件id',
  `file_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '文件类型(text:文本, excel:excel doc:word ppt:ppt image:图片  archive:其他文档 video:视频 pdf:pdf）)',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_table_form`(`table_name` ASC, `table_data_id` ASC) USING BTREE,
  INDEX `index_file_id`(`file_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_form_file
-- ----------------------------
INSERT INTO `sys_form_file` VALUES ('1580814573635252225', 'sys_comment', '1580814573433925634', '1580814573568143361', 'image', 'admin', '2022-10-14 14:55:39');
INSERT INTO `sys_form_file` VALUES ('1584493984716906497', 'sys_comment', '1584493984364584961', '1584493984691740674', 'pdf', 'admin', '2022-10-24 18:36:19');

-- ----------------------------
-- Table structure for sys_gateway_route
-- ----------------------------
DROP TABLE IF EXISTS `sys_gateway_route`;
CREATE TABLE `sys_gateway_route`  (
  `id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `router_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '路由ID',
  `name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '服务名',
  `uri` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '服务地址',
  `predicates` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '断言',
  `filters` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '过滤器',
  `retryable` int NULL DEFAULT NULL COMMENT '是否重试:0-否 1-是',
  `strip_prefix` int NULL DEFAULT NULL COMMENT '是否忽略前缀0-否 1-是',
  `persistable` int NULL DEFAULT NULL COMMENT '是否为保留数据:0-否 1-是',
  `show_api` int NULL DEFAULT NULL COMMENT '是否在接口文档中展示:0-否 1-是',
  `status` int NULL DEFAULT NULL COMMENT '状态:0-无效 1-有效',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属部门',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_gateway_route
-- ----------------------------
INSERT INTO `sys_gateway_route` VALUES ('1331051599401857026', 'jeecg-demo-websocket', 'jeecg-demo-websocket', 'lb:ws://jeecg-demo', '[{\"args\":[\"/vxeSocket/**\"],\"name\":\"Path\"}]', '[]', NULL, NULL, NULL, NULL, 1, 'admin', '2020-11-24 09:46:46', NULL, NULL, NULL);
INSERT INTO `sys_gateway_route` VALUES ('jeecg-cloud-websocket', 'jeecg-system-websocket', 'jeecg-system-websocket', 'lb:ws://jeecg-system', '[{\"args\":[\"/websocket/**\",\"/eoaSocket/**\",\"/newsWebsocket/**\"],\"name\":\"Path\"}]', '[]', NULL, NULL, NULL, NULL, 1, 'admin', '2020-11-16 19:41:51', NULL, NULL, NULL);
INSERT INTO `sys_gateway_route` VALUES ('jeecg-demo', 'jeecg-demo', 'jeecg-demo', 'lb://jeecg-demo', '[{\"args\":[\"/mock/**\",\"/bigscreen/template1/**\",\"/bigscreen/template2/**\",\"/test/**\"],\"name\":\"Path\"}]', '[]', NULL, NULL, NULL, NULL, 1, 'admin', '2020-11-16 19:41:51', NULL, NULL, NULL);
INSERT INTO `sys_gateway_route` VALUES ('jeecg-system', 'jeecg-system', 'jeecg-system', 'lb://jeecg-system', '[{\"args\":[\"/sys/**\",\"/online/**\",\"/bigscreen/**\",\"/jmreport/**\",\"/druid/**\",\"/generic/**\"],\"name\":\"Path\"}]', '[]', NULL, NULL, NULL, NULL, 1, 'admin', '2020-11-16 19:41:51', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for sys_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_log`;
CREATE TABLE `sys_log`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `log_type` int NULL DEFAULT NULL COMMENT '日志类型（1登录日志，2操作日志, 3.租户操作日志）',
  `log_content` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '日志内容',
  `operate_type` int NULL DEFAULT NULL COMMENT '操作类型',
  `userid` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作用户账号',
  `username` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作用户名称',
  `ip` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'IP',
  `method` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请求java方法',
  `request_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请求路径',
  `request_param` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '请求参数',
  `request_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请求类型',
  `cost_time` bigint NULL DEFAULT NULL COMMENT '耗时',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `tenant_id` int NULL DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_sl_userid`(`userid`) USING BTREE,
  INDEX `idx_sl_log_type`(`log_type`) USING BTREE,
  INDEX `idx_sl_operate_type`(`operate_type`) USING BTREE,
  INDEX `idx_sl_create_time`(`create_time`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '系统日志表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_log
-- ----------------------------

-- ----------------------------
-- Table structure for sys_permission
-- ----------------------------
DROP TABLE IF EXISTS `sys_permission`;
CREATE TABLE `sys_permission`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `parent_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '父id',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '菜单标题',
  `url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '路径',
  `component` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组件',
  `is_route` tinyint(1) NULL DEFAULT 1 COMMENT '是否路由菜单: 0:不是  1:是（默认值1）',
  `component_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组件名字',
  `redirect` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '一级菜单跳转地址',
  `menu_type` int NULL DEFAULT NULL COMMENT '菜单类型(0:一级菜单; 1:子菜单:2:按钮权限)',
  `perms` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '菜单权限编码',
  `perms_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '权限策略1显示2禁用',
  `sort_no` double(8, 2) NULL DEFAULT NULL COMMENT '菜单排序',
  `always_show` tinyint(1) NULL DEFAULT NULL COMMENT '聚合子路由: 1是0否',
  `icon` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '菜单图标',
  `is_leaf` tinyint(1) NULL DEFAULT NULL COMMENT '是否叶子节点:    1是0否',
  `keep_alive` tinyint(1) NULL DEFAULT NULL COMMENT '是否缓存该页面:    1:是   0:不是',
  `hidden` int NULL DEFAULT 0 COMMENT '是否隐藏路由: 0否,1是',
  `hide_tab` int NULL DEFAULT NULL COMMENT '是否隐藏tab: 0否,1是',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `create_by` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `del_flag` int NULL DEFAULT 0 COMMENT '删除状态 0正常 1已删除',
  `rule_flag` int NULL DEFAULT 0 COMMENT '是否添加数据权限1是0否',
  `status` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '按钮权限状态(0无效1有效)',
  `internal_or_external` tinyint(1) NULL DEFAULT NULL COMMENT '外链菜单打开方式 0/内部打开 1/外部打开',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_menu_type`(`menu_type` ASC) USING BTREE,
  INDEX `index_menu_hidden`(`hidden` ASC) USING BTREE,
  INDEX `index_menu_status`(`status` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '菜单权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_permission
-- ----------------------------
INSERT INTO `sys_permission` VALUES ('1676114112963887105', '', '首页', '/home', '@/views/home/index', 1, NULL, '', 0, NULL, '0', 1.00, 1, 'Medal', 1, 0, 0, 0, NULL, 'admin', '2023-07-04 14:22:00', 'admin', '2023-07-04 20:39:11', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676120854443540481', '', '线路车站', '/lineStation', '', 1, NULL, '', 0, NULL, '0', 2.00, 1, 'Baseball', 0, 0, 0, 0, NULL, 'admin', '2023-07-04 14:48:47', 'admin', '2023-07-04 15:23:30', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676121595329593345', '1676120854443540481', '线路管理', '/lineManage', '@/views/lineStation/lineManage/index', 1, NULL, '', 1, NULL, '0', 1.00, 1, 'Calendar', 1, 0, 0, 0, NULL, 'admin', '2023-07-04 14:51:44', 'admin', '2023-07-13 20:01:25', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676122070149971969', '1676120854443540481', '车站管理', '/stationManage', '@/views/lineStation/stationManage/index', 1, NULL, '', 1, NULL, '0', 3.00, 1, 'Apple', 1, 0, 0, 0, NULL, 'admin', '2023-07-04 14:53:37', 'admin', '2023-08-24 11:20:48', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676122308696817666', '1676120854443540481', '区间管理', '/areaManage', '@/views/lineStation/areaManage/index', 1, NULL, '', 1, NULL, '0', 4.00, 1, 'Apple', 1, 0, 0, 0, NULL, 'admin', '2023-07-04 14:54:34', 'admin', '2023-08-24 11:20:55', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676122832305340417', '', '系统设置', '/system', '', 1, NULL, '', 0, NULL, '0', 7.00, 1, 'Setting', 0, 0, 0, 0, NULL, 'admin', '2023-07-04 14:56:39', 'admin', '2023-07-07 13:38:59', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676123076355112961', '1676122832305340417', '用户管理', '/userManage', '@/views/system/userManage/index', 1, NULL, '', 1, NULL, '0', 1.00, 1, 'Avatar', 1, 0, 0, 0, NULL, 'admin', '2023-07-04 14:57:37', 'admin', '2023-07-04 20:39:51', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676123379443908609', '1676122832305340417', '角色管理', '/roleManage', '@/views/system/roleManage/index', 1, NULL, '', 1, NULL, '0', 2.00, 1, 'Avatar', 1, 0, 0, 0, NULL, 'admin', '2023-07-04 14:58:49', 'admin', '2023-07-04 20:39:58', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676124077023772674', '1676122832305340417', '系统菜单', '/menuManage', '@/views/system/menuManage/index', 1, NULL, '', 1, NULL, '0', 3.00, 1, 'Menu', 0, 0, 0, 0, NULL, 'admin', '2023-07-04 15:01:36', 'admin', '2023-07-04 20:40:04', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676124443723382786', '1676124077023772674', '新增菜单', NULL, NULL, 0, NULL, '', 2, 'system:permission:add', '1', NULL, 1, '', 1, 0, 0, 0, NULL, 'admin', '2023-07-04 15:03:03', NULL, NULL, 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676125726677090306', '1676124077023772674', '编辑菜单', NULL, NULL, 0, NULL, '', 2, 'system:permission:edit', '1', NULL, 1, '', 1, 0, 0, 0, NULL, 'admin', '2023-07-04 15:08:09', NULL, NULL, 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676129090928328705', '1676124077023772674', '批量删除', NULL, NULL, 0, NULL, '', 2, 'system:permission:deleteBatch', '1', NULL, 1, '', 1, 0, 0, 0, NULL, 'admin', '2023-07-04 15:21:31', NULL, NULL, 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676129326035845122', '1676122832305340417', '数据字典', '/dictManage', '@/views/system/dictManage/index', 1, NULL, '', 1, NULL, '0', 4.00, 1, 'Avatar', 1, 0, 0, 0, NULL, 'admin', '2023-07-04 15:22:27', 'admin', '2023-07-04 20:40:10', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676411157582839810', NULL, '设备资产', '/equipment', '', 1, NULL, '', 0, NULL, '0', 3.00, 1, 'List', 0, 0, 0, 0, NULL, 'admin', '2023-07-05 10:02:21', NULL, NULL, 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676411731825000449', '1676411157582839810', '钢轨管理', '/railManage', '@/views/euipment/railManage/index', 1, NULL, '', 1, NULL, '0', 1.00, 1, 'GoldMedal', 1, 0, 0, 0, NULL, 'admin', '2023-07-05 10:04:38', 'admin', '2023-07-05 10:05:05', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676417724554280961', '1676411157582839810', '道岔管理', '/turnoutManage', '@views/equipment/turnoutManage/index', 1, NULL, '', 1, NULL, '0', 2.00, 1, 'BrushFilled', 1, 0, 0, 0, NULL, 'admin', '2023-07-05 10:28:27', NULL, NULL, 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676417901943980034', '1676411157582839810', '曲线管理', '/curveManage', '@views/equipment/curveManage/index', 1, NULL, '', 1, NULL, '0', 3.00, 1, 'BrushFilled', 1, 0, 0, 0, NULL, 'admin', '2023-07-05 10:29:09', 'admin', '2023-07-05 10:30:26', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676418150146113537', '1676411157582839810', '竖曲线管理', '/verticalCurveManage', '@views/equipment/verticalCurveManage/index', 1, NULL, '', 1, NULL, '0', 4.00, 1, 'Brush', 1, 0, 0, 0, NULL, 'admin', '2023-07-05 10:30:08', 'admin', '2023-07-05 10:40:51', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676418456816844801', '1676411157582839810', '扣件管理', '/fastenerManage', '@views/equipment/fastenerManage/index', 1, NULL, '', 1, NULL, '0', 7.00, 1, 'Briefcase', 1, 0, 0, 0, NULL, 'admin', '2023-07-05 10:31:21', 'admin', '2023-07-19 17:17:00', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676418627248193537', '1676411157582839810', '轨枕管理', '/sleeperManage', '@views/equipment/sleeperManage/index', 1, NULL, '', 1, NULL, '0', 6.00, 1, 'Brush', 1, 0, 0, 0, NULL, 'admin', '2023-07-05 10:32:02', NULL, NULL, 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676418820156817410', '1676411157582839810', '道床管理', '/trackBedManage', '@views/equipment/trackBedManage/index', 1, NULL, '', 1, NULL, '0', 5.00, 1, 'BrushFilled', 1, 0, 0, 0, NULL, 'admin', '2023-07-05 10:32:48', 'admin', '2023-07-19 17:17:07', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676419000495112193', '1676411157582839810', '轨行区标识牌管理', '/signBoardManage', '@views/equipment/signBoardManage/index', 1, NULL, '', 1, NULL, '0', 8.00, 1, 'Brush', 1, 0, 0, 0, NULL, 'admin', '2023-07-05 10:33:31', NULL, NULL, 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676429364255440897', '1676120854443540481', '线别管理', '/lineAliasManage', '@/views/lineStation/lineAliasManage/index', 1, NULL, '', 1, NULL, '0', 2.00, 1, 'Basketball', 1, 0, 0, 0, NULL, 'admin', '2023-07-05 11:14:42', 'admin', '2023-08-24 11:20:34', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676883440877338625', '', '检查数据库', '/checkData', '', 1, NULL, '', 0, NULL, '0', 4.00, 1, 'CopyDocument', 0, 0, 0, 0, NULL, 'admin', '2023-07-06 17:19:02', 'admin', '2023-07-19 17:28:24', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676885697538719746', '1676883440877338625', '动静态几何尺寸数据', '/dynamicAndStatic', '', 1, NULL, '', 1, NULL, '0', 1.00, 1, 'Briefcase', 0, 0, 0, 0, NULL, 'admin', '2023-07-06 17:28:00', 'admin', '2023-07-07 10:38:35', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676887390875713537', '1676883440877338625', '设备检查记录数据', '/equipmentRecord', '', 1, NULL, '', 1, NULL, '0', 2.00, 1, 'CircleCheckFilled', 0, 0, 0, 0, NULL, 'admin', '2023-07-06 17:34:44', 'admin', '2023-07-07 10:44:25', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676890468425302017', '1676887390875713537', '道岔检查记录', '/useTurnoutRecord', '@/views/equipmentRecord/useTurnoutRecord/index', 1, NULL, '', 1, NULL, '0', 1.00, 1, 'Brush', 1, 0, 0, 0, NULL, 'admin', '2023-07-06 17:46:57', 'admin', '2023-11-25 16:26:16', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1676891100578217986', '1676887390875713537', '钢轨常规探伤记录', '/railWearRecord', '@/views/equipmentRecord/railWearRecord/index', 1, NULL, '', 1, NULL, '0', 2.00, 1, 'ChatDotSquare', 1, 0, 0, 0, NULL, 'admin', '2023-07-06 17:49:28', 'admin', '2023-11-25 16:26:29', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1677145334007664641', '1676885697538719746', '人工静态检查数据', '/manualStaticCheck', '@/views/checkData/dynamicAndStatic/manualStaticCheck/index', 1, NULL, '', 1, NULL, '0', 1.00, 1, 'Avatar', 1, 0, 0, 0, NULL, 'admin', '2023-07-07 10:39:42', 'admin', '2023-07-07 11:06:59', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1677146721655394305', '1676887390875713537', '道床定期检查工作记录', '/useTrackBedRecord', '@/views/equipmentRecord/useTrackBedRecord/index', 1, NULL, '', 1, NULL, '0', 5.00, 1, 'Brush', 1, 0, 0, 0, NULL, 'admin', '2023-07-07 10:45:13', 'admin', '2023-11-25 16:26:57', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1677153911585837057', '1676885697538719746', '轨检仪静态检查数据', '/trackDetectorStaticCheck', '@/views/checkData/dynamicAndStatic/trackDetectorStaticCheck/index', 1, NULL, '', 1, NULL, '0', 2.00, 1, 'Burger', 1, 0, 0, 0, NULL, 'admin', '2023-07-07 11:13:47', NULL, NULL, 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1677154511769767938', '1676885697538719746', '轨检车动态检查数据', '/trackDetectorDynamicCheck', '@/views/checkData/dynamicAndStatic/trackDetectorDynamicCheck/index', 1, NULL, '', 1, NULL, '0', 3.00, 1, 'Baseball', 1, 0, 0, 0, NULL, 'admin', '2023-07-07 11:16:10', NULL, NULL, 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1677155431127650305', '1676885697538719746', '添乘仪动态检查数据', '/stowageDetectorDynamicCheck', '@/views/checkData/dynamicAndStatic/stowageDetectorDynamicCheck/index', 1, NULL, '', 1, NULL, '0', 4.00, 1, 'Calendar', 1, 0, 0, 0, NULL, 'admin', '2023-07-07 11:19:49', NULL, NULL, 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1677155703627386881', '1676887390875713537', '曲线钢轨磨耗检查记录', '/curveWearRecord', '@/views/checkData/equipmentRecord/curveWearRecord/index', 1, NULL, '', 1, NULL, '0', 3.00, 1, 'Dessert', 1, 0, 0, 0, NULL, 'admin', '2023-07-07 11:20:54', 'admin', '2023-11-25 16:26:45', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1677155895214804993', '1676887390875713537', '钢轨波磨情况检查数据', '/railCorrugateRecord', '@/views/checkData/equipmentRecord/railCorrugateRecord/index', 1, NULL, '', 1, NULL, '0', 4.00, 1, 'ElementPlus', 1, 0, 0, 0, NULL, 'admin', '2023-07-07 11:21:40', NULL, NULL, 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1677156202174943233', '1676883440877338625', '线路巡查记录数据', '/lineRecord', '', 1, NULL, '', 1, NULL, '0', 3.00, 1, 'Burger', 0, 0, 0, 0, NULL, 'admin', '2023-07-07 11:22:53', 'admin', '2023-07-09 09:34:03', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1677156410816401409', '1677156202174943233', '线路巡查记录管理', '/lineInspectionRecord', '@/views/checkData/lineRecord/lineInspectionRecord/index', 1, NULL, '', 1, NULL, '0', 1.00, 1, 'CameraFilled', 1, 0, 0, 0, NULL, 'admin', '2023-07-07 11:23:43', 'admin', '2023-07-09 09:34:19', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1681477062184329217', '', '动静态分析', '/analysis', '', 1, NULL, '', 0, NULL, '0', 5.00, 1, 'Tools', 0, 0, 0, 0, NULL, 'admin', '2023-07-19 09:32:27', 'admin', '2023-07-19 09:38:54', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1681477863334141953', '1681477062184329217', '分析批次列表', '/analysisTools', '@/views/analysis/analysisTools/index', 1, NULL, '', 1, NULL, '0', 1.00, 1, 'Cellphone', 1, 0, 0, 0, NULL, 'admin', '2023-07-19 09:35:38', 'admin', '2023-08-14 14:17:03', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1681486424130904066', NULL, '维修作业管理', '/maintenance', '', 1, NULL, '', 0, NULL, '0', 6.00, 1, 'Memo', 0, 0, 0, 0, NULL, 'admin', '2023-07-19 10:09:39', NULL, NULL, 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1681487334378758145', '1681486424130904066', '作业计划批次管理', '/batchManagement', '@/views/maintenance/batchManagement/index', 1, NULL, '', 1, NULL, '0', 1.00, 1, 'Briefcase', 1, 0, 0, 0, NULL, 'admin', '2023-07-19 10:13:16', 'admin', '2023-07-19 10:18:22', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1686185781128474626', '1681477062184329217', '单元化管理权值设置', '/setWeightValue', '@/views/analysis/setWeightValue/index', 1, NULL, '', 1, NULL, '0', 2.00, 1, 'Setting', 1, 0, 0, 0, NULL, 'admin', '2023-08-01 09:23:13', 'admin', '2023-08-01 09:23:13', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1686185954038657025', '1681477062184329217', '单元化管理阈值设置', '/setThresholdValue', '@/views/analysis/setThresholdValue/index', 1, NULL, '', 1, NULL, '0', 3.00, 1, 'Setting', 1, 0, 0, 0, NULL, 'admin', '2023-08-01 09:23:54', 'admin', '2023-08-01 09:23:54', 0, 0, '1', 0);
INSERT INTO `sys_permission` VALUES ('1688474008769986562', '1676122832305340417', '日志管理', '/logManage', '@/views/system/logManage/index', 1, NULL, '', 1, NULL, '0', 5.00, 1, 'Basketball', 1, 0, 0, 0, NULL, 'admin', '2023-08-07 16:55:49', NULL, NULL, 0, 0, '1', 0);

-- ----------------------------
-- Table structure for sys_permission_data_rule
-- ----------------------------
DROP TABLE IF EXISTS `sys_permission_data_rule`;
CREATE TABLE `sys_permission_data_rule`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
  `permission_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '菜单ID',
  `rule_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '规则名称',
  `rule_column` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '字段',
  `rule_conditions` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '条件',
  `rule_value` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '规则值',
  `status` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '权限有效状态1有0否',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_spdr_permission_id`(`permission_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_permission_data_rule
-- ----------------------------
INSERT INTO `sys_permission_data_rule` VALUES ('1260935285157511170', '4148ec82b6acd69f470bea75fe41c357', 'createBy', 'createBy', '=', '#{sys_user_code}', '0', '2020-05-14 22:09:34', 'jeecg', '2020-05-14 22:13:52', 'admin');
INSERT INTO `sys_permission_data_rule` VALUES ('1260936345293012993', '4148ec82b6acd69f470bea75fe41c357', '年龄', 'age', '>', '20', '1', '2020-05-14 22:13:46', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('1260937192290762754', '4148ec82b6acd69f470bea75fe41c357', 'sysOrgCode', 'sysOrgCode', 'RIGHT_LIKE', '#{sys_org_code}', '1', '2020-05-14 22:17:08', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('32b62cb04d6c788d9d92e3ff5e66854e', '8d4683aacaa997ab86b966b464360338', '000', '00', '!=', '00', '1', '2019-04-02 18:36:08', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('40283181614231d401614234fe670003', '40283181614231d401614232cd1c0001', 'createBy', 'createBy', '=', '#{sys_user_code}', '1', '2018-01-29 21:57:04', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('4028318161424e730161424fca6f0004', '4028318161424e730161424f61510002', 'createBy', 'createBy', '=', '#{sys_user_code}', '1', '2018-01-29 22:26:20', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('402880e6487e661a01487e732c020005', '402889fb486e848101486e93a7c80014', 'SYS_ORG_CODE', 'SYS_ORG_CODE', 'LIKE', '010201%', '1', '2014-09-16 20:32:30', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('402880e6487e661a01487e8153ee0007', '402889fb486e848101486e93a7c80014', 'create_by', 'create_by', '', '#{SYS_USER_CODE}', '1', '2014-09-16 20:47:57', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('402880ec5ddec439015ddf9225060038', '40288088481d019401481d2fcebf000d', '复杂关系', '', 'USE_SQL_RULES', 'name like \'%张%\' or age > 10', '1', NULL, NULL, '2017-08-14 15:10:25', 'demo');
INSERT INTO `sys_permission_data_rule` VALUES ('402880ec5ddfdd26015ddfe3e0570011', '4028ab775dca0d1b015dca3fccb60016', '复杂sql配置', '', 'USE_SQL_RULES', 'table_name like \'%test%\' or is_tree = \'Y\'', '1', NULL, NULL, '2017-08-14 16:38:55', 'demo');
INSERT INTO `sys_permission_data_rule` VALUES ('402880f25b1e2ac7015b1e5fdebc0012', '402880f25b1e2ac7015b1e5cdc340010', '只能看自己数据', 'create_by', '=', '#{sys_user_code}', '1', '2017-03-30 16:40:51', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('402881875b19f141015b19f8125e0014', '40288088481d019401481d2fcebf000d', '可看下属业务数据', 'sys_org_code', 'LIKE', '#{sys_org_code}', '1', NULL, NULL, '2017-08-14 15:04:32', 'demo');
INSERT INTO `sys_permission_data_rule` VALUES ('402881e45394d66901539500a4450001', '402881e54df73c73014df75ab670000f', 'sysCompanyCode', 'sysCompanyCode', '=', '#{SYS_COMPANY_CODE}', '1', '2016-03-21 01:09:21', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('402881e45394d6690153950177cb0003', '402881e54df73c73014df75ab670000f', 'sysOrgCode', 'sysOrgCode', '=', '#{SYS_ORG_CODE}', '1', '2016-03-21 01:10:15', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('402881e56266f43101626727aff60067', '402881e56266f43101626724eb730065', '销售自己看自己的数据', 'createBy', '=', '#{sys_user_code}', '1', '2018-03-27 19:11:16', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('402881e56266f4310162672fb1a70082', '402881e56266f43101626724eb730065', '销售经理看所有下级数据', 'sysOrgCode', 'LIKE', '#{sys_org_code}', '1', '2018-03-27 19:20:01', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('402881e56266f431016267387c9f0088', '402881e56266f43101626724eb730065', '只看金额大于1000的数据', 'money', '>=', '1000', '1', '2018-03-27 19:29:37', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('402881f3650de25101650dfb5a3a0010', '402881e56266f4310162671d62050044', '22', '', 'USE_SQL_RULES', '22', '1', '2018-08-06 14:45:01', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('402889fb486e848101486e913cd6000b', '402889fb486e848101486e8e2e8b0007', 'userName', 'userName', '=', 'admin', '1', '2014-09-13 18:31:25', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('402889fb486e848101486e98d20d0016', '402889fb486e848101486e93a7c80014', 'title', 'title', '=', '12', '1', NULL, NULL, '2014-09-13 22:18:22', 'scott');
INSERT INTO `sys_permission_data_rule` VALUES ('402889fe47fcb29c0147fcb6b6220001', '8a8ab0b246dc81120146dc8180fe002b', '12', '12', '>', '12', '1', '2014-08-22 15:55:38', '8a8ab0b246dc81120146dc8181950052', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('4028ab775dca0d1b015dca4183530018', '4028ab775dca0d1b015dca3fccb60016', '表名限制', 'isDbSynch', '=', 'Y', '1', NULL, NULL, '2017-08-14 16:43:45', 'demo');
INSERT INTO `sys_permission_data_rule` VALUES ('4028ef815595a881015595b0ccb60001', '40288088481d019401481d2fcebf000d', '限只能看自己', 'create_by', '=', '#{sys_user_code}', '1', NULL, NULL, '2017-08-14 15:03:56', 'demo');
INSERT INTO `sys_permission_data_rule` VALUES ('4028ef81574ae99701574aed26530005', '4028ef81574ae99701574aeb97bd0003', '用户名', 'userName', '!=', 'admin', '1', '2016-09-21 12:07:18', 'admin', NULL, NULL);
INSERT INTO `sys_permission_data_rule` VALUES ('f852d85d47f224990147f2284c0c0005', NULL, '小于', 'test', '<=', '11', '1', '2014-08-20 14:43:52', '8a8ab0b246dc81120146dc8181950052', NULL, NULL);

-- ----------------------------
-- Table structure for sys_position
-- ----------------------------
DROP TABLE IF EXISTS `sys_position`;
CREATE TABLE `sys_position`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '职务编码',
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '职务名称',
  `post_rank` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '职级',
  `company_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '公司id',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `sys_org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组织机构编码',
  `tenant_id` int NULL DEFAULT 0 COMMENT '租户ID',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uniq_code`(`code` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_position
-- ----------------------------
INSERT INTO `sys_position` VALUES ('1185040064792571906', 'devleader', '研发部经理', '2', NULL, 'admin', '2019-10-18 11:49:03', 'admin', '2022-10-25 11:09:06', 'A01', 0);
INSERT INTO `sys_position` VALUES ('1256485574212153345', '总经理', 'laozong', '5', NULL, 'admin', '2020-05-02 15:28:00', 'admin', '2022-10-25 00:16:17', '北京国炬公司', 0);

-- ----------------------------
-- Table structure for sys_quartz_job
-- ----------------------------
DROP TABLE IF EXISTS `sys_quartz_job`;
CREATE TABLE `sys_quartz_job`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `del_flag` int NULL DEFAULT NULL COMMENT '删除状态',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `job_class_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '任务类名',
  `cron_expression` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'cron表达式',
  `parameter` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '参数',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `status` int NULL DEFAULT NULL COMMENT '状态 0正常 -1停止',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_quartz_job
-- ----------------------------

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `role_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '角色名称',
  `role_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '角色编码',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '描述',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `tenant_id` int NULL DEFAULT 0 COMMENT '租户ID',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uniq_sys_role_role_code`(`role_code` ASC) USING BTREE,
  INDEX `idx_sr_role_code`(`role_code` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '角色表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role
-- ----------------------------
INSERT INTO `sys_role` VALUES ('1169504891467464705', '第三方登录角色', 'third_role', '第三方登录角色', 'admin', '2019-09-05 14:57:49', 'admin', '2020-05-02 18:20:58', 0);
INSERT INTO `sys_role` VALUES ('1260924539346472962', '财务出纳', 'caiwu', NULL, 'admin', '2020-05-14 21:26:52', NULL, NULL, 0);
INSERT INTO `sys_role` VALUES ('1674685653284737026', '超级管理员', 'super-admin', '12', 'admin', '2023-06-30 15:45:49', 'admin', '2023-06-30 16:14:55', 0);
INSERT INTO `sys_role` VALUES ('1676186309912858626', '游客角色', 'youke', '只看首页', 'admin', '2023-07-04 19:08:53', NULL, NULL, 0);
INSERT INTO `sys_role` VALUES ('1679089298088370178', '软件研发', 'utf-8', '111', 'admin', '2023-07-12 19:24:19', NULL, NULL, 0);
INSERT INTO `sys_role` VALUES ('1688484141860323330', '测试QA组', 'QA_test', '', 'QA_001', '2023-08-07 17:36:05', NULL, NULL, 0);
INSERT INTO `sys_role` VALUES ('e51758fa916c881624b046d26bd09230', '人力资源部', 'hr', NULL, 'admin', '2019-01-21 18:07:24', 'admin', '2019-10-18 11:39:43', 0);
INSERT INTO `sys_role` VALUES ('ee8626f80f7c2619917b6236f3a7f02b', '临时角色', 'test', '这是新建的临时角色123', NULL, '2018-12-20 10:59:04', 'admin', '2019-02-19 15:08:37', 0);
INSERT INTO `sys_role` VALUES ('f6817f48af4fb3af11b9e8bf182f618b', '管理员', 'admin', '管理员', NULL, '2018-12-21 18:03:39', 'admin', '2023-03-04 15:00:04', 0);

-- ----------------------------
-- Table structure for sys_role_index
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_index`;
CREATE TABLE `sys_role_index`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `role_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '角色编码',
  `url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '路由地址',
  `component` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '组件',
  `is_route` tinyint(1) NULL DEFAULT 1 COMMENT '是否路由菜单: 0:不是  1:是（默认值1）',
  `priority` int NULL DEFAULT 0 COMMENT '优先级',
  `status` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '状态0:无效 1:有效',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属部门',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色首页表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role_index
-- ----------------------------
INSERT INTO `sys_role_index` VALUES ('1549658299929718786', 'admin', '222', '22', 1, 0, '0', 'admin', '2022-07-20 15:31:45', 'admin', '2022-07-20 15:31:55', 'A01');

-- ----------------------------
-- Table structure for sys_role_permission
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_permission`;
CREATE TABLE `sys_role_permission`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `role_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '角色id',
  `permission_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '权限id',
  `data_rule_ids` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据权限ids',
  `operate_date` datetime NULL DEFAULT NULL COMMENT '操作时间',
  `operate_ip` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作ip',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_srp_role_per_id`(`role_id` ASC, `permission_id` ASC) USING BTREE,
  INDEX `idx_srp_role_id`(`role_id` ASC) USING BTREE,
  INDEX `idx_srp_permission_id`(`permission_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '角色权限表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role_permission
-- ----------------------------
INSERT INTO `sys_role_permission` VALUES ('1676155915586920449', '1674685653284737026', '1676114112963887105', NULL, '2023-07-04 17:08:06', '192.168.11.39');
INSERT INTO `sys_role_permission` VALUES ('1679089506981486593', '1679089298088370178', '1676114112963887105', NULL, '2023-07-12 19:25:09', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1679089506985680897', '1679089298088370178', '1676120854443540481', NULL, '2023-07-12 19:25:09', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1679089506985680898', '1679089298088370178', '1676121595329593345', NULL, '2023-07-12 19:25:09', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1679089506985680899', '1679089298088370178', '1676122070149971969', NULL, '2023-07-12 19:25:09', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1679089506985680900', '1679089298088370178', '1676122308696817666', NULL, '2023-07-12 19:25:09', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1679089506985680901', '1679089298088370178', '1676429364255440897', NULL, '2023-07-12 19:25:09', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1679375085476450306', '1679089298088370178', '1676411731825000449', NULL, '2023-07-13 14:19:56', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1679375085489033217', '1679089298088370178', '1676417724554280961', NULL, '2023-07-13 14:19:56', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1679375085489033218', '1679089298088370178', '1676417901943980034', NULL, '2023-07-13 14:19:56', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1679375085493227521', '1679089298088370178', '1676418150146113537', NULL, '2023-07-13 14:19:56', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1679375085493227522', '1679089298088370178', '1676418456816844801', NULL, '2023-07-13 14:19:56', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1679375085497421826', '1679089298088370178', '1676418627248193537', NULL, '2023-07-13 14:19:56', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1679375085497421827', '1679089298088370178', '1676418820156817410', NULL, '2023-07-13 14:19:56', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682329402617524226', 'f6817f48af4fb3af11b9e8bf182f618b', '1676114112963887105', NULL, '2023-07-21 17:59:20', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029153419266', '1674685653284737026', '1676120854443540481', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807874', '1674685653284737026', '1676121595329593345', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807875', '1674685653284737026', '1676122070149971969', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807876', '1674685653284737026', '1676122308696817666', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807877', '1674685653284737026', '1676429364255440897', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807878', '1674685653284737026', '1676411157582839810', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807879', '1674685653284737026', '1676411731825000449', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807880', '1674685653284737026', '1676417724554280961', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807881', '1674685653284737026', '1676417901943980034', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807882', '1674685653284737026', '1676418150146113537', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807883', '1674685653284737026', '1676418820156817410', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807884', '1674685653284737026', '1676418627248193537', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807885', '1674685653284737026', '1676418456816844801', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807886', '1674685653284737026', '1676419000495112193', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807887', '1674685653284737026', '1676883440877338625', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807888', '1674685653284737026', '1676885697538719746', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807889', '1674685653284737026', '1677145334007664641', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807890', '1674685653284737026', '1677153911585837057', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807891', '1674685653284737026', '1677154511769767938', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807892', '1674685653284737026', '1677155431127650305', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807893', '1674685653284737026', '1676887390875713537', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807894', '1674685653284737026', '1676890468425302017', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029161807895', '1674685653284737026', '1676891100578217986', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029191168002', '1674685653284737026', '1677155703627386881', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029191168003', '1674685653284737026', '1677155895214804993', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029191168004', '1674685653284737026', '1677146721655394305', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029191168005', '1674685653284737026', '1677156202174943233', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029191168006', '1674685653284737026', '1677156410816401409', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029191168013', '1674685653284737026', '1676123076355112961', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029191168014', '1674685653284737026', '1676124077023772674', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029191168015', '1674685653284737026', '1676129090928328705', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029191168016', '1674685653284737026', '1676125726677090306', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029191168017', '1674685653284737026', '1676124443723382786', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617029191168018', '1674685653284737026', '1676129326035845122', NULL, '2023-07-22 13:02:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194593546241', 'f6817f48af4fb3af11b9e8bf182f618b', '1676120854443540481', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194593546242', 'f6817f48af4fb3af11b9e8bf182f618b', '1676121595329593345', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194593546243', 'f6817f48af4fb3af11b9e8bf182f618b', '1676122070149971969', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194593546244', 'f6817f48af4fb3af11b9e8bf182f618b', '1676122308696817666', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194593546245', 'f6817f48af4fb3af11b9e8bf182f618b', '1676429364255440897', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323457', 'f6817f48af4fb3af11b9e8bf182f618b', '1676411157582839810', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323458', 'f6817f48af4fb3af11b9e8bf182f618b', '1676411731825000449', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323459', 'f6817f48af4fb3af11b9e8bf182f618b', '1676417724554280961', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323460', 'f6817f48af4fb3af11b9e8bf182f618b', '1676417901943980034', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323461', 'f6817f48af4fb3af11b9e8bf182f618b', '1676418150146113537', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323462', 'f6817f48af4fb3af11b9e8bf182f618b', '1676418820156817410', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323463', 'f6817f48af4fb3af11b9e8bf182f618b', '1676418627248193537', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323464', 'f6817f48af4fb3af11b9e8bf182f618b', '1676418456816844801', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323465', 'f6817f48af4fb3af11b9e8bf182f618b', '1676419000495112193', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323466', 'f6817f48af4fb3af11b9e8bf182f618b', '1676883440877338625', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323467', 'f6817f48af4fb3af11b9e8bf182f618b', '1676885697538719746', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323468', 'f6817f48af4fb3af11b9e8bf182f618b', '1677145334007664641', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323469', 'f6817f48af4fb3af11b9e8bf182f618b', '1677153911585837057', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323470', 'f6817f48af4fb3af11b9e8bf182f618b', '1677154511769767938', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323471', 'f6817f48af4fb3af11b9e8bf182f618b', '1677155431127650305', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323472', 'f6817f48af4fb3af11b9e8bf182f618b', '1676887390875713537', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323473', 'f6817f48af4fb3af11b9e8bf182f618b', '1676890468425302017', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323474', 'f6817f48af4fb3af11b9e8bf182f618b', '1676891100578217986', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323475', 'f6817f48af4fb3af11b9e8bf182f618b', '1677155703627386881', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323476', 'f6817f48af4fb3af11b9e8bf182f618b', '1677155895214804993', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323477', 'f6817f48af4fb3af11b9e8bf182f618b', '1677146721655394305', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323478', 'f6817f48af4fb3af11b9e8bf182f618b', '1677156202174943233', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323479', 'f6817f48af4fb3af11b9e8bf182f618b', '1677156410816401409', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323480', 'f6817f48af4fb3af11b9e8bf182f618b', '1681477062184329217', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194610323481', 'f6817f48af4fb3af11b9e8bf182f618b', '1681477863334141953', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194635489282', 'f6817f48af4fb3af11b9e8bf182f618b', '1676123076355112961', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194635489283', 'f6817f48af4fb3af11b9e8bf182f618b', '1676123379443908609', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194635489285', 'f6817f48af4fb3af11b9e8bf182f618b', '1676129090928328705', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194635489286', 'f6817f48af4fb3af11b9e8bf182f618b', '1676125726677090306', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682617194635489288', 'f6817f48af4fb3af11b9e8bf182f618b', '1676129326035845122', NULL, '2023-07-22 13:02:55', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682658448572313602', '1674685653284737026', '1681477062184329217', NULL, '2023-07-22 15:46:51', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1682658448580702210', '1674685653284737026', '1681477863334141953', NULL, '2023-07-22 15:46:51', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1686186046451757058', '1674685653284737026', '1686185781128474626', NULL, '2023-08-01 09:24:16', '192.168.11.42');
INSERT INTO `sys_role_permission` VALUES ('1686186046518865922', '1674685653284737026', '1686185954038657025', NULL, '2023-08-01 09:24:16', '192.168.11.42');
INSERT INTO `sys_role_permission` VALUES ('1688473629634265090', 'f6817f48af4fb3af11b9e8bf182f618b', '1686185781128474626', NULL, '2023-08-07 16:54:18', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688473629638459394', 'f6817f48af4fb3af11b9e8bf182f618b', '1686185954038657025', NULL, '2023-08-07 16:54:18', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236097945601', '1688484141860323330', '1676114112963887105', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236097945602', '1688484141860323330', '1676120854443540481', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236097945603', '1688484141860323330', '1676121595329593345', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236110528513', '1688484141860323330', '1676122070149971969', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236110528514', '1688484141860323330', '1676122308696817666', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236110528515', '1688484141860323330', '1676429364255440897', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236110528516', '1688484141860323330', '1676411157582839810', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236110528517', '1688484141860323330', '1676411731825000449', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236110528518', '1688484141860323330', '1676417724554280961', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236110528519', '1688484141860323330', '1676417901943980034', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236110528520', '1688484141860323330', '1676418150146113537', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236110528521', '1688484141860323330', '1676418820156817410', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722818', '1688484141860323330', '1676418627248193537', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722819', '1688484141860323330', '1676418456816844801', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722820', '1688484141860323330', '1676419000495112193', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722821', '1688484141860323330', '1676883440877338625', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722822', '1688484141860323330', '1676885697538719746', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722823', '1688484141860323330', '1677145334007664641', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722824', '1688484141860323330', '1677153911585837057', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722825', '1688484141860323330', '1677154511769767938', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722826', '1688484141860323330', '1677155431127650305', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722827', '1688484141860323330', '1676887390875713537', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722828', '1688484141860323330', '1676890468425302017', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722829', '1688484141860323330', '1676891100578217986', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722830', '1688484141860323330', '1677155703627386881', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722831', '1688484141860323330', '1677155895214804993', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722832', '1688484141860323330', '1677146721655394305', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722833', '1688484141860323330', '1677156202174943233', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722834', '1688484141860323330', '1677156410816401409', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722835', '1688484141860323330', '1681477062184329217', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722836', '1688484141860323330', '1681477863334141953', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722837', '1688484141860323330', '1686185781128474626', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236114722838', '1688484141860323330', '1686185954038657025', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236118917122', '1688484141860323330', '1681486424130904066', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1688484236118917123', '1688484141860323330', '1681487334378758145', NULL, '2023-08-07 17:36:27', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1689567160348352514', '1674685653284737026', '1676122832305340417', NULL, '2023-08-10 17:19:36', '192.168.11.32');
INSERT INTO `sys_role_permission` VALUES ('1689567160348352515', '1674685653284737026', '1688474008769986562', NULL, '2023-08-10 17:19:36', '192.168.11.32');
INSERT INTO `sys_role_permission` VALUES ('1689596989961359362', 'f6817f48af4fb3af11b9e8bf182f618b', '1681486424130904066', NULL, '2023-08-10 19:18:08', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1689596989961359363', 'f6817f48af4fb3af11b9e8bf182f618b', '1681487334378758145', NULL, '2023-08-10 19:18:08', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1689597208673341441', '1674685653284737026', '1681486424130904066', NULL, '2023-08-10 19:19:00', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1689597208694312961', '1674685653284737026', '1681487334378758145', NULL, '2023-08-10 19:19:00', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1706148584131805186', 'f6817f48af4fb3af11b9e8bf182f618b', '1688474008769986562', NULL, '2023-09-25 11:28:16', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1706148609616396289', 'f6817f48af4fb3af11b9e8bf182f618b', '1676122832305340417', NULL, '2023-09-25 11:28:22', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1706148609616396290', 'f6817f48af4fb3af11b9e8bf182f618b', '1676124077023772674', NULL, '2023-09-25 11:28:22', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('1706148609616396291', 'f6817f48af4fb3af11b9e8bf182f618b', '1676124443723382786', NULL, '2023-09-25 11:28:22', '127.0.0.1');
INSERT INTO `sys_role_permission` VALUES ('2', '1674685653284737026', '1676123379443908609', NULL, '2023-07-22 13:00:56', '127.0.0.1');

-- ----------------------------
-- Table structure for sys_sms
-- ----------------------------
DROP TABLE IF EXISTS `sys_sms`;
CREATE TABLE `sys_sms`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
  `es_title` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '消息标题',
  `es_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发送方式：参考枚举MessageTypeEnum',
  `es_receiver` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '接收人',
  `es_param` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '发送所需参数Json格式',
  `es_content` longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '推送内容',
  `es_send_time` datetime NULL DEFAULT NULL COMMENT '推送时间',
  `es_send_status` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '推送状态 0未推送 1推送成功 2推送失败 -1失败不再发送',
  `es_send_num` int NULL DEFAULT NULL COMMENT '发送次数 超过5次不再发送',
  `es_result` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '推送失败原因',
  `remark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_ss_es_type`(`es_type` ASC) USING BTREE,
  INDEX `idx_ss_es_receiver`(`es_receiver` ASC) USING BTREE,
  INDEX `idx_ss_es_send_time`(`es_send_time` ASC) USING BTREE,
  INDEX `idx_ss_es_send_status`(`es_send_status` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_sms
-- ----------------------------
INSERT INTO `sys_sms` VALUES ('402880e74dc2f361014dc2f8411e0001', '消息推送测试333', '2', '411944058@qq.com', NULL, '张三你好，你的订单4028d881436d514601436d521ae80165已付款!', '2015-06-05 17:06:01', '3', NULL, NULL, '认证失败错误的用户名或者密码', 'admin', '2015-06-05 17:05:59', 'admin', '2015-11-19 22:30:39');
INSERT INTO `sys_sms` VALUES ('402880ea533647b00153364e74770001', '发个问候', '3', 'admin', NULL, '你好', '2016-03-02 00:00:00', '2', NULL, NULL, NULL, 'admin', '2016-03-02 15:50:24', 'admin', '2018-07-05 19:53:01');
INSERT INTO `sys_sms` VALUES ('402880ee5a17e711015a17f3188e013f', '消息推送测试333', '2', '411944058@qq.com', NULL, '张三你好，你的订单4028d881436d514601436d521ae80165已付款!', NULL, '2', NULL, NULL, NULL, 'admin', '2017-02-07 17:41:31', 'admin', '2017-03-10 11:37:05');
INSERT INTO `sys_sms` VALUES ('402880f05ab649b4015ab64b9cd80012', '消息推送测试333', '2', '411944058@qq.com', NULL, '张三你好，你的订单4028d881436d514601436d521ae80165已付款!', '2017-11-16 15:58:15', '3', NULL, NULL, NULL, 'admin', '2017-03-10 11:38:13', 'admin', '2017-07-31 17:24:54');
INSERT INTO `sys_sms` VALUES ('402880f05ab7b035015ab7c4462c0004', '消息推送测试333', '2', '411944058@qq.com', NULL, '张三你好，你的订单4028d881436d514601436d521ae80165已付款!', '2017-11-16 15:58:15', '3', NULL, NULL, NULL, 'admin', '2017-03-10 18:29:37', NULL, NULL);
INSERT INTO `sys_sms` VALUES ('402881f3646a472b01646a4a5af00001', '催办：HR审批', '3', 'admin', NULL, 'admin，您好！\r\n请前待办任务办理事项！HR审批\r\n\r\n\r\n===========================\r\n此消息由系统发出', '2018-07-05 19:53:35', '2', NULL, NULL, NULL, 'admin', '2018-07-05 19:53:35', 'admin', '2018-07-07 13:45:24');
INSERT INTO `sys_sms` VALUES ('402881f3647da06c01647da43a940014', '催办：HR审批', '3', 'admin', NULL, 'admin，您好！\r\n请前待办任务办理事项！HR审批\r\n\r\n\r\n===========================\r\n此消息由系统发出', '2018-07-09 14:04:32', '2', NULL, NULL, NULL, 'admin', '2018-07-09 14:04:32', 'admin', '2018-07-09 18:51:30');

-- ----------------------------
-- Table structure for sys_sms_template
-- ----------------------------
DROP TABLE IF EXISTS `sys_sms_template`;
CREATE TABLE `sys_sms_template`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `template_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模板标题',
  `template_code` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '模板CODE',
  `template_type` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '模板类型：1短信 2邮件 3微信',
  `template_content` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '模板内容',
  `template_test_json` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '模板测试json',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人登录名称',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人登录名称',
  `use_status` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否使用中 1是0否',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uk_sst_template_code`(`template_code` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_sms_template
-- ----------------------------
INSERT INTO `sys_sms_template` VALUES ('1199606397416775681', '系统消息通知', 'sys_ts_note', '2', '<h1>&nbsp; &nbsp; 系统通知</h1>\n<ul>\n<li>通知时间：&nbsp; ${ts_date}</li>\n<li>通知内容：&nbsp; ${ts_content}</li>\n</ul>', NULL, '2019-11-27 16:30:27', 'admin', '2023-06-07 17:11:29', 'admin', '1');
INSERT INTO `sys_sms_template` VALUES ('1199615897335095298', '流程催办', 'bpm_cuiban', '2', '<h1>&nbsp; &nbsp;流程催办提醒</h1>\n<ul>\n<li>流程名称：&nbsp; ${bpm_name}</li>\n<li>催办任务：&nbsp; ${bpm_task}</li>\n<li>催办时间 :&nbsp; &nbsp; ${datetime}</li>\n<li>催办内容 :&nbsp; &nbsp; ${remark}</li>\n</ul>', NULL, '2019-11-27 17:08:12', 'admin', '2019-11-27 19:36:45', 'admin', NULL);
INSERT INTO `sys_sms_template` VALUES ('1199648914107625473', '流程办理超时提醒', 'bpm_chaoshi_tip', '2', '<h1>&nbsp; &nbsp;流程办理超时提醒</h1>\n<ul>\n<li>&nbsp; &nbsp;超时提醒信息：&nbsp; &nbsp; 您有待处理的超时任务，请尽快处理！</li>\n<li>&nbsp; &nbsp;超时任务标题：&nbsp; &nbsp; ${title}</li>\n<li>&nbsp; &nbsp;超时任务节点：&nbsp; &nbsp; ${task}</li>\n<li>&nbsp; &nbsp;任务处理人：&nbsp; &nbsp; &nbsp; &nbsp;${user}</li>\n<li>&nbsp; &nbsp;任务开始时间：&nbsp; &nbsp; ${time}</li>\n</ul>', NULL, '2019-11-27 19:19:24', 'admin', '2019-11-27 19:36:37', 'admin', NULL);
INSERT INTO `sys_sms_template` VALUES ('4028608164691b000164693108140003', '催办：${taskName}', 'SYS001', '1', '${userName}，您好！\r\n请前待办任务办理事项！${taskName}\r\n\r\n\r\n===========================\r\n此消息由系统发出', '{\r\n\"taskName\":\"HR审批\",\r\n\"userName\":\"admin\"\r\n}', '2018-07-05 14:46:18', 'admin', '2018-07-05 18:31:34', 'admin', NULL);

-- ----------------------------
-- Table structure for sys_tenant
-- ----------------------------
DROP TABLE IF EXISTS `sys_tenant`;
CREATE TABLE `sys_tenant`  (
  `id` int NOT NULL COMMENT '租户编码',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `begin_date` datetime NULL DEFAULT NULL COMMENT '开始时间',
  `end_date` datetime NULL DEFAULT NULL COMMENT '结束时间',
  `status` int NULL DEFAULT NULL COMMENT '状态 1正常 0冻结',
  `trade` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属行业',
  `company_size` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司规模',
  `company_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司地址',
  `company_logo` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公司logo',
  `house_number` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '门牌号',
  `work_place` varchar(100) CHARACTER SET utf32 COLLATE utf32_general_ci NULL DEFAULT NULL COMMENT '工作地点',
  `secondary_domain` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '二级域名',
  `login_bkgd_img` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '登录背景图片',
  `position` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '职级',
  `department` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '部门',
  `del_flag` tinyint(1) NULL DEFAULT 0 COMMENT '删除状态(0-正常,1-已删除)',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `apply_status` int NULL DEFAULT NULL COMMENT '允许申请管理员 1允许 0不允许',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '多租户信息表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_tenant
-- ----------------------------
INSERT INTO `sys_tenant` VALUES (1, '白酒集团', '2020-07-10 15:43:32', 'admin', NULL, NULL, 1, NULL, NULL, NULL, NULL, '7WIUCW', NULL, NULL, NULL, NULL, NULL, 1, 'admin', '2023-03-09 20:27:48', 1);
INSERT INTO `sys_tenant` VALUES (1000, '北京敲敲云科技有限公司', '2023-03-09 19:55:11', 'admin', NULL, NULL, 1, NULL, NULL, NULL, NULL, '2PI3U6', NULL, NULL, NULL, NULL, NULL, 0, 'admin', '2023-03-09 21:38:56', NULL);

-- ----------------------------
-- Table structure for sys_tenant_pack
-- ----------------------------
DROP TABLE IF EXISTS `sys_tenant_pack`;
CREATE TABLE `sys_tenant_pack`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键id',
  `tenant_id` int NULL DEFAULT NULL COMMENT '租户id',
  `pack_name` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '产品包名',
  `status` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开启状态(0 未开启 1开启)',
  `remarks` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` date NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` date NULL DEFAULT NULL COMMENT '更新时间',
  `pack_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编码,默认添加的三个管理员需要设置编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '租户产品包' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_tenant_pack
-- ----------------------------

-- ----------------------------
-- Table structure for sys_tenant_pack_perms
-- ----------------------------
DROP TABLE IF EXISTS `sys_tenant_pack_perms`;
CREATE TABLE `sys_tenant_pack_perms`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键编号',
  `pack_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户产品包名称',
  `permission_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '菜单id',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` date NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` date NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '租户产品包和菜单关系表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_tenant_pack_perms
-- ----------------------------

-- ----------------------------
-- Table structure for sys_tenant_pack_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_tenant_pack_user`;
CREATE TABLE `sys_tenant_pack_user`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `pack_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '租户产品包ID',
  `user_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户ID',
  `tenant_id` int NULL DEFAULT NULL COMMENT '租户ID',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `status` int NULL DEFAULT NULL COMMENT '状态 正常状态1 申请状态0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '租户套餐人员表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_tenant_pack_user
-- ----------------------------
INSERT INTO `sys_tenant_pack_user` VALUES ('1633795234318729217', '1633795213938606082', 'a75d45a015c44384a04449ee80dc3503', 1, 'admin', '2023-03-09 19:41:53', NULL, NULL, 1);

-- ----------------------------
-- Table structure for sys_third_account
-- ----------------------------
DROP TABLE IF EXISTS `sys_third_account`;
CREATE TABLE `sys_third_account`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '编号',
  `sys_user_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三方登录id',
  `avatar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '头像',
  `status` tinyint(1) NULL DEFAULT NULL COMMENT '状态(1-正常,2-冻结)',
  `del_flag` tinyint(1) NULL DEFAULT NULL COMMENT '删除状态(0-正常,1-已删除)',
  `realname` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '真实姓名',
  `third_user_uuid` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三方账号',
  `third_user_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '第三方app用户账号',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `third_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '登录来源',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uniq_sys_third_account_third_type_third_user_id`(`third_type` ASC, `third_user_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_third_account
-- ----------------------------

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `username` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '登录账号',
  `realname` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '真实姓名',
  `password` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '密码',
  `salt` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'md5密码盐',
  `avatar` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '头像',
  `birthday` datetime NULL DEFAULT NULL COMMENT '生日',
  `sex` tinyint(1) NULL DEFAULT NULL COMMENT '性别(0-默认未知,1-男,2-女)',
  `email` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '电子邮件',
  `phone` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '电话',
  `org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '登录会话的机构编码',
  `status` tinyint(1) NULL DEFAULT NULL COMMENT '性别(1-正常,2-冻结)',
  `del_flag` tinyint(1) NULL DEFAULT NULL COMMENT '删除状态(0-正常,1-已删除)',
  `third_id` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方登录的唯一标识',
  `third_type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '第三方类型',
  `activiti_sync` tinyint(1) NULL DEFAULT NULL COMMENT '同步工作流引擎(1-同步,0-不同步)',
  `work_no` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工号，唯一键',
  `post` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '职务，关联职务表',
  `telephone` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '座机号',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `user_identity` tinyint(1) NULL DEFAULT NULL COMMENT '身份（1普通成员 2上级）',
  `depart_ids` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '负责部门',
  `client_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '设备ID',
  `login_tenant_id` int NULL DEFAULT NULL COMMENT '上次登录选择租户ID',
  `bpm_status` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '流程入职离职状态',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_su_username`(`username` ASC) USING BTREE,
  INDEX `idx_su_status`(`status` ASC) USING BTREE,
  INDEX `idx_su_del_flag`(`del_flag` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user
-- ----------------------------
INSERT INTO `sys_user` VALUES ('1668512686431203329', 'tx-test', '测试', '6c64da0546083869', 'W9BIF7ZI', 'http://192.168.11.28:8080/hzsomms/api/sys/common/static/temp/logo_1688354729652.png', NULL, NULL, '11@qq.com', '13111111111', 'A03', 1, 1, NULL, NULL, 0, '001', 'devleader', NULL, 'admin', '2023-06-13 14:56:39', 'admin', '2023-07-03 11:25:32', 1, '', NULL, 1000, NULL);
INSERT INTO `sys_user` VALUES ('1674392755913818113', 'SuperAdmin', '超级管理员', 'ca7b6fd4e37ce66832daa4612001ff81', 'U4ej5sjR', 'http://47.94.207.62/hzsomms/api/sys/common/static/temp/logo_1688349098182_1688350846011.png', '2023-06-04 00:00:00', 1, '190@qq.com', '19020202020', NULL, 1, 0, NULL, NULL, NULL, '0001', NULL, NULL, 'admin', '2023-06-29 20:21:56', 'admin', '2023-08-07 16:10:39', NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('1674594868778418178', 'tset1111', '测试test12', '29572ab28fed229996417367e22e9362', 'Vbhju7aU', 'http://minio.jeecg.com/otatest/temp/download_1688038207010_1688039029004.jpg', '2023-06-04 00:00:00', 2, '1902@qq.com', '18920202020', NULL, 1, 1, NULL, NULL, NULL, '0002', NULL, NULL, 'admin', '2023-06-30 09:45:04', 'admin', '2023-06-30 10:56:09', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_user` VALUES ('1674623939134529537', '都是大号静待花开', '大叔大婶多·', '9a726e96be5b9f6079c3bb3bbe5df0ec9048e1356dc6a184f8b9cf702b969835', 'OfiI44od', '', NULL, NULL, NULL, NULL, NULL, 1, 1, NULL, NULL, NULL, '00004', NULL, NULL, 'admin', '2023-06-30 11:40:35', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_user` VALUES ('1679090647861534721', 'QA_001', '杨鑫', '4527eed62fd6a85e', 'ymu4tsFw', 'http://47.94.207.62/hzsomms/api/sys/common/static/temp/4e8943c3f6aee99eb3c4cef68574b63_1689161319503.jpg', '1996-10-01 00:00:00', 2, NULL, '13398482098', NULL, 1, 1, NULL, NULL, NULL, 'YX1009', NULL, NULL, 'admin', '2023-07-12 19:29:41', 'admin', '2023-07-13 14:17:32', NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('1679091952944390146', 'QA_002', '黄康林', 'c873645e798e72e6', 'bQ3OUvPc', 'http://47.94.207.62/hzsomms/api/sys/common/static/temp/4e8943c3f6aee99eb3c4cef68574b63_1689161685914.jpg', '2023-07-12 00:00:00', 1, NULL, '15968908643', NULL, 2, 1, NULL, NULL, NULL, 'QA1010', NULL, NULL, 'admin', '2023-07-12 19:34:52', 'admin', '2023-08-01 09:50:21', NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('1682266550175162370', 'adminA', 'adminA', '3b2f185738531cb2', '0WLJulkx', 'http://47.94.207.62/hzsomms/api/sys/common/static/temp/微信图片_20210111195305_1689918587809.jpg', NULL, NULL, NULL, '15178957895', NULL, 1, 1, NULL, NULL, NULL, '1', NULL, NULL, 'admin', '2023-07-21 13:49:35', 'admin', '2023-07-21 13:49:54', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_user` VALUES ('1682568327336456194', 'admin1', 'admin', '2ef01298901de3fc', 'RTQOrQ9h', 'http://47.94.207.62/hzsomms/api/sys/common/static/temp/微信图片_20211120101011_1689990516353.jpg', '2023-07-24 00:00:00', NULL, NULL, '15145614561', NULL, 1, 1, NULL, NULL, NULL, '55', NULL, NULL, 'admin', '2023-07-22 09:48:44', 'admin', '2023-07-24 17:15:15', NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('1682575826806534146', 'Zaq1234567', '王老师', 'ee1f1ee44d4f5bf43cef6cd3dec990da', 'FXX7cfzA', 'http://47.94.207.62/hzsomms/api/sys/common/static/temp/大胖橘_1689992289452.jpg', '2023-07-03 00:00:00', 1, '2424786965@qq.com', '17600168962', NULL, 1, 1, NULL, NULL, NULL, 'A001', NULL, NULL, 'admin', '2023-07-22 10:18:33', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_user` VALUES ('1682577603558567937', 'admin123', 'admin123', '385a5ad324736e37d165d282d168a3fd', 'y8rXwW2x', 'http://192.168.11.41:8080/hzsomms/api/sys/common/static/temp/微信图片_20211120101011_1689992718751.jpg', '2023-07-26 00:00:00', 1, 'sy1513575@163.com', '15178947894', NULL, 1, 1, NULL, NULL, NULL, '123', NULL, NULL, 'admin', '2023-07-22 10:25:36', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_user` VALUES ('1682669913329004545', 'admin789', '123', '2624a9026075dc7f43378d83e2879803', 'ZVPoIKFj', 'http://47.94.207.62/hzsomms/api/sys/common/static/temp/微信图片_20211120101011_1690014674181.jpg', '2023-07-21 00:00:00', 1, '1932760265@qq.com', '15178967896', NULL, 1, 1, NULL, NULL, NULL, '1232', NULL, NULL, 'admin', '2023-07-22 16:32:24', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_user` VALUES ('1683283722284482562', 'admin7', 'admin7', '807f1262ff9ef846', 'AL7fi59T', 'http://47.94.207.62/hzsomms/api/sys/common/static/temp/微信图片_20211120100902_1690161026915.jpg', '2023-07-24 00:00:00', 1, '1932760268@qq.com', '15145614567', NULL, 1, 1, NULL, NULL, NULL, '007', NULL, NULL, 'admin', '2023-07-24 09:11:28', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_user` VALUES ('1683405272625897474', 'admin123', 'admin1', 'dea29aee9ae4bfd5850e385a11882975', 'xNjiwueT', 'http://192.168.11.41:8080/hzsomms/api/sys/common/static/temp/微信图片_20211120101011_1690190051607.jpg', '2023-07-24 00:00:00', 2, 'sy1513575@163.com', '15178947894', NULL, 1, 1, NULL, NULL, NULL, '123', NULL, NULL, 'admin', '2023-07-24 17:14:28', 'admin', '2023-07-24 17:14:48', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_user` VALUES ('1683406075742838786', 'admin1', 'admin1', '50c5300d07e94970', '7wmpEKqw', 'http://192.168.11.41:8080/hzsomms/api/sys/common/static/temp/微信图片_20230512154644_1690190209476.jpg', '2023-07-31 00:00:00', 1, '1932760269@qq.com', '15178947895', NULL, 1, 1, NULL, NULL, NULL, '001', NULL, NULL, 'admin', '2023-07-24 17:17:39', NULL, NULL, NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('1683406357621039106', '123123123', '123123', '7e46bc4c0845101160f535f7aef847c0', 'oudLZakJ', 'http://192.168.11.41:8080/hzsomms/api/sys/common/static/temp/微信图片_20210111195305_1690190278841.jpg', '2023-07-31 00:00:00', 1, '', '15178927892', NULL, 1, 1, NULL, NULL, NULL, '123123', NULL, NULL, 'admin', '2023-07-24 17:18:46', NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_user` VALUES ('1683659253953773569', 'admin1', 'admin1', 'd29f75631fd617e9', 'xlNElYnW', 'http://47.94.207.62/hzsomms/api/sys/common/static/temp/微信图片_20211120100653_1690250606948.jpg', '2023-07-25 00:00:00', 1, 'sy1513575@163.com', '15178947897', NULL, 1, 0, NULL, NULL, NULL, '001', NULL, NULL, 'admin', '2023-07-25 10:03:42', NULL, NULL, NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('1688472575207211009', 'QA_001', '杨鑫', '06a095c8120e3522', 'W1IBSdP9', '', '2023-08-07 00:00:00', 2, '19807@qq.com', '13324152309', NULL, 1, 1, NULL, NULL, NULL, 'QA_001', NULL, NULL, 'admin', '2023-08-07 16:50:07', NULL, NULL, NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('1688483755359404034', 'QA_001', 'QA_001', '75b27bd41cd580a0', 'aVvZBJ32', '', '2023-08-07 00:00:00', 1, '2190@qq.com', '13321095890', NULL, 1, 0, NULL, NULL, NULL, '123454321', NULL, NULL, 'admin', '2023-08-07 17:34:32', 'admin', '2023-08-15 15:25:48', NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('1689821064642121729', 'QA_003', '杨X', 'b1db7c71f27bfbbd', 'qZrN0s5J', '', '2023-08-11 00:00:00', 1, '1199@qq.com', '13321097825', NULL, 1, 0, NULL, NULL, NULL, 'QA003', NULL, NULL, 'admin', '2023-08-11 10:08:32', NULL, NULL, NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('1691647593642610690', '123456', '杨X', '2b379277ea540b81', 'ht2SEKnZ', '', '2023-08-01 00:00:00', 2, '1980@qq.com', '13312340909', NULL, 1, 1, NULL, NULL, NULL, '', NULL, NULL, 'admin', '2023-08-16 11:06:30', 'admin', '2023-08-16 11:06:30', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `sys_user` VALUES ('1693432069578481666', 'QA_004', '张老师', '7b6a5ccb0f36864f', '8JlQ3tMn', '', '2023-08-21 00:00:00', 1, '123@123.com', '13888888888', NULL, 1, 1, NULL, NULL, NULL, '张老师', NULL, NULL, 'admin', '2023-08-21 09:17:22', 'admin', '2023-08-21 09:17:22', NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('1694960177385017345', 'QA_004', 'ZS', '8e7382b98d1d5051', 'tIUReQ2C', '', '2023-08-25 00:00:00', 1, '13490@qq.com', '13149021991', NULL, 1, 0, NULL, NULL, NULL, 'qa004', NULL, NULL, 'admin', '2023-08-25 14:29:32', 'admin', '2023-08-25 14:30:30', NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('1694961242641764353', 'QA_005', 'HKL', 'ff48c2655d3ea695', '0O3iWdjq', '', '2023-08-25 00:00:00', 1, '1348@qq.com', '15290294847', NULL, 1, 1, NULL, NULL, NULL, 'qa005', NULL, NULL, 'admin', '2023-08-25 14:33:46', 'admin', '2023-08-25 14:33:46', NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('1694963791029571585', 'QA_005', 'hkl', '6fb711070d2e5d23', 'mcv1fc8p', '', '2023-08-25 00:00:00', 1, '24324@qq.com', '15239802437', NULL, 1, 1, NULL, NULL, NULL, 'qa005', NULL, NULL, 'admin', '2023-08-25 14:43:53', 'admin', '2023-09-06 16:46:40', NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('1699343790138347522', 'QA_005', 'hkl', '989bc648b4deea76', 'cXQ7I3wt', '', '2023-09-06 00:00:00', 1, 'sddcn@qq.com', '13219847630', NULL, 1, 0, NULL, NULL, NULL, 'qa005', NULL, NULL, 'admin', '2023-09-06 16:48:26', 'admin', '2023-09-06 16:48:26', NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('1706596185369141250', 'QA_006', 'yx', 'd77f280512bf2676', 'SJMyoFoQ', '', '2023-09-26 00:00:00', 2, '1324@qq.com', '13134892089', NULL, 1, 0, NULL, NULL, NULL, 'qa006', NULL, NULL, 'admin', '2023-09-26 17:06:52', 'admin', '2023-09-26 17:06:52', NULL, NULL, NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('3d464b4ea0d2491aab8a7bde74c57e95', 'zhangsan', '张三', '02ea098224c7d0d2077c14b9a3a1ed16', 'x5xRdeKB', 'https://static.jeecg.com/temp/jmlogo_1606575041993.png', NULL, NULL, NULL, NULL, '财务部', 1, 0, NULL, NULL, 1, '0005', '总经理', NULL, 'admin', '2020-05-14 21:26:24', 'admin', '2023-06-30 11:35:24', 1, '', NULL, NULL, NULL);
INSERT INTO `sys_user` VALUES ('a75d45a015c44384a04449ee80dc3503', 'jeecg', 'jeecg', 'eee378a1258530cb', 'mIgiYJow', 'http://192.168.11.28:8080/hzsomms/api/sys/common/static/temp/favicon_1688354713101.ico', NULL, 1, NULL, NULL, 'A02A01', 1, 0, NULL, NULL, 1, '00002', 'devleader', NULL, 'admin', '2019-02-13 16:02:36', 'admin', '2023-07-03 11:25:16', 1, '', NULL, NULL, NULL);
INSERT INTO `sys_user` VALUES ('e9ca23d68d884d4ebb19d07889727dae', 'admin', '管理员', '3d5965db784e273c', 'xCQOD9fW', 'http://47.94.207.62/hzsomms/api/sys/common/static/temp/屏幕截图_20221122_153122_1689730789395.png', '2018-12-05 00:00:00', 1, 'jeecg@163.com', '18611111111', 'A01', 1, 0, NULL, NULL, 1, '00001', '总经理', NULL, NULL, '2019-06-21 17:54:10', 'admin', '2023-07-28 17:28:07', 2, '', NULL, 0, NULL);
INSERT INTO `sys_user` VALUES ('f0019fdebedb443c98dcb17d88222c38', 'zhagnxiao', '张小红12', 'f898134e5e52ae11a2ffb2c3b57a4e90', 'go3jJ4zX', 'http://47.94.207.62/hzsomms/api/sys/common/static/temp/demo_1688338206127_1688350815053.jpg', '2019-04-01 00:00:00', 1, '472132032@qq.com', '18611711111', '研发部,财务部', 1, 0, NULL, NULL, 1, '00003', 'devleader,总经理', NULL, 'admin', '2020-10-01 19:34:10', 'admin', '2023-07-03 10:20:23', 2, '1582683631414632450', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for sys_user_agent
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_agent`;
CREATE TABLE `sys_user_agent`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '序号',
  `user_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户名',
  `agent_user_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '代理人用户名',
  `start_time` datetime NULL DEFAULT NULL COMMENT '代理开始时间',
  `end_time` datetime NULL DEFAULT NULL COMMENT '代理结束时间',
  `status` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '状态0无效1有效',
  `create_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人名称',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人名称',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属部门',
  `sys_company_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '所属公司',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `uk_sug_user_name`(`user_name` ASC) USING BTREE,
  INDEX `idx_sug_status`(`status` ASC) USING BTREE,
  INDEX `idx_sug_start_time`(`start_time` ASC) USING BTREE,
  INDEX `idx_sug_end_time`(`end_time` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户代理人设置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_agent
-- ----------------------------
INSERT INTO `sys_user_agent` VALUES ('1632029640019922945', 'zhagnxiao', 'jeecg', '2023-03-04 22:45:50', '2023-03-04 05:00:00', '1', NULL, 'admin', '2023-03-04 22:46:02', NULL, NULL, NULL, 'A01', NULL);

-- ----------------------------
-- Table structure for sys_user_depart
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_depart`;
CREATE TABLE `sys_user_depart`  (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
  `user_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户id',
  `dep_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '部门id',
  PRIMARY KEY (`ID`) USING BTREE,
  INDEX `idx_sud_user_id`(`user_id` ASC) USING BTREE,
  INDEX `idx_sud_dep_id`(`dep_id` ASC) USING BTREE,
  INDEX `idx_sud_user_dep_id`(`user_id` ASC, `dep_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_depart
-- ----------------------------
INSERT INTO `sys_user_depart` VALUES ('1303584634328633345', '3d464b4ea0d2491aab8a7bde74c57e95', 'a7d7e77e06c84325a40932163adcdaa6');
INSERT INTO `sys_user_depart` VALUES ('1f3a0267811327b9eca86b0cc2b956f3', 'bcbe1290783a469a83ae3bd8effe15d4', '5159cde220114246b045e574adceafe9');

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_role`;
CREATE TABLE `sys_user_role`  (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `user_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户id',
  `role_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '角色id',
  `tenant_id` int NULL DEFAULT 0 COMMENT '租户ID',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_sur_user_id`(`user_id` ASC) USING BTREE,
  INDEX `idx_sur_role_id`(`role_id` ASC) USING BTREE,
  INDEX `idx_sur_user_role_id`(`user_id` ASC, `role_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '用户角色表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_role
-- ----------------------------
INSERT INTO `sys_user_role` VALUES ('0ede6d23d53bc7dc990346ff14faabee', '3db4cf42353f4e868b7ccfeef90505d2', 'ee8626f80f7c2619917b6236f3a7f02b', 0);
INSERT INTO `sys_user_role` VALUES ('1303584634118918145', '3d464b4ea0d2491aab8a7bde74c57e95', 'ee8626f80f7c2619917b6236f3a7f02b', 0);
INSERT INTO `sys_user_role` VALUES ('1674606245496659969', '1674594868778418178', '1169504891467464705', 0);
INSERT INTO `sys_user_role` VALUES ('1675690919538888705', 'f0019fdebedb443c98dcb17d88222c38', 'ee8626f80f7c2619917b6236f3a7f02b', 0);
INSERT INTO `sys_user_role` VALUES ('1675707249222901762', 'a75d45a015c44384a04449ee80dc3503', 'ee8626f80f7c2619917b6236f3a7f02b', 0);
INSERT INTO `sys_user_role` VALUES ('1675707317699108865', '1668512686431203329', '1260924539346472962', 0);
INSERT INTO `sys_user_role` VALUES ('1676186395371802626', '1674392755913818113', '1676186309912858626', 0);
INSERT INTO `sys_user_role` VALUES ('1679090774995083266', '1679090647861534721', '1679089298088370178', 0);
INSERT INTO `sys_user_role` VALUES ('1679091952956973058', '1679091952944390146', '1679089298088370178', 0);
INSERT INTO `sys_user_role` VALUES ('1681478935310163969', 'e9ca23d68d884d4ebb19d07889727dae', '1674685653284737026', 0);
INSERT INTO `sys_user_role` VALUES ('1682266627501350914', '1682266550175162370', 'f6817f48af4fb3af11b9e8bf182f618b', 0);
INSERT INTO `sys_user_role` VALUES ('1682575826835894273', '1682575826806534146', 'f6817f48af4fb3af11b9e8bf182f618b', 0);
INSERT INTO `sys_user_role` VALUES ('1682577603663425537', '1682577603558567937', '1674685653284737026', 0);
INSERT INTO `sys_user_role` VALUES ('1682669913333198849', '1682669913329004545', 'f6817f48af4fb3af11b9e8bf182f618b', 0);
INSERT INTO `sys_user_role` VALUES ('1683283722313842689', '1683283722284482562', '1169504891467464705', 0);
INSERT INTO `sys_user_role` VALUES ('1683405356281290753', '1683405272625897474', '1169504891467464705', 0);
INSERT INTO `sys_user_role` VALUES ('1683405472421568514', '1682568327336456194', 'f6817f48af4fb3af11b9e8bf182f618b', 0);
INSERT INTO `sys_user_role` VALUES ('1683405472526426114', '1682568327336456194', '1676186309912858626', 0);
INSERT INTO `sys_user_role` VALUES ('1683406075826724865', '1683406075742838786', '1169504891467464705', 0);
INSERT INTO `sys_user_role` VALUES ('1683406357721702402', '1683406357621039106', '1260924539346472962', 0);
INSERT INTO `sys_user_role` VALUES ('1683659253983133698', '1683659253953773569', '1260924539346472962', 0);
INSERT INTO `sys_user_role` VALUES ('1688472575228182530', '1688472575207211009', '1679089298088370178', 0);
INSERT INTO `sys_user_role` VALUES ('1688484179122520065', '1688483755359404034', '1688484141860323330', 0);
INSERT INTO `sys_user_role` VALUES ('1688819438586363905', '1688483755359404034', '1169504891467464705', 0);
INSERT INTO `sys_user_role` VALUES ('1689821064654704641', '1689821064642121729', '1688484141860323330', 0);
INSERT INTO `sys_user_role` VALUES ('1691647593680359425', '1691647593642610690', '1688484141860323330', 0);
INSERT INTO `sys_user_role` VALUES ('1693432070006300673', '1693432069578481666', 'ee8626f80f7c2619917b6236f3a7f02b', 0);
INSERT INTO `sys_user_role` VALUES ('1694960892920696833', '1694960177385017345', '1688484141860323330', 0);
INSERT INTO `sys_user_role` VALUES ('1694961281019645953', '1694961242641764353', '1688484141860323330', 0);
INSERT INTO `sys_user_role` VALUES ('1694963839222124546', '1694963791029571585', '1688484141860323330', 0);
INSERT INTO `sys_user_role` VALUES ('1699343836741259266', '1699343790138347522', '1688484141860323330', 0);
INSERT INTO `sys_user_role` VALUES ('1706596185402695682', '1706596185369141250', '1688484141860323330', 0);
INSERT INTO `sys_user_role` VALUES ('31af310584bd5795f76b1fe8c38294a0', '70f5dcf03f36471dabba81381919291f', 'e51758fa916c881624b046d26bd09230', 0);
INSERT INTO `sys_user_role` VALUES ('79d66ef7aa137cfa9957081a1483009d', '9a668858c4c74cf5a2b25ad9608ba095', 'ee8626f80f7c2619917b6236f3a7f02b', 0);
INSERT INTO `sys_user_role` VALUES ('8d7846ec783e157174e4ce2949231a65', '7ee6630e89d17afbf6d12150197b578d', 'e51758fa916c881624b046d26bd09230', 0);
INSERT INTO `sys_user_role` VALUES ('b3ffd9311a1ca296c44e2409b547384f', '01b802058ea94b978a2c96f4807f6b48', '1', 0);
INSERT INTO `sys_user_role` VALUES ('be2639167ede09379937daca7fc3bb73', '526f300ab35e44faaed54a9fb0742845', 'ee8626f80f7c2619917b6236f3a7f02b', 0);
INSERT INTO `sys_user_role` VALUES ('e78d210d24aaff48e0a736e2ddff4cdc', '3e177fede453430387a8279ced685679', 'ee8626f80f7c2619917b6236f3a7f02b', 0);
INSERT INTO `sys_user_role` VALUES ('ee45d0343ecec894b6886effc92cb0b7', '4d8fef4667574b24a9ccfedaf257810c', 'f6817f48af4fb3af11b9e8bf182f618b', 0);
INSERT INTO `sys_user_role` VALUES ('f2922a38ba24fb53749e45a0c459adb3', '439ae3e9bcf7418583fcd429cadb1d72', '1', 0);
INSERT INTO `sys_user_role` VALUES ('f2de3ae7b5efd8345581aa802a6675d6', '41b1be8d4c52023b0798f51164ca682d', 'e51758fa916c881624b046d26bd09230', 0);
INSERT INTO `sys_user_role` VALUES ('f72c6190b0722e798147e73c776c6ac9', '439ae3e9bcf7418583fcd429cadb1d72', 'ee8626f80f7c2619917b6236f3a7f02b', 0);

-- ----------------------------
-- Table structure for sys_user_tenant
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_tenant`;
CREATE TABLE `sys_user_tenant`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键id',
  `user_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '用户id',
  `tenant_id` int NULL DEFAULT NULL COMMENT '租户id',
  `status` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '状态(1 正常 2 离职 3 待审核 4 审核未通过)',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_sut_user_id`(`user_id` ASC) USING BTREE,
  INDEX `idx_sut_tenant_id`(`tenant_id` ASC) USING BTREE,
  INDEX `uniq_sut_user_rel_tenant`(`user_id` ASC, `tenant_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户租户关系表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user_tenant
-- ----------------------------

-- ----------------------------
-- Table structure for t_da_curve_management
-- ----------------------------
DROP TABLE IF EXISTS `t_da_curve_management`;
CREATE TABLE `t_da_curve_management`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元编码',
  `curve_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '曲线编码',
  `curve_deflection_angle` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '曲线偏角a(°′″)',
  `curve_radius` decimal(14, 3) NULL DEFAULT NULL COMMENT '曲线半径R(m)',
  `transition_curve_len` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '缓和曲线长I(m)',
  `tangent_len` decimal(14, 3) NULL DEFAULT NULL COMMENT '切线长T(m)',
  `curve_len` decimal(14, 3) NULL DEFAULT NULL COMMENT '曲线长L(m)',
  `curve_mileage_zh` decimal(14, 3) NULL DEFAULT NULL COMMENT '直缓（直圆）里程ZH(ZY)',
  `curve_mileage_hy` decimal(14, 3) NULL DEFAULT NULL COMMENT '缓圆里程(HY)',
  `curve_mileage_yh` decimal(14, 3) NULL DEFAULT NULL COMMENT '圆缓里程(YH)',
  `curve_mileage_hz` decimal(14, 3) NULL DEFAULT NULL COMMENT '缓直（圆直）里程HZ(YZ)',
  `super_high` decimal(14, 3) NULL DEFAULT NULL COMMENT '超高H(mm)',
  `section_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间id',
  `line_alias_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别id',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '资产管理-曲线管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_da_curve_management
-- ----------------------------

-- ----------------------------
-- Table structure for t_da_fastener_management
-- ----------------------------
DROP TABLE IF EXISTS `t_da_fastener_management`;
CREATE TABLE `t_da_fastener_management`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元编码',
  `fastener_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扣件编号',
  `fastener_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扣件类型',
  `fastener_num` int NULL DEFAULT NULL COMMENT '扣件数量',
  `section_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间id',
  `line_alias_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别id',
  `track_bed_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '道床id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '资产管理-扣件管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_da_fastener_management
-- ----------------------------

-- ----------------------------
-- Table structure for t_da_rail_management
-- ----------------------------
DROP TABLE IF EXISTS `t_da_rail_management`;
CREATE TABLE `t_da_rail_management`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'id',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元编码',
  `rail_order_num` int NULL DEFAULT NULL COMMENT '钢轨序号',
  `light_rail_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线路id',
  `rail_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '钢轨编码',
  `section_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间id',
  `line_alias_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别id',
  `starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '起始里程',
  `center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '中心里程',
  `end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '结束里程',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_light_rail_id`(`light_rail_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '资产管理-钢轨管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_da_rail_management
-- ----------------------------

-- ----------------------------
-- Table structure for t_da_sign_board_management
-- ----------------------------
DROP TABLE IF EXISTS `t_da_sign_board_management`;
CREATE TABLE `t_da_sign_board_management`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元编码',
  `sign_board_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨行区标识牌编号',
  `sign_board_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨行区标识牌类型',
  `section_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间id',
  `line_alias_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别id',
  `mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '里程',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '资产管理-轨行区标识牌管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_da_sign_board_management
-- ----------------------------

-- ----------------------------
-- Table structure for t_da_sleeper_management
-- ----------------------------
DROP TABLE IF EXISTS `t_da_sleeper_management`;
CREATE TABLE `t_da_sleeper_management`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元编码',
  `sleeper_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨枕编码',
  `sleeper_num` int NULL DEFAULT NULL COMMENT '轨枕数量',
  `sleeper_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨枕类型',
  `section_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间id',
  `line_alias_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别id',
  `track_bed_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '道床id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '资产管理-轨枕管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_da_sleeper_management
-- ----------------------------

-- ----------------------------
-- Table structure for t_da_switch_management
-- ----------------------------
DROP TABLE IF EXISTS `t_da_switch_management`;
CREATE TABLE `t_da_switch_management`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元编码',
  `switch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '道岔编号',
  `switch_model` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '道岔型号',
  `line_alias_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别Id',
  `open_to` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开向',
  `byroad_pre_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '岔前/岔前里程',
  `byroad_center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '岔心里程',
  `byroad_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '岔前/岔后里程',
  `section_station_map_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间车站mapId',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '资产管理-道岔管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_da_switch_management
-- ----------------------------

-- ----------------------------
-- Table structure for t_da_track_bed_management
-- ----------------------------
DROP TABLE IF EXISTS `t_da_track_bed_management`;
CREATE TABLE `t_da_track_bed_management`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'id',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元编码',
  `track_bed_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '道床编号',
  `track_bed_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '道床类型',
  `section_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间id',
  `line_alias_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别id',
  `starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '起始里程',
  `end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '结束里程',
  `track_bed_len` decimal(14, 3) NULL DEFAULT NULL COMMENT '道床长度=结束里程-起始里程',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '资产管理-道床管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_da_track_bed_management
-- ----------------------------

-- ----------------------------
-- Table structure for t_da_vertical_curve_management
-- ----------------------------
DROP TABLE IF EXISTS `t_da_vertical_curve_management`;
CREATE TABLE `t_da_vertical_curve_management`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元编码',
  `vertical_curve_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '竖曲线编号',
  `section_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间id',
  `line_alias_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别id',
  `starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '起始里程',
  `center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '中心里程',
  `end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '结束里程',
  `vertical_curve_adius` decimal(14, 3) NULL DEFAULT NULL COMMENT '竖曲线半径R(m)',
  `tangent_len` decimal(14, 3) NULL DEFAULT NULL COMMENT '切线长T(m)',
  `apex_distance` decimal(14, 8) NULL DEFAULT NULL COMMENT '外矢距/E(m)',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '资产管理-竖曲线管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_da_vertical_curve_management
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_additive_info
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_additive_info`;
CREATE TABLE `t_djt_movement_additive_info`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `movement_master_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动静态几何尺寸数据主表主键-》外键',
  `point_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '测点里程',
  `zontal_speed` decimal(14, 3) NULL DEFAULT NULL COMMENT '水平加速度',
  `zontal_speed_level` int NULL DEFAULT NULL COMMENT '水平加速度等级',
  `vertical_speed` decimal(14, 3) NULL DEFAULT NULL COMMENT '垂直加速度',
  `vertical_speed_level` int NULL DEFAULT NULL COMMENT '垂直加速度等级',
  `speed` decimal(14, 3) NULL DEFAULT NULL COMMENT '速度',
  `mark` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手动标记',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除；1：已删除）',
  `info_sort` int NULL DEFAULT NULL COMMENT '排序字段',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态几何尺寸对应的添乘仪详情表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_additive_info
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_additive_info_unit_device_map
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_additive_info_unit_device_map`;
CREATE TABLE `t_djt_movement_additive_info_unit_device_map`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `movement_master_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动静态几何尺寸数据主表主键-》外键',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元编码',
  `unit_device_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元编码',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元类型名称',
  `unit_start_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元起始里程',
  `unit_center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元中心里程',
  `unit_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元终点里程',
  `point_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '测点里程',
  `zontal_speed` decimal(14, 3) NULL DEFAULT NULL COMMENT '水平加速度',
  `zontal_speed_level` int NULL DEFAULT NULL COMMENT '水平加速度等级',
  `vertical_speed` decimal(14, 3) NULL DEFAULT NULL COMMENT '垂直加速度',
  `vertical_speed_level` int NULL DEFAULT NULL COMMENT '垂直加速度等级',
  `speed` decimal(14, 3) NULL DEFAULT NULL COMMENT '速度',
  `mark` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手动标记',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除；1：已删除）',
  `info_sort` int NULL DEFAULT NULL COMMENT '排序字段',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态几何尺寸对应的添乘仪详情表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_additive_info_unit_device_map
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_check_data_unit_device_map
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_check_data_unit_device_map`;
CREATE TABLE `t_djt_movement_check_data_unit_device_map`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元编码',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元类型名称',
  `unit_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元起始里程',
  `unit_center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元中心里程',
  `unit_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元终点里程',
  `check_type` int NULL DEFAULT NULL COMMENT '检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查',
  `check_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查主表id',
  `check_item_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查项目id',
  `check_item_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查项目开始里程',
  `check_item_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查项目结束里程',
  `check_item_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查项目文本',
  `check_detail_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查详情id',
  `check_detail_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查详情开始里程',
  `check_detail_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查详情结束里程',
  `measure_point` int NULL DEFAULT NULL COMMENT '测点',
  `track_gauge` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距',
  `level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平',
  `triangular_pit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑',
  `direction` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '方向',
  `height` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '高低',
  `structure` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '结构',
  `rectification` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '整改',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态几何尺寸-检查数据单元映射表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_check_data_unit_device_map
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_course
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_course`;
CREATE TABLE `t_djt_movement_course`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `movement_master_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动静态几何尺寸数据主表主键-》外键',
  `course_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查起始里程（m）',
  `course_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查终点里程(m)',
  `curve_radius` decimal(14, 3) NULL DEFAULT NULL COMMENT '曲线半径（m）',
  `super_high` decimal(14, 3) NULL DEFAULT NULL COMMENT '超高（mm）',
  `widen` decimal(14, 3) NULL DEFAULT NULL COMMENT '加宽（mm）',
  `slope_ratio` decimal(14, 3) NULL DEFAULT NULL COMMENT '顺坡率（‰）',
  `long_extent` decimal(14, 3) NULL DEFAULT NULL COMMENT '长度（m）',
  `remark` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '备注',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除；1：已删除）',
  `sort` int NULL DEFAULT NULL COMMENT '导入排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态几何尺寸对应得里程相关信息表\r\n' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_course
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_course_info
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_course_info`;
CREATE TABLE `t_djt_movement_course_info`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `movement_master_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动静态几何尺寸数据主表主键-》外键',
  `movement_course_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动静态几何尺寸对应得里程信息主键-》外键',
  `track_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨号',
  `measure_point` int NULL DEFAULT NULL COMMENT '测点',
  `track_gauge` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距',
  `level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平',
  `triangular_pit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑',
  `direction` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '方向',
  `height` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '高低',
  `structure` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '结构',
  `rectification` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '整改',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除；1：已删除）',
  `info_sort` int NULL DEFAULT NULL COMMENT '排序字段',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态几何尺寸对应得里程相关信息详情表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_course_info
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_diference_manager
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_diference_manager`;
CREATE TABLE `t_djt_movement_diference_manager`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `movement_master_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动静态几何尺寸数据主表主键-》外键',
  `min_spend_level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '最小速度等级',
  `max_spend_level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '最大速度等级',
  `exceed_level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超限等级',
  `height` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '高低（mm）',
  `track_alignment` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨向（mm）',
  `max_track_gauge` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '大轨距（mm）',
  `min_track_gauge` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '小轨距（mm）',
  `level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平（mm）',
  `triangular_pit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑（mm）',
  `vertical_spend` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '垂直加速度（g）',
  `transverse_spend` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '横向加速度（g）',
  `gauge_change` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距变化率',
  `curvature_change` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '曲率变化率',
  `deduct_standard` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扣分标准',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除； 1：已删除）',
  `sort` int NULL DEFAULT NULL COMMENT '导入顺序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '轨检车-》轨道动态几何尺寸容许值差管理值\r\n' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_diference_manager
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_over_report
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_over_report`;
CREATE TABLE `t_djt_movement_over_report`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `movement_master_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动静态几何尺寸数据主表主键-》外键',
  `xuhao` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '序号',
  `mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '里程(m)',
  `section_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间名称',
  `overrun_type` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超限类型',
  `overrun_level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超限等级',
  `longitude` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '长度',
  `peak_value` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '峰值（mm或g）',
  `data_difference` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '管理数据差',
  `xianxing` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线性',
  `standard` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检测标准',
  `spend` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '速度（km/h）',
  `remark` varchar(328) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除； 1：已删除）',
  `sort` int NULL DEFAULT NULL COMMENT '导入顺序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '轨检车-》超限记录报告\r\n' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_over_report
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_over_report_unit_device_map
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_over_report_unit_device_map`;
CREATE TABLE `t_djt_movement_over_report_unit_device_map`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元编码',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元类型名称',
  `unit_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元起始里程',
  `unit_center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元中心里程',
  `unit_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元终点里程',
  `check_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查主表id',
  `check_type` int NULL DEFAULT NULL COMMENT '检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查',
  `over_report_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨检车超限表id',
  `over_report_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '超限里程',
  `over_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超限类型',
  `over_level` int NULL DEFAULT NULL COMMENT '超限等级',
  `longitude` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '长度',
  `peak_value` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '峰值（mm或g）',
  `data_difference` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '管理数据差',
  `xianxing` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线性',
  `standard` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查标准',
  `spend` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '速度（km/h）',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态几何尺寸-轨检车单元设备映射' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_over_report_unit_device_map
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_records_master
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_records_master`;
CREATE TABLE `t_djt_movement_records_master`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动态几何尺寸类型（1：人工静态检查；2：轨检仪静态检查; 3:轨检车检查；4：添乘仪检查）',
  `ek_code` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查批次编号',
  `track_code` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨检车号',
  `work_code` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工单编号',
  `subway_section_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查区间id',
  `subway_section_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查区间名称',
  `light_rail_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线路id',
  `light_rail_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线路名称',
  `line_alias_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线别id',
  `line_alias_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线别名称',
  `starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '起始里程',
  `end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '终点里程',
  `start_level` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '开始速度等级',
  `end_level` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '结束速度等级',
  `direction` int NULL DEFAULT NULL COMMENT '轨梁方向(1:正；2：反)',
  `rail_num` int NULL DEFAULT NULL COMMENT '钢轨单元数量',
  `curve_num` int NULL DEFAULT NULL COMMENT '曲线数量',
  `vertical_curve_num` int NULL DEFAULT NULL COMMENT '竖曲线数量',
  `switch_num` int NULL DEFAULT NULL COMMENT '道岔数量',
  `check_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查人姓名',
  `check_time` datetime NULL DEFAULT NULL COMMENT '检查日期',
  `verify_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审核人姓名',
  `verify_time` datetime NULL DEFAULT NULL COMMENT '审核时间',
  `print_time` datetime NULL DEFAULT NULL COMMENT '打印日期',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除；1：已删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态几何尺寸数据主表\r\n' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_records_master
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_section_report
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_section_report`;
CREATE TABLE `t_djt_movement_section_report`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `movement_master_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动静态几何尺寸数据主表主键-》外键',
  `project_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '项目名称',
  `number_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '个数->一级',
  `number_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '个数->二级',
  `number_three` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '个数->三级',
  `number_four` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '个数->四级',
  `number_sum` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '个数->总数',
  `number_ave` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '个数->个数/公里',
  `number_per` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '个数->百分比',
  `deduct_sum` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扣分->扣分总计',
  `deduct_ave` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扣分->扣分/公里',
  `deduct_per` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扣分->扣分百分比',
  `tqi_ave` varchar(328) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'TQI->平均指数',
  `tqi_exceed_num` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'TQI->超标段数',
  `tqi_exceed_per` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'TQI->超标百分比',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除； 1：已删除）',
  `sort` int NULL DEFAULT NULL COMMENT '导入顺序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '轨检车-》区段总结报告\r\n' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_section_report
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_summary_report
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_summary_report`;
CREATE TABLE `t_djt_movement_summary_report`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `movement_master_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动静态几何尺寸数据主表主键-》外键',
  `kilometer` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公里',
  `longitude` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '长度(m)',
  `left_high_low_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '左高低1',
  `left_high_low_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '左高低2',
  `left_high_low_three` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '左高低3',
  `left_high_low_four` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '左高低4',
  `right_high_low_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '右高低1',
  `right_high_low_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '右高低2',
  `right_high_low_three` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '右高低3',
  `right_high_low_four` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '右高低4',
  `left_track_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '左轨向1',
  `left_track_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '左轨向2',
  `left_track_three` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '左轨向3',
  `left_track_four` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '左轨向4',
  `right_track_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '右轨向1',
  `right_track_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '右轨向2',
  `right_track_three` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '右轨向3',
  `right_track_four` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '右轨向4',
  `track_gauge_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距1',
  `track_gauge_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距2',
  `track_gauge_three` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距3',
  `track_gauge_four` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距4',
  `level_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平1',
  `level_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平2',
  `level_three` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平3',
  `level_four` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平4',
  `triangular_pit_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑1',
  `triangular_pit_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑2',
  `triangular_pit_three` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑3',
  `triangular_pit_four` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑4',
  `curvature_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '曲率1',
  `curvature_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '曲率2',
  `curvature_three` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '曲率3',
  `curvature_four` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '曲率4',
  `droop_velocity_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '垂向加速度1',
  `droop_velocity_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '垂向加速度2',
  `droop_velocity_three` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '垂向加速度3',
  `droop_velocity_four` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '垂向加速度4',
  `across_velocity_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '横向加速度1',
  `across_velocity_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '横向加速度2',
  `across_velocity_three` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '横向加速度3',
  `across_velocity_four` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '横向加速度4',
  `curvature_change_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '曲率变化率1',
  `curvature_change_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '曲率变化率2',
  `track_gauge_change_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距变化率1',
  `track_gauge_change_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距变化率2',
  `kilometer_deduct` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公里扣分',
  `evaluate` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '评定',
  `speed` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '速度（km/h）',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除； 1：已删除）',
  `sort` int NULL DEFAULT NULL COMMENT '导入顺序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '轨检车-》公里总结报告表\r\n' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_summary_report
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_tqi_kilometer_report
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_tqi_kilometer_report`;
CREATE TABLE `t_djt_movement_tqi_kilometer_report`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `movement_master_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动静态几何尺寸数据主表主键-》外键',
  `kilometer` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '公里',
  `standard` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标准',
  `not_above_standard` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '未超标',
  `above_standard` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超标',
  `above_standard_ten` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超标10',
  `above_standard_twenty` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超标20',
  `come_upon` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'T值',
  `rate` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '评价',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除； 1：已删除）',
  `sort` int NULL DEFAULT NULL COMMENT '导入顺序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '轨检车-》TQI公里总结报告\r\n' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_tqi_kilometer_report
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_tqi_kilometer_standard_manager
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_tqi_kilometer_standard_manager`;
CREATE TABLE `t_djt_movement_tqi_kilometer_standard_manager`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `movement_master_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动静态几何尺寸数据主表主键-》外键',
  `evaluate` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '评价定义',
  `balanced` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '均衡',
  `min_plan` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '计划最小值',
  `max_plan` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '计划最大值',
  `first` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '优先值',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除； 1：已删除）',
  `sort` int NULL DEFAULT NULL COMMENT '导入顺序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '轨检车-》TQI公里状态评定标准\r\n' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_tqi_kilometer_standard_manager
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_tqi_report
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_tqi_report`;
CREATE TABLE `t_djt_movement_tqi_report`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `movement_master_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动静态几何尺寸数据主表主键-》外键',
  `start_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '开始里程(m)',
  `end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '终点里程(m)',
  `section_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间名称',
  `high_low_left` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '高低左',
  `high_low_right` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '高低右',
  `track_left` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨向左',
  `track_right` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨向右',
  `level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平（mm）',
  `track_gauge` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距（mm）',
  `triangular_pit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑（mm）',
  `tqi_come_upon` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'TQI数值',
  `tqi_above_standard` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'TQI超标',
  `deduct` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扣分',
  `standard` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检测标准',
  `spend` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '速度（km/h）',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除； 1：已删除）',
  `sort` int NULL DEFAULT NULL COMMENT '导入顺序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '轨检车-》TQI总结报告\r\n' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_tqi_report
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_tqi_report_unit_device_map
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_tqi_report_unit_device_map`;
CREATE TABLE `t_djt_movement_tqi_report_unit_device_map`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `check_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查主表id',
  `check_type` int NULL DEFAULT NULL COMMENT '检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元code',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元名称',
  `unit_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元开始里程',
  `unit_center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元中心里程',
  `unit_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元结束里程',
  `tqi_report_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'tqi报告id',
  `start_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '开始里程(m)',
  `end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '终点里程(m)',
  `section_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间名称',
  `high_low_left` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '高低左',
  `high_low_right` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '高低右',
  `track_left` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨向左',
  `track_right` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨向右',
  `level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平（mm）',
  `track_gauge` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距（mm）',
  `triangular_pit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑（mm）',
  `tqi_come_upon` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'TQI数值',
  `tqi_above_standard` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'TQI超标',
  `deduct` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扣分',
  `standard` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检测标准',
  `spend` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '速度（km/h）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '轨检车-tqi单元总结报告和单元映射关联关系' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_tqi_report_unit_device_map
-- ----------------------------

-- ----------------------------
-- Table structure for t_djt_movement_tqi_standard_manager
-- ----------------------------
DROP TABLE IF EXISTS `t_djt_movement_tqi_standard_manager`;
CREATE TABLE `t_djt_movement_tqi_standard_manager`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `movement_master_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动静态几何尺寸数据主表主键-》外键',
  `min_spend_level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '最小速度等级',
  `max_spend_level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '最大速度等级',
  `height` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '高低（mm）',
  `track_alignment` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨向（mm）',
  `track_gauge` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距（mm）',
  `level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平（mm）',
  `triangular_pit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑（mm）',
  `tqi_value` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'TQI',
  `min_tqi_exceed_ten` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超标<=10%->TQI最小值',
  `max_tqi_exceed_ten` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超标<=10%->TQI最大值',
  `tqi_exceed_ten_deduct` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超标<=10%->扣分',
  `min_tqi_exceed_twenty` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超标<=20%->TQI最小值',
  `max_tqi_exceed_twenty` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超标<=20%->TQI最大值',
  `tqi_exceed_twenty_deduct` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超标<=20%->扣分',
  `min_tqi_exceed_pass_twenty` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超标>20%->TQI最小值',
  `tqi_exceed_pass_twenty_deduct` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超标>20%->TQI扣分',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除； 1：已删除）',
  `sort` int NULL DEFAULT NULL COMMENT '导入顺序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '轨检车-》200m区段轨道不平顺质量指数TQI管理标准(单位：mm)\r\n' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_djt_movement_tqi_standard_manager
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_analysis_additive_check_unit_device_map
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_analysis_additive_check_unit_device_map`;
CREATE TABLE `t_dsa_analysis_additive_check_unit_device_map`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `analysis_batch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次id',
  `analysis_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次code',
  `analysis_batch_unit_device_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次单元设备id',
  `movement_master_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '动静态几何尺寸数据主表主键-》外键',
  `movement_additive_info_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '添乘仪记录id',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元编码',
  `unit_device_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元编码',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元类型名称',
  `unit_start_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元起始里程',
  `unit_center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元中心里程',
  `unit_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元终点里程',
  `point_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '测点里程',
  `zontal_speed` decimal(14, 3) NULL DEFAULT NULL COMMENT '水平加速度',
  `zontal_speed_level` int NULL DEFAULT NULL COMMENT '水平加速度等级',
  `vertical_speed` decimal(14, 3) NULL DEFAULT NULL COMMENT '垂直加速度',
  `vertical_speed_level` int NULL DEFAULT NULL COMMENT '垂直加速度等级',
  `speed` decimal(14, 3) NULL DEFAULT NULL COMMENT '速度',
  `mark` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手动标记',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除；1：已删除）',
  `info_sort` int NULL DEFAULT NULL COMMENT '排序字段',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-添乘仪详情表分析批次关联关系表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_analysis_additive_check_unit_device_map
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_analysis_batch
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_analysis_batch`;
CREATE TABLE `t_dsa_analysis_batch`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `analysis_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次号',
  `light_rail_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线路id',
  `light_rail_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线路名称',
  `line_alias_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线别id',
  `line_alias_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线别名称',
  `starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '起始里程',
  `end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '终点里程',
  `dict_value` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '评价速度等级字典值',
  `dict_label` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '评价速度等级字典名称',
  `speed_min` int NULL DEFAULT NULL COMMENT '速度下限',
  `speed_max` int NULL DEFAULT NULL COMMENT '速度上限',
  `analysis_type` int NULL DEFAULT NULL COMMENT '分析类型 1-均值分析 2-峰值分析',
  `allow_value` json NULL COMMENT '容许值差',
  `dispatching` json NULL COMMENT '派工设置',
  `analysis_status` int NULL DEFAULT NULL COMMENT '分析状态 0-创建 1-分析中  99-分析完成',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-分析批次表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_analysis_batch
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_analysis_batch_check_data_map
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_analysis_batch_check_data_map`;
CREATE TABLE `t_dsa_analysis_batch_check_data_map`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `analysis_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次号',
  `analysis_batch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批id',
  `ek_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查批次号',
  `ek_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查批id',
  `ek_type` int NULL DEFAULT NULL COMMENT '检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查',
  `check_time` datetime NULL DEFAULT NULL COMMENT '检查日期',
  `starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '起始里程',
  `end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '终点里程',
  `allow_value` json NULL COMMENT '容许值差',
  `dispatching` json NULL COMMENT '派工设置',
  `analysis_status` int NULL DEFAULT NULL COMMENT '分析状态 0-创建 1-分析中  99-分析完成',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_analysis_batch_id`(`analysis_batch_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-分析批次-检查数据关联关系' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_analysis_batch_check_data_map
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_analysis_batch_unit_device
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_analysis_batch_unit_device`;
CREATE TABLE `t_dsa_analysis_batch_unit_device`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `analysis_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次号',
  `analysis_batch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批id',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元设备id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元设备code',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元类型名称',
  `unit_device_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备编号',
  `unit_start_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元起始里程',
  `unit_center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元中心里程',
  `unit_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元结束里程',
  `unit_score_level` int NULL DEFAULT NULL COMMENT '单元得分等级 1-优良 2-合格 3-失格',
  `unit_score_level_str` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元得分等级str',
  `unit_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '单元得分',
  `labour_check` tinyint NULL DEFAULT 0 COMMENT '是否存在人工检查数据 0-不存在 1-存在',
  `labour_check_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '人工检查数据得分',
  `rail_device_check` tinyint NULL DEFAULT 0 COMMENT '是否存在轨检仪检查数据 0-不存在 1-存在',
  `rail_device_check_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '轨检仪检查数据得分',
  `rail_vehicle_check` tinyint NULL DEFAULT 0 COMMENT '是否存在轨检车查数据 0-不存在 1-存在',
  `rail_vehicle_check_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '轨检车查数据得分',
  `add_device_check` tinyint NULL DEFAULT 0 COMMENT '是否存在添乘仪查数据 0-不存在 1-存在',
  `add_device_check_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '添乘仪查数据得分',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-分析批次-单元设备' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_analysis_batch_unit_device
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_analysis_batch_unit_device_point_score
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_analysis_batch_unit_device_point_score`;
CREATE TABLE `t_dsa_analysis_batch_unit_device_point_score`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `speed_min` int NULL DEFAULT NULL COMMENT '速度下限',
  `speed_max` int NULL DEFAULT NULL COMMENT '速度上限',
  `analysis_type` int NULL DEFAULT NULL COMMENT '分析类型 1-均值分析 2-峰值分析',
  `analysis_batch_unit_device_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次单元设备id',
  `analysis_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次号',
  `analysis_batch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批id',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元设备id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元设备code',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元类型名称',
  `check_type` int NULL DEFAULT NULL COMMENT '检查类型 1-人工检查 2-轨检仪类型 3-轨检车类型 4-添乘仪类型',
  `point_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '测点类型',
  `point_value` decimal(14, 3) NULL DEFAULT NULL COMMENT '测点值',
  `point_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '测点得分',
  `weight_values` decimal(14, 3) NULL DEFAULT NULL COMMENT '权值',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-分析批次-单元设备测点得分' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_analysis_batch_unit_device_point_score
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_analysis_batch_unit_device_tqi_score
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_analysis_batch_unit_device_tqi_score`;
CREATE TABLE `t_dsa_analysis_batch_unit_device_tqi_score`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `speed_min` int NULL DEFAULT NULL COMMENT '速度下限',
  `speed_max` int NULL DEFAULT NULL COMMENT '速度上限',
  `analysis_type` int NULL DEFAULT NULL COMMENT '分析类型 1-均值分析 2-峰值分析',
  `analysis_batch_unit_device_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次单元设备id',
  `analysis_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次号',
  `analysis_batch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批id',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元设备id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元设备code',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元类型名称',
  `point_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '测点类型',
  `high_low_left` decimal(14, 3) NULL DEFAULT NULL COMMENT '高低左',
  `high_low_left_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '高低左分数',
  `high_low_left_weight_values` decimal(14, 3) NULL DEFAULT NULL COMMENT '高低左权值',
  `high_low_right` decimal(14, 3) NULL DEFAULT NULL COMMENT '高低右',
  `high_low_right_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '高低右分数',
  `high_low_right_weight_values` decimal(14, 3) NULL DEFAULT NULL COMMENT '高低右权值',
  `track_left` decimal(14, 3) NULL DEFAULT NULL COMMENT '轨向左',
  `track_left_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '轨向左分数',
  `track_left_weight_values` decimal(14, 3) NULL DEFAULT NULL COMMENT '轨向左权值',
  `track_right` decimal(14, 3) NULL DEFAULT NULL COMMENT '轨向右',
  `track_right_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '轨向右分数',
  `track_right_weight_values` decimal(14, 3) NULL DEFAULT NULL COMMENT '轨向右权值',
  `level` decimal(14, 3) NULL DEFAULT NULL COMMENT '水平（mm）',
  `level_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '水平（mm）分数',
  `level_weight_values` decimal(14, 3) NULL DEFAULT NULL COMMENT '水平（mm）权值',
  `track_gauge` decimal(14, 3) NULL DEFAULT NULL COMMENT '轨距（mm）',
  `track_gauge_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '轨距（mm）分数',
  `track_gauge_weight_values` decimal(14, 3) NULL DEFAULT NULL COMMENT '轨距（mm）权值',
  `triangular_pit` decimal(14, 3) NULL DEFAULT NULL COMMENT '三角坑（mm）',
  `triangular_pit_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '三角坑（mm）分数',
  `triangular_pit_weight_values` decimal(14, 3) NULL DEFAULT NULL COMMENT '三角坑（mm）权值',
  `tqi_come_upon` decimal(14, 3) NULL DEFAULT NULL COMMENT 'TQI数值',
  `tqi_come_upon_score` decimal(14, 3) NULL DEFAULT NULL COMMENT 'TQI数值分数',
  `tqi_come_upon_weight_values` decimal(14, 3) NULL DEFAULT NULL COMMENT 'TQI数值权值',
  `sum_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '总得分',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-分析批次-单元设备测点得分' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_analysis_batch_unit_device_tqi_score
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_analysis_batch_unit_device_transfinite
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_analysis_batch_unit_device_transfinite`;
CREATE TABLE `t_dsa_analysis_batch_unit_device_transfinite`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `analysis_batch_unit_device_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次单元设备id',
  `analysis_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次号',
  `analysis_batch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批id',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元设备id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元设备code',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元类型名称',
  `transfinite_grade` int NULL DEFAULT NULL COMMENT '超限等级',
  `transfinite_grade_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超限等级名称',
  `transfinite_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超限类型',
  `allow_value` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '容许值',
  `measure_point_value` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '测点值',
  `ek_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查主表id',
  `ek_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查类型 检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查',
  `ek_item_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查项目id(如果是人工和轨检查仪器就是检查项目id)',
  `is_work` int NULL DEFAULT NULL COMMENT '是否派工 0-否 1-是',
  `disease_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '病害里程',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idnex1`(`analysis_batch_unit_device_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-分析批次-单元设备超限' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_analysis_batch_unit_device_transfinite
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_analysis_batch_unit_device_work
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_analysis_batch_unit_device_work`;
CREATE TABLE `t_dsa_analysis_batch_unit_device_work`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `analysis_batch_unit_device_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次单元设备id',
  `analysis_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次号',
  `analysis_batch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批id',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元设备id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元设备code',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元类型名称',
  `work_reason` int NULL DEFAULT NULL COMMENT '派工原因',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-分析批次-单元设备派工表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_analysis_batch_unit_device_work
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_analysis_labour_check_data_unit_device_map
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_analysis_labour_check_data_unit_device_map`;
CREATE TABLE `t_dsa_analysis_labour_check_data_unit_device_map`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `analysis_batch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次id',
  `analysis_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次code',
  `analysis_batch_unit_device_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次单元设备id',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元编码',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元类型名称',
  `unit_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元起始里程',
  `unit_center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元中心里程',
  `unit_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元终点里程',
  `check_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查主表id',
  `check_item_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查项目id',
  `check_item_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查项目开始里程',
  `check_item_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查项目结束里程',
  `check_item_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查项目文本',
  `check_detail_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查详情id',
  `check_detail_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查详情开始里程',
  `check_detail_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查详情结束里程',
  `measure_point` int NULL DEFAULT NULL COMMENT '测点',
  `track_gauge` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距',
  `level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平',
  `triangular_pit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑',
  `direction` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '方向',
  `height` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '高低',
  `structure` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '结构',
  `rectification` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '整改',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-人工检查数据分析批次映射' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_analysis_labour_check_data_unit_device_map
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_analysis_over_report_check_unit_device_map
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_analysis_over_report_check_unit_device_map`;
CREATE TABLE `t_dsa_analysis_over_report_check_unit_device_map`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `analysis_batch_unit_device_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次单元设备id',
  `analysis_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次号',
  `analysis_batch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批id',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元编码',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元类型名称',
  `unit_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元起始里程',
  `unit_center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元中心里程',
  `unit_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元终点里程',
  `check_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查主表id',
  `check_type` int NULL DEFAULT NULL COMMENT '检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查',
  `over_report_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨检车超限表id',
  `over_report_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '超限里程',
  `over_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '超限类型',
  `over_level` int NULL DEFAULT NULL COMMENT '超限等级',
  `longitude` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '长度',
  `peak_value` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '峰值（mm或g）',
  `data_difference` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '管理数据差',
  `xianxing` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线性',
  `standard` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查标准',
  `spend` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '速度（km/h）',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '分析批次-动静态几何尺寸-轨检车单元设备映射' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_analysis_over_report_check_unit_device_map
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_analysis_rail_device_check_data_unit_device_map
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_analysis_rail_device_check_data_unit_device_map`;
CREATE TABLE `t_dsa_analysis_rail_device_check_data_unit_device_map`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `analysis_batch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次id',
  `analysis_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次code',
  `analysis_batch_unit_device_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次单元设备id',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元编码',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元类型名称',
  `unit_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元起始里程',
  `unit_center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元中心里程',
  `unit_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元终点里程',
  `check_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查主表id',
  `check_item_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查项目id',
  `check_item_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查项目开始里程',
  `check_item_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查项目结束里程',
  `check_item_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查项目文本',
  `check_detail_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查详情id',
  `check_detail_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查详情开始里程',
  `check_detail_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查详情结束里程',
  `measure_point` int NULL DEFAULT NULL COMMENT '测点',
  `track_gauge` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距',
  `level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平',
  `triangular_pit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑',
  `direction` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '方向',
  `height` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '高低',
  `structure` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '结构',
  `rectification` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '整改',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-轨检仪静态检查数据分析批次映射' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_analysis_rail_device_check_data_unit_device_map
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_analysis_tqi_report_check_unit_device_map
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_analysis_tqi_report_check_unit_device_map`;
CREATE TABLE `t_dsa_analysis_tqi_report_check_unit_device_map`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `analysis_batch_unit_device_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次单元设备id',
  `analysis_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次号',
  `analysis_batch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批id',
  `check_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查主表id',
  `check_type` int NULL DEFAULT NULL COMMENT '检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元code',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元名称',
  `unit_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元开始里程',
  `unit_center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元中心里程',
  `unit_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元结束里程',
  `tqi_report_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'tqi报告id',
  `start_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '开始里程(m)',
  `end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '终点里程(m)',
  `section_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间名称',
  `high_low_left` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '高低左',
  `high_low_right` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '高低右',
  `track_left` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨向左',
  `track_right` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨向右',
  `level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平（mm）',
  `track_gauge` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距（mm）',
  `triangular_pit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑（mm）',
  `tqi_come_upon` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'TQI数值',
  `tqi_above_standard` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'TQI超标',
  `deduct` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '扣分',
  `standard` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检测标准',
  `spend` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '速度（km/h）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-轨检车-tqi单元总结报告和单元映射关联关系' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_analysis_tqi_report_check_unit_device_map
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_config_allow_value
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_config_allow_value`;
CREATE TABLE `t_dsa_config_allow_value`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `big_track_gauge` int NULL DEFAULT NULL COMMENT '大轨距(mm)',
  `small_track_gauge` int NULL DEFAULT NULL COMMENT '小轨距(mm)',
  `level` int NULL DEFAULT NULL COMMENT '水平(mm)',
  `triangular_pit` int NULL DEFAULT NULL COMMENT '三角坑(mm)',
  `direction` int NULL DEFAULT NULL COMMENT '轨向(mm)',
  `height` int NULL DEFAULT NULL COMMENT '高低(mm)',
  `vertical_acceleration` int NULL DEFAULT NULL COMMENT '垂直加速度(g)',
  `lateral_acceleration` int NULL DEFAULT NULL COMMENT '横向加速度(g)',
  `track_gauge_change` int NULL DEFAULT NULL COMMENT '规矩变化率',
  `curvature_change` int NULL DEFAULT NULL COMMENT '曲率变化率',
  `is_work` int NULL DEFAULT 1 COMMENT '是否派工 0-否 1-是(默认值)',
  `is_enable` int NULL DEFAULT 1 COMMENT '是否启用 0-否 1-启用(默认值)',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-参数配置-容许值差' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_config_allow_value
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_config_dispatching
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_config_dispatching`;
CREATE TABLE `t_dsa_config_dispatching`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `type` int NULL DEFAULT NULL COMMENT '派工类型 1-静态检查数据 2-轨检车动态检查数据 3-添乘仪动态检查数据',
  `reason_label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '派工原因',
  `reason_value` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '派工code',
  `is_work` int NULL DEFAULT 1 COMMENT '是否派工 0-否 1-是(默认值)',
  `is_enable` int NULL DEFAULT 1 COMMENT '是否启用 0-否 1-启用(默认值)',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-参数配置-派工配置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_config_dispatching
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_config_grade_limit
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_config_grade_limit`;
CREATE TABLE `t_dsa_config_grade_limit`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `speed_min` int NULL DEFAULT NULL COMMENT '速度下限',
  `speed_max` int NULL DEFAULT NULL COMMENT '速度上限',
  `dict_value` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据字典值',
  `dict_label` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据字典标签',
  `grade_level` int NULL DEFAULT NULL COMMENT '评价等级 1-优良 2-合格 3-失格',
  `grade_level_str` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '评价等级中文说明',
  `grade_min` decimal(14, 3) NULL DEFAULT NULL COMMENT '最小评分',
  `grade_max` decimal(14, 3) NULL DEFAULT NULL COMMENT '最大评分',
  `device_type` int NULL DEFAULT NULL COMMENT '设备类型 1-钢轨 2-道岔 3-曲线 4-竖曲线',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '是否删除（0：未删除； 1：已删除）',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-配置-单元化管理阈值' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_config_grade_limit
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_config_instrument_check
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_config_instrument_check`;
CREATE TABLE `t_dsa_config_instrument_check`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `dict_value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据字典值',
  `dict_label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据字典标签',
  `speed_min` int NULL DEFAULT NULL COMMENT '速度下限',
  `speed_max` int NULL DEFAULT NULL COMMENT '速度上限',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `rail` json NULL COMMENT '钢轨',
  `curve` json NULL COMMENT '曲线',
  `vertical_curve` json NULL COMMENT '竖曲线',
  `rail_switch` json NULL COMMENT '道岔',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '是否删除（0：未删除； 1：已删除）',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-配置-添乘仪检查超限权值' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_config_instrument_check
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_config_labour_check
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_config_labour_check`;
CREATE TABLE `t_dsa_config_labour_check`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `speed_min` int NULL DEFAULT NULL COMMENT '速度下限',
  `speed_max` int NULL DEFAULT NULL COMMENT '速度上限',
  `dict_value` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据字典值',
  `dict_label` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据字典标签',
  `rail` json NULL COMMENT '钢轨',
  `curve` json NULL COMMENT '曲线',
  `vertical_curve` json NULL COMMENT '竖曲线',
  `rail_switch` json NULL COMMENT '道岔',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '是否删除（0：未删除； 1：已删除）',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-配置-人工检查超限权值' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_config_labour_check
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_config_rail_device_check
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_config_rail_device_check`;
CREATE TABLE `t_dsa_config_rail_device_check`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `speed_min` int NULL DEFAULT NULL COMMENT '速度下限',
  `speed_max` int NULL DEFAULT NULL COMMENT '速度上限',
  `dict_value` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据字典值',
  `dict_label` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据字典标签',
  `rail` json NULL COMMENT '钢轨',
  `curve` json NULL COMMENT '曲线',
  `vertical_curve` json NULL COMMENT '竖曲线',
  `rail_switch` json NULL COMMENT '道岔',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '是否删除（0：未删除； 1：已删除）',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-配置-轨检仪检查超限权值' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_config_rail_device_check
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_config_rail_vehicle_check
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_config_rail_vehicle_check`;
CREATE TABLE `t_dsa_config_rail_vehicle_check`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `speed_min` int NULL DEFAULT NULL COMMENT '速度下限',
  `speed_max` int NULL DEFAULT NULL COMMENT '速度上限',
  `dict_value` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据字典值',
  `dict_label` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据字典标签',
  `rail` json NULL COMMENT '钢轨',
  `curve` json NULL COMMENT '曲线',
  `vertical_curve` json NULL COMMENT '竖曲线',
  `rail_switch` json NULL COMMENT '道岔',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '是否删除（0：未删除； 1：已删除）',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-配置-轨检车检查超限权值' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_config_rail_vehicle_check
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_config_rail_vehicle_tqi
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_config_rail_vehicle_tqi`;
CREATE TABLE `t_dsa_config_rail_vehicle_tqi`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `speed_expression` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '速度等级',
  `speed_min` int NULL DEFAULT NULL COMMENT '速度下限',
  `speed_max` int NULL DEFAULT NULL COMMENT '速度上限',
  `dict_value` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据字典值',
  `dict_label` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据字典标签',
  `rail` json NULL COMMENT '钢轨',
  `curve` json NULL COMMENT '曲线',
  `vertical_curve` json NULL COMMENT '竖曲线',
  `rail_switch` json NULL COMMENT '道岔',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '是否删除（0：未删除； 1：已删除）',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-配置-轨检车TQI超限权值' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_config_rail_vehicle_tqi
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsa_config_tqi_limit
-- ----------------------------
DROP TABLE IF EXISTS `t_dsa_config_tqi_limit`;
CREATE TABLE `t_dsa_config_tqi_limit`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `speed_min` int NULL DEFAULT NULL COMMENT '速度下限',
  `speed_max` int NULL DEFAULT NULL COMMENT '速度上限',
  `dict_label` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据字典标签',
  `dict_value` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据字典值',
  `over_standard_type` int NULL DEFAULT NULL COMMENT '超标类型 1-超标≤10% 2-超标≤20% 3-超标>20%',
  `over_standard_type_str` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '评价等级中文说明',
  `tqi_min` decimal(14, 3) NULL DEFAULT NULL COMMENT 'tqi下限',
  `tqi_max` decimal(14, 3) NULL DEFAULT NULL COMMENT 'tqi上限',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '是否删除（0：未删除； 1：已删除）',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态分析-配置-TQI管理标准顺质量指数' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsa_config_tqi_limit
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsg_rail_inspection_equipment_item
-- ----------------------------
DROP TABLE IF EXISTS `t_dsg_rail_inspection_equipment_item`;
CREATE TABLE `t_dsg_rail_inspection_equipment_item`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `rail_inspection_equipment_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨检仪静态检查数据id',
  `course_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查起始里程（m）',
  `course_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '检查终点里程(m)',
  `curve_radius` decimal(14, 3) NULL DEFAULT NULL COMMENT '曲线半径（m）',
  `super_high` decimal(14, 3) NULL DEFAULT NULL COMMENT '超高（mm）',
  `widen` decimal(14, 3) NULL DEFAULT NULL COMMENT '加宽（mm）',
  `slope_ratio` decimal(14, 3) NULL DEFAULT NULL COMMENT '顺坡率（‰）',
  `long_extent` decimal(14, 3) NULL DEFAULT NULL COMMENT '长度（m）',
  `remark` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '备注',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除；1：已删除）',
  `sort` int NULL DEFAULT NULL COMMENT '导入排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '检查数据-动静态几何尺寸数据-轨检仪静态检查数据-检查项目' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsg_rail_inspection_equipment_item
-- ----------------------------

-- ----------------------------
-- Table structure for t_dsg_rail_inspection_equipment_item_detail
-- ----------------------------
DROP TABLE IF EXISTS `t_dsg_rail_inspection_equipment_item_detail`;
CREATE TABLE `t_dsg_rail_inspection_equipment_item_detail`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `rail_inspection_equipment_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨检仪静态检查数据id',
  `rail_inspection_equipment_item_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨检仪静态检查数据检查项id',
  `check_item` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查项目',
  `measure_point` int NULL DEFAULT NULL COMMENT '测点',
  `track_gauge` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距',
  `level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平',
  `triangular_pit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑',
  `other` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '其他',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除；1：已删除）',
  `info_sort` int NULL DEFAULT NULL COMMENT '排序字段',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '检查数据-动静态几何尺寸数据-轨检仪静态检查数据-检查项目-明细表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_dsg_rail_inspection_equipment_item_detail
-- ----------------------------

-- ----------------------------
-- Table structure for t_ek_curve_wear_record
-- ----------------------------
DROP TABLE IF EXISTS `t_ek_curve_wear_record`;
CREATE TABLE `t_ek_curve_wear_record`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `records_master_check_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备检查记录主表id',
  `check_time` date NULL DEFAULT NULL COMMENT '检查日期',
  `curve_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '曲线编码',
  `curve_radius` decimal(14, 3) NULL DEFAULT NULL COMMENT '曲线半径',
  `curve_super_high` decimal(14, 3) NULL DEFAULT NULL COMMENT '曲线超高',
  `transition_curve_high` decimal(14, 3) NULL DEFAULT NULL COMMENT '缓和曲线长度',
  `curve_tangent_len` decimal(14, 3) NULL DEFAULT NULL COMMENT '圆曲线长',
  `curve_turn` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '圆曲转向',
  `check_by` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查人',
  `check_data` json NULL COMMENT '检查数据',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除，1：已删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '检查数据设备-设备检查记录数据-曲线磨耗情况检查' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_ek_curve_wear_record
-- ----------------------------

-- ----------------------------
-- Table structure for t_ek_rail_wear_record
-- ----------------------------
DROP TABLE IF EXISTS `t_ek_rail_wear_record`;
CREATE TABLE `t_ek_rail_wear_record`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `records_master_check_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备检查记录主表id',
  `rail_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '钢轨轨型',
  `line_alias_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别Id',
  `line_alias_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别名称',
  `left_femoral_apparatus_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '左股仪器编码',
  `left_femoral_apparatus` json NULL COMMENT '左股仪器',
  `left_track_direction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '左股轨向',
  `right_femoral_apparatus_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '右股仪器编码',
  `right_femoral_apparatus` json NULL COMMENT '右股仪器',
  `right_track_direction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '右股轨向',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '是否删除（0：未删除，1：已删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '检查数据-设备检查记录数据-钢轨伤损情况检查表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_ek_rail_wear_record
-- ----------------------------

-- ----------------------------
-- Table structure for t_ek_records_master_check
-- ----------------------------
DROP TABLE IF EXISTS `t_ek_records_master_check`;
CREATE TABLE `t_ek_records_master_check`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备检查类型（1：道岔使用情况；2：钢轨伤损情况；3：曲线磨损情况；4：钢轨波磨情况；5：道床使用情况）',
  `ek_code` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查批次编号',
  `work_code` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工单编号',
  `gauge_code` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距水平尺编号',
  `subway_section_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查区间id',
  `subway_section_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查区间名称',
  `light_rail_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线路id',
  `light_rail_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线路名称',
  `line_alias_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线别id',
  `line_alias_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线别名称',
  `starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '起始里程',
  `end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '终点里程',
  `switch_nums` int NULL DEFAULT NULL COMMENT '道岔数量',
  `num_one` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '共通字段1(根据字段type来赋值)->(线路方向)',
  `num_two` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '共通字段2(根据字段type来赋值)->（推行方向）',
  `num_three` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '共通字段3(根据字段type来赋值)->(检查时间)',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `check_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查人姓名',
  `check_time` datetime NULL DEFAULT NULL COMMENT '检查日期',
  `verify_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审核人姓名',
  `verify_time` datetime NULL DEFAULT NULL COMMENT '审核时间',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除；1：已删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '设备检查记录主表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_ek_records_master_check
-- ----------------------------

-- ----------------------------
-- Table structure for t_ek_records_master_corr_wave
-- ----------------------------
DROP TABLE IF EXISTS `t_ek_records_master_corr_wave`;
CREATE TABLE `t_ek_records_master_corr_wave`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `records_master_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备检查记录主表id',
  `type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型（1：RMS；2：AP2P；3：FIL）',
  `wave` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '波长',
  `num_one` decimal(14, 4) NULL DEFAULT NULL COMMENT '值1',
  `num_two` decimal(14, 4) NULL DEFAULT NULL COMMENT '值2',
  `num_three` decimal(14, 4) NULL DEFAULT NULL COMMENT '值3',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除，1：已删除）',
  `sort` int NULL DEFAULT NULL COMMENT '导入顺序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '设备检查记录数据-钢轨波磨情况检查数据-波长' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_ek_records_master_corr_wave
-- ----------------------------

-- ----------------------------
-- Table structure for t_ek_records_master_corr_wave_info
-- ----------------------------
DROP TABLE IF EXISTS `t_ek_records_master_corr_wave_info`;
CREATE TABLE `t_ek_records_master_corr_wave_info`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `records_master_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备检查记录主表id',
  `type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '类型（1：RMS；2：AP2P；3：FIL）',
  `code` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编号',
  `mileage` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '里程',
  `wave_num` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '波长',
  `num_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值',
  `restrict_num` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '限定值',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除，1：已删除）',
  `sort` int NULL DEFAULT NULL COMMENT '导入顺序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '设备检查记录数据-钢轨波磨情况检查数据-波长详情' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_ek_records_master_corr_wave_info
-- ----------------------------

-- ----------------------------
-- Table structure for t_ek_records_master_turnout_info
-- ----------------------------
DROP TABLE IF EXISTS `t_ek_records_master_turnout_info`;
CREATE TABLE `t_ek_records_master_turnout_info`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `records_master_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备检查记录主表id',
  `switch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '道岔编号',
  `type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查项目类型（1：轨距；2：水平；3：支距；4：轮缘槽；5：滑床板；6：顶铁；7：接头螺栓；8：护轨螺栓；9:道岔）',
  `num_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值1',
  `num_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值2',
  `num_three` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值3',
  `num_four` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值4',
  `num_five` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值5',
  `num_six` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值6',
  `num_seven` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值7',
  `num_eight` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值8',
  `num_nine` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值9',
  `num_ten` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值10',
  `num_ten_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值11',
  `num_ten_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值12',
  `num_ten_three` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值13',
  `num_ten_four` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值14',
  `num_ten_five` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值15',
  `num_ten_six` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值16',
  `num_ten_seven` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值17',
  `num_ten_eight` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值18',
  `num_ten_nine` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值19',
  `num_twenty` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值20',
  `num_twenty_one` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值21',
  `num_twenty_two` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '值22',
  `qualified` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否合格（1：合格；2：不合格）',
  `no_qualified_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '不合格说明',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除，1：已删除）',
  `sort` int NULL DEFAULT NULL COMMENT '导入道岔顺序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '检查数据设备-设备检查记录数据-道岔使用情况检查数据' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_ek_records_master_turnout_info
-- ----------------------------

-- ----------------------------
-- Table structure for t_ek_track_bed_management_check
-- ----------------------------
DROP TABLE IF EXISTS `t_ek_track_bed_management_check`;
CREATE TABLE `t_ek_track_bed_management_check`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `records_master_check_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备检查记录主表id->外键',
  `trak_bed_management_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '道床id->外键',
  `ek_project_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查项目名称',
  `ek_project_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '检查项目内容',
  `ek_project_template` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '检查合格评判标准',
  `ek_project_status_str` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '现场检查项目状态翻译',
  `ek_project_status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '现场检查项目状态（1：合格；2：良好；3：不合格）',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除，1：已删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '设备检查记录数据-道床使用情况记录数据' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_ek_track_bed_management_check
-- ----------------------------

-- ----------------------------
-- Table structure for t_ek_turnout_use_check
-- ----------------------------
DROP TABLE IF EXISTS `t_ek_turnout_use_check`;
CREATE TABLE `t_ek_turnout_use_check`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `check_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查批次号',
  `work_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工单编号',
  `gauge_level_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距水平尺编号',
  `check_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查人姓名',
  `check_time` datetime NULL DEFAULT NULL COMMENT '检查日期',
  `turnout_num` int NULL DEFAULT NULL COMMENT '道岔数量',
  `train_station_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '车站id',
  `line_alias_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别id',
  `verify_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审核人姓名',
  `verify_time` datetime NULL DEFAULT NULL COMMENT '审核时间',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '检查数据-设备检查记录数据-设备检查记录数据' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_ek_turnout_use_check
-- ----------------------------

-- ----------------------------
-- Table structure for t_mw_work_batch
-- ----------------------------
DROP TABLE IF EXISTS `t_mw_work_batch`;
CREATE TABLE `t_mw_work_batch`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `work_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '作业计划批次号',
  `light_rail_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线路id',
  `light_rail_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线路名称',
  `line_alias_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线别id',
  `line_alias_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线别名称',
  `work_start_mileage` decimal(14, 3) NULL DEFAULT 0.000 COMMENT '作业起始里程',
  `work_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '作业终点里程',
  `work_start_time` datetime NULL DEFAULT NULL COMMENT '作业起始时间',
  `work_end_time` datetime NULL DEFAULT NULL COMMENT '作业终止时间',
  `team` varchar(108) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '作业班组',
  `source` int NULL DEFAULT NULL COMMENT '来源 1-页面添加 2-超限派工添加',
  `work_status` int NULL DEFAULT NULL COMMENT '作业状态 0-未作业 9-已作业',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '是否删除 0-未删除 1-已删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '维修作业管理-作业计划批次管理表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_mw_work_batch
-- ----------------------------

-- ----------------------------
-- Table structure for t_mw_work_batch_detail
-- ----------------------------
DROP TABLE IF EXISTS `t_mw_work_batch_detail`;
CREATE TABLE `t_mw_work_batch_detail`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `work_batch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '作业计划批次id',
  `work_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '作业计划批次Code',
  `analysis_batch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次id',
  `analysis_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '分析批次code',
  `analysis_batch_unit_device_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '0' COMMENT '分析设备单元id',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元设备id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元设备code',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元类型名称',
  `unit_device_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备编号',
  `unit_start_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元起始里程',
  `unit_center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元中心里程',
  `unit_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元结束里程',
  `unit_score_level` int NULL DEFAULT NULL COMMENT '单元得分等级 1-优良 2-合格 3-失格',
  `unit_score_level_str` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元得分等级中文',
  `unit_score` decimal(14, 3) NULL DEFAULT NULL COMMENT '单元得分',
  `maintenance_date` datetime NULL DEFAULT NULL COMMENT '维修日期',
  `work_status` int NULL DEFAULT 0 COMMENT '作业状态 0-未作业 9-已作业',
  `reform_remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '整改备注',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '维修建议',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_analysis_batch_unit_device_id`(`analysis_batch_unit_device_id` ASC) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '维修作业管理-作业计划批次管理明细表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_mw_work_batch_detail
-- ----------------------------

-- ----------------------------
-- Table structure for t_mw_work_batch_detail_modify
-- ----------------------------
DROP TABLE IF EXISTS `t_mw_work_batch_detail_modify`;
CREATE TABLE `t_mw_work_batch_detail_modify`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `work_batch_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '作业计划批次id',
  `work_batch_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '作业计划批次code',
  `work_batch_detail_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '作业计划详情id',
  `unit_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元设备id',
  `unit_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '单元设备code',
  `unit_type` int NULL DEFAULT NULL COMMENT '设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔',
  `unit_type_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备单元类型名称',
  `unit_device_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '设备编号',
  `unit_start_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元起始里程',
  `unit_center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元中心里程',
  `unit_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '设备单元结束里程',
  `measure_point` int NULL DEFAULT NULL COMMENT '测点',
  `track_gauge` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轨距',
  `level` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '水平',
  `triangular_pit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '三角坑',
  `direction` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '方向',
  `height` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '高低',
  `structure` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '结构',
  `rectification` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '整改',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '动静态几何尺寸对应得里程相关信息详情表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_mw_work_batch_detail_modify
-- ----------------------------

-- ----------------------------
-- Table structure for t_sn_light_rail
-- ----------------------------
DROP TABLE IF EXISTS `t_sn_light_rail`;
CREATE TABLE `t_sn_light_rail`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET ujis COLLATE ujis_japanese_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `rail_line_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线路名称',
  `rail_line_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线路code',
  `up_line_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '上行里程',
  `down_line_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '下行里程',
  `status` int NULL DEFAULT NULL COMMENT '状态(0:禁用；1：启用)',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_german2_ci COMMENT = '线路车站-线路管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_sn_light_rail
-- ----------------------------

-- ----------------------------
-- Table structure for t_sn_line_alias
-- ----------------------------
DROP TABLE IF EXISTS `t_sn_line_alias`;
CREATE TABLE `t_sn_line_alias`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `line_alias_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别Code',
  `line_alias_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别名称',
  `type` int NULL DEFAULT 2 COMMENT '类型 1-基础线别 2-其他线别',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_german2_ci COMMENT = '线路车站-线别管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_sn_line_alias
-- ----------------------------

-- ----------------------------
-- Table structure for t_sn_section_station_map
-- ----------------------------
DROP TABLE IF EXISTS `t_sn_section_station_map`;
CREATE TABLE `t_sn_section_station_map`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `light_rail_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线路id',
  `light_rail_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线路名称',
  `section_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间id',
  `section_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间名称',
  `station_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '车站id',
  `station_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '车站名称',
  `station_line_alias_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '车站所属线别id',
  `station_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '车站开始里程',
  `station_center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '车站中心里程',
  `station_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '车站结束里程',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '线路车站-区间车站关联' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_sn_section_station_map
-- ----------------------------

-- ----------------------------
-- Table structure for t_sn_subway_section
-- ----------------------------
DROP TABLE IF EXISTS `t_sn_subway_section`;
CREATE TABLE `t_sn_subway_section`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `section_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间名',
  `section_code` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '区间code',
  `light_rail_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轻轨线路Id',
  `light_rail_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轻轨线路名称',
  `start_train_station_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '起始车站Id',
  `end_train_station_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '结束车站Id',
  `line_alias_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属线别id',
  `section_starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '区间起始起始里程',
  `section_end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '区间结束里程',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_german2_ci COMMENT = '线路车站-区间管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_sn_subway_section
-- ----------------------------

-- ----------------------------
-- Table structure for t_sn_train_station
-- ----------------------------
DROP TABLE IF EXISTS `t_sn_train_station`;
CREATE TABLE `t_sn_train_station`  (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新日期',
  `light_rail_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '轻轨线路ID',
  `seq` int NULL DEFAULT NULL COMMENT '序号',
  `station_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_german2_ci NULL DEFAULT NULL COMMENT '车站编码',
  `station_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '车站名',
  `line_alias_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别id',
  `starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '起始里程',
  `center_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '中心里程',
  `end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '结束里程',
  `length` decimal(14, 3) NULL DEFAULT NULL COMMENT '站长度(m)',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_german2_ci COMMENT = '线路车站-车站管理' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_sn_train_station
-- ----------------------------

-- ----------------------------
-- Table structure for t_xd_record_patrol__master_assist
-- ----------------------------
DROP TABLE IF EXISTS `t_xd_record_patrol__master_assist`;
CREATE TABLE `t_xd_record_patrol__master_assist`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `record_master_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线路巡查记录主表id-外键',
  `subway_section_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '巡查区间id',
  `subway_section_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '巡查区间名称',
  `line_alias_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '线别id',
  `line_alias_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线别名称',
  `starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '起始里程',
  `end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '终点里程',
  `problem_record` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '问题记录',
  `handing_log` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '处理情况',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除；1：已删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '线路巡查记录-协助情况表-巡道员使用' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_xd_record_patrol__master_assist
-- ----------------------------

-- ----------------------------
-- Table structure for t_xd_record_patrol_master
-- ----------------------------
DROP TABLE IF EXISTS `t_xd_record_patrol_master`;
CREATE TABLE `t_xd_record_patrol_master`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `ek_code` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查批次编号',
  `work_code` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '工单编号',
  `inspect_time` datetime NULL DEFAULT NULL COMMENT '检查日期',
  `weather` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '天气',
  `light_rail_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '巡查线路id',
  `light_rail_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '巡查线路名称',
  `planned_patrol_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '计划巡道里程（km）',
  `line_alias_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '巡道线别id',
  `line_alias_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '巡道线别名称',
  `starting_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '起始里程',
  `end_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '终点里程',
  `completed_mileage` decimal(14, 3) NULL DEFAULT NULL COMMENT '完成里程',
  `patrol_type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '巡道类型(1:步行巡道 2:车行巡道)',
  `patrol_hourse` decimal(14, 2) NULL DEFAULT NULL COMMENT '巡道工时',
  `check_by` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查人姓名',
  `check_time` datetime NULL DEFAULT NULL COMMENT '清点时间',
  `pinpoint_time` datetime NULL DEFAULT NULL COMMENT '销点时间',
  `verify_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '审核人姓名',
  `verify_time` datetime NULL DEFAULT NULL COMMENT '审核时间',
  `remark` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '巡道员备忘录',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除；1：已删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '线路巡查记录主表-巡道员使用' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_xd_record_patrol_master
-- ----------------------------

-- ----------------------------
-- Table structure for t_xd_record_patrol_master_info
-- ----------------------------
DROP TABLE IF EXISTS `t_xd_record_patrol_master_info`;
CREATE TABLE `t_xd_record_patrol_master_info`  (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建人',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '更新人',
  `update_time` datetime NULL DEFAULT NULL COMMENT '更新时间',
  `record_master_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '线路巡查记录主表id-外键',
  `ek_project_name` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '检查项目名称',
  `ek_project_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '重点检查项目内容',
  `problem_record` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '问题记录',
  `handing_log` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '处理情况',
  `status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否满足（1：是；2：否）',
  `seq` int NULL DEFAULT NULL COMMENT '排序',
  `del_flag` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否删除（0：未删除；1：已删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '线路巡查记录详情表-巡道员使用' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of t_xd_record_patrol_master_info
-- ----------------------------

SET FOREIGN_KEY_CHECKS = 1;
