package org.jeecg.modules.base.mapper;

import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.injector.DefaultSqlInjector;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import org.jeecg.modules.base.mapper.InsertBatchMethod;
import org.jeecg.modules.base.mapper.UpdateBatchMethod;

import java.util.List;

/**
 * @Description : 自定义方法SQL注入器
 * @Author : 黄康林
 * @Date : 2023-10-11 15:13:17
 * @Version : 1.0
 **/
public class CustomizedSqlInjector extends DefaultSqlInjector {
    /**
     * 如果只需增加方法，保留mybatis plus自带方法，
     * 可以先获取super.getMethodList()，再添加add
     */
    @Override
    public List<AbstractMethod> getMethodList(Class<?> mapperClass, TableInfo tableInfo) {
        List<AbstractMethod> methodList = super.getMethodList(mapperClass, tableInfo);
        methodList.add(new InsertBatchMethod());
        methodList.add(new UpdateBatchMethod());
        return methodList;
    }
}
