package org.jeecg.config.init;

import org.jeecg.modules.deviceAsset.service.*;
import org.jeecg.modules.diseaseAnalysis.algorithm.AnalysisAlgorithmLine;
import org.jeecg.modules.diseaseAnalysis.algorithm.SingleConsumerLine;
import org.jeecg.modules.dynamicStaticAnalysis.algorithm.AnalysisAlgorithm;
import org.jeecg.modules.dynamicStaticAnalysis.algorithm.SingleConsumer;
import org.jeecg.modules.subwayNetwork.service.ILineAliasService;
import org.jeecg.modules.utils.RedisLockUtil;
import org.jeecg.modules.utils.UnitCodeUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 初始化静态方法
 */
@Component
public class InitData implements InitializingBean {
    @Resource
    private ISwitchManagementService switchManagementService;

    @Resource
    private ICurveManagementService curveManagementService;

    @Resource
    private IVerticalCurveManagementService verticalCurveManagementService;

    @Resource
    private ILineAliasService lineAliasService;

    @Resource
    private IRailManagementService railManagementService;

    @Resource
    private ITrackBedManagementService trackBedManagementService;

    @Resource
    private ISleeperManagementService sleeperManagementService;

    @Resource
    private IFastenerManagementService fastenerManagementService;

    @Resource
    private AnalysisAlgorithm analysisAlgorithm;

    @Resource
    private AnalysisAlgorithmLine analysisAlgorithmLine;

    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public void afterPropertiesSet() throws Exception {
        UnitCodeUtil.setService(lineAliasService,
                switchManagementService,
                curveManagementService,
                verticalCurveManagementService,
                railManagementService,
                trackBedManagementService,
                sleeperManagementService,
                fastenerManagementService);

        RedisLockUtil.setService(redisTemplate);

        SingleConsumer.setService(analysisAlgorithm);

        SingleConsumerLine.setService(analysisAlgorithmLine);
    }
}
