package org.jeecg.modules.checkData.controller;


import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.*;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.config.AsyncTask;
import org.jeecg.modules.checkData.dto.MovementAdditiveInfoDTO;
import org.jeecg.modules.checkData.dto.MovementRecordsMasterDTO;
import org.jeecg.modules.checkData.entity.*;
import org.jeecg.modules.checkData.face.MovementRecordsMasterFace;
import org.jeecg.modules.checkData.service.*;
import org.jeecg.modules.checkData.vo.*;
import org.jeecg.modules.dynamicStaticAnalysis.mapper.AnalysisAlgorithmMapper;
import org.jeecg.modules.subwayNetwork.entity.LightRail;
import org.jeecg.modules.subwayNetwork.entity.LineAlias;
import org.jeecg.modules.subwayNetwork.entity.SubwaySection;
import org.jeecg.modules.subwayNetwork.service.ILightRailService;
import org.jeecg.modules.subwayNetwork.service.ILineAliasService;
import org.jeecg.modules.subwayNetwork.service.ISubwaySectionService;
import org.jeecg.modules.utils.BeanCopyUtil;
import org.jeecg.modules.utils.ExcelAnalysisUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * <p>
 * 动静态几何尺寸数据主表	 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-07-11
 */
@RestController
@RequestMapping("/movement/master")
@Api(tags = "动静态几何尺寸数据")
public class MovementRecordsMasterController extends JeecgController<MovementRecordsMaster, IMovementRecordsMasterService> {

    @Resource
    private MovementRecordsMasterFace movementRecordsMasterFace;

    @Resource
    private IMovementCourseService movementCourseService;
    @Resource
    private IMovementCourseInfoService movementCourseInfoService;
    @Resource
    private ISubwaySectionService subwaySectionService;
    @Resource
    private ILineAliasService lineAliasService;
    @Resource
    private IMovementAdditiveInfoService movementAdditiveInfoService;
    @Resource
    private ILightRailService lightRailService;
    @Resource
    private IMovementDiferenceManagerService movementDiferenceManagerService;
    @Resource
    private IMovementOverReportService movementOverReportService;
    @Resource
    private IMovementSectionReportService movementSectionReportService;
    @Resource
    private IMovementSummaryReportService movementSummaryReportService;
    @Resource
    private IMovementTqiKilometerReportService movementTqiKilometerReportService;
    @Resource
    private IMovementTqiKilometerStandardManagerService movementTqiKilometerStandardManagerService;
    @Resource
    private IMovementTqiReportService movementTqiReportService;
    @Resource
    private IMovementTqiStandardManagerService movementTqiStandardManagerService;
    @Resource
    private AnalysisAlgorithmMapper analysisAlgorithmMapper;

    @Resource
    private AsyncTask asyncTask;


    //**********************************人工静态检查******************************

    /**
     * 动静态几何尺寸数据-分页列表查询
     */
    @AutoLog(value = "动静态几何尺寸数据-分页列表查询")
    @ApiOperation(value = "动静态几何尺寸数据-分页列表查询", notes = "动静态几何尺寸数据-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<MovementRecordsMasterVO>> queryPageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo, @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize, MovementRecordsMasterDTO dto) {
        if (ObjectUtil.isEmpty(dto.getType())) {
            return Result.error("传递参数不完整");
        }
        Page<MovementRecordsMasterVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.queryPageList(pageData, dto);
        return Result.OK(pageData);
    }

    /**
     * 动静态几何新增时初始化回显数据
     *
     * @param lightRailId
     * @param lineAliasId
     * @param sectionId
     * @param type
     * @return
     */
    @AutoLog(value = "动静态几何新增时初始化回显数据")
    @ApiOperation(value = "动静态几何新增时初始化回显数据", notes = "动静态几何新增时初始化回显数据")
    @GetMapping(value = "/getMovementAdditiveQuery")
    public Result<MovementAdditiveSavaQueryVO> getMovementAdditiveQuery(@ApiParam(name = "lightRailId", required = true) String lightRailId, @ApiParam(name = "lineAliasId", required = true) String lineAliasId, @ApiParam(name = "区间id", required = false) String sectionId, @ApiParam(name = "查询类型", required = true) String type) {

        // 1.查询线路,线别,区间对象
        LightRail lightRail = lightRailService.getById(lightRailId);
        LineAlias lineAlias = lineAliasService.getById(lineAliasId);
        SubwaySection subwaySection = subwaySectionService.getById(sectionId);


        // 2.构建返回数据
        MovementAdditiveSavaQueryVO result = new MovementAdditiveSavaQueryVO();
        result.setLightRailId(lightRailId);
        result.setLineAliasId(lineAliasId);
        result.setLightRailName(lightRail.getRailLineName());
        result.setLineAliasName(lineAlias.getLineAliasName());
        if ("4".equals(type)) {
            result.setStartingMileage(BigDecimal.ZERO);
            if ("上行线".equals(lineAlias.getLineAliasName())) {
                result.setEndMileage(lightRail.getUpLineMileage());
            }
            if ("下行线".equals(lineAlias.getLineAliasName())) {
                result.setEndMileage(lightRail.getDownLineMileage());
            }
        }
        if (ObjectUtil.isNotEmpty(sectionId)) {
            result.setSubwaySectionId(sectionId);
            result.setSubwaySectionName(subwaySection.getSectionName());
            result.setStartingMileage(subwaySection.getSectionStartingMileage());
            result.setEndMileage(subwaySection.getSectionEndMileage());
        }


        // 3.按公里数正序排序所有1-钢轨,2-曲线,3-竖曲线,4-道岔
        List<Map<String, Object>> unitDeviceList = analysisAlgorithmMapper.getUnitDevice(lightRailId, lineAliasId, result.getStartingMileage(), result.getEndMileage());


        int railNum = 0;
        int curveNum = 0;
        int verticalCurveNum = 0;
        int switchNum = 0;
        for (Map<String, Object> unitDevice : unitDeviceList) {
            Integer unitDeviceType = Convert.toInt(unitDevice.get("type"));
            switch (unitDeviceType) {
                case 1:
                    railNum++;
                    break;
                case 2:
                    curveNum++;
                    break;
                case 3:
                    verticalCurveNum++;
                    break;
                case 4:
                    switchNum++;
                    break;
            }
        }


        result.setRailNum(railNum);
        result.setCurveNum(curveNum);
        result.setVerticalCurveNum(verticalCurveNum);
        result.setSwitchNum(switchNum);
        return Result.ok(result);
    }

    /**
     * 根据动静态几何尺寸数据主键查询检查里程相关信息
     *
     * @param id 动静态几何尺寸数据id
     * @return
     */
    @AutoLog(value = "根据动静态几何尺寸数据主键查询检查里程相关信息")
    @ApiOperation(value = "根据动静态几何尺寸数据主键查询检查里程相关信息", notes = "根据动静态几何尺寸数据主键查询检查里程相关信息")
    @GetMapping(value = "/getCourseList")
    public Result<List<MovementCourseVO>> getCourseList(@ApiParam(name = "动静态几何尺寸数据id") String id) {
        List<MovementCourse> listResult = movementCourseService.lambdaQuery().eq(ObjectUtil.isNotEmpty(id), MovementCourse::getMovementMasterId, id).eq(MovementCourse::getDelFlag, "0").orderByAsc(MovementCourse::getSort).list();
        List<MovementCourseVO> resultList = new ArrayList<>();
        if (listResult != null) {
            resultList = BeanCopyUtil.copyListProperties(listResult, MovementCourseVO::new);
        }
        return Result.OK(resultList);
    }

    @AutoLog(value = "根据动静态几何尺寸数据id和对应的里程相关信息id查询其详情")
    @ApiOperation(value = "根据动静态几何尺寸数据id和对应的里程相关信息id查询其详情", notes = "根据动静态几何尺寸数据id和对应的里程相关信息id查询其详情")
    @GetMapping(value = "/getInfoById")
    public Result<List<MovementCourseInfoOneVO>> getInfoById(@ApiParam(name = "动静态几何尺寸数据id") String movementMasterId, @ApiParam(name = "检查里程相关信息id") String movementCourseId) {
        List<MovementCourseInfo> listResult = movementCourseInfoService.lambdaQuery().eq(ObjectUtil.isNotEmpty(movementMasterId), MovementCourseInfo::getMovementMasterId, movementMasterId).eq(ObjectUtil.isNotEmpty(movementCourseId), MovementCourseInfo::getMovementCourseId, movementCourseId).eq(MovementCourseInfo::getDelFlag, "0").orderByAsc(MovementCourseInfo::getInfoSort).list();

        //初始化最终返回的集合
        List<MovementCourseInfoOneVO> resultList = new ArrayList<>();
        if (listResult != null && listResult.size() > 0) {
            List<String> trackCodeList = listResult.stream().map(MovementCourseInfo::getTrackCode).distinct().collect(Collectors.toList());
            for (String code : trackCodeList) {
                //初始化最终返回的对象
                MovementCourseInfoOneVO resultModel = new MovementCourseInfoOneVO();
                //初始化检查项目对应的详情记录的集合
                List<MovementCourseInfoVO> infoList = new ArrayList<>();
                //循环符合条件的数据项集合
                for (MovementCourseInfo entity : listResult) {
                    //判断项目名称一样
                  /*  if (code.equals(entity.getTrackCode())) {
                        //初始化检查项目对应的详情记录的对象
                        MovementCourseInfoVO infoVo = new MovementCourseInfoVO();
                        BeanCopyUtil.copyProperties(entity, infoVo);
                        infoList.add(infoVo);
                    }*/
                    if (code.equals(entity.getTrackCode())) {
                        //初始化检查项目对应的详情记录的对象
                        MovementCourseInfoVO infoVo = new MovementCourseInfoVO();
                        BeanCopyUtil.copyProperties(entity, infoVo);
                        infoList.add(infoVo);
                    }
                }
                resultModel.setInfoList(infoList);
                resultModel.setTrackCode(code);
                resultList.add(resultModel);
            }
        }
        return Result.OK(resultList);
    }

    @AutoLog(value = "动静态几何尺寸主数据新增或者编辑")
    @ApiOperation(value = "动静态几何尺寸主数据新增或者编辑", notes = "动静态几何尺寸主数据新增或者编辑")
    @PostMapping(value = "/saveOrUpdate")
    @ResponseBody
    public Result<String> saveOrUpdate(@RequestBody MovementRecordsMaster movementRecordsMaster) {
        boolean state = validate(movementRecordsMaster);
        if (!state) {
            return Result.error("传递参数不完整");
        }
        movementRecordsMaster.setDelFlag("0");
        if (ObjectUtil.isEmpty(movementRecordsMaster.getId())) {
            movementRecordsMaster.setId(UUIDGenerator.generate());
            this.service.save(movementRecordsMaster);
        } else {
            this.service.updateById(movementRecordsMaster);
        }
        return Result.OK("操作成功!");
    }

    /**
     * 删除动静态几何尺寸数据及相关联的数据
     *
     * @param id
     * @param type
     * @return
     */
    @AutoLog(value = "删除动静态几何尺寸数据及相关联的数据")
    @ApiOperation(value = "删除动静态几何尺寸数据及相关联的数据", notes = "删除动静态几何尺寸数据及相关联的数据")
    @GetMapping(value = "/delete")
    public Result<String> delete(@ApiParam(name = "动静态几何尺寸数据id", required = true) String id, @ApiParam(name = "动静态几何尺寸数据类型", required = true) String type) {

        this.movementRecordsMasterFace.delete(id, type);

        return Result.OK("删除成功!");
    }


    @AutoLog(value = "导入")
    @ApiOperation(value = "导入", notes = "导入 ")
    @PostMapping(value = "/upload")
    @Transactional
    public Result<String> uploadFile(MultipartFile file, @ApiParam(name = "动静态几何尺寸主键id") String id) {

        this.movementRecordsMasterFace.uploadFile(file, id);

        return Result.OK("操作成功");
    }

    @AutoLog(value = "人工静态检查数据-保存曲线半径信息")
    @ApiOperation(value = "人工静态检查数据-保存曲线半径信息", notes = "人工静态检查数据-保存曲线半径信息")
    @PostMapping(value = "/saveAdditive")
    public Result<String> saveLabourCheckItem(@RequestBody MovementCourse record) {


        movementRecordsMasterFace.saveLabourCheckItem(record);

        return Result.OK("操作成功");
    }

    @AutoLog(value = "人工静态检查数据-更新曲线半径信息")
    @ApiOperation(value = "人工静态检查数据-更新曲线半径信息", notes = "人工静态检查数据-更新曲线半径信息")
    @PostMapping(value = "/updateAdditive")
    public Result<String> updateLabourCheckItem(@RequestBody MovementCourse record) {
        movementRecordsMasterFace.updateLabourCheckItem(record);

        return Result.OK("操作成功");
    }

    @AutoLog(value = "人工静态检查数据-删除曲线半径信息")
    @ApiOperation(value = "人工静态检查数据-删除曲线半径信息", notes = "人工静态检查数据-删除曲线半径信息")
    @GetMapping(value = "/deleteAdditive")
    @ApiImplicitParams({@ApiImplicitParam(name = "movementCourseId", required = true, value = "曲线半径信息Id")})
    public Result<String> deleteAdditive(String movementCourseId) {
        //删除里程详情
        movementCourseInfoService.lambdaUpdate().eq(MovementCourseInfo::getMovementCourseId, movementCourseId).remove();

        //删除里程相关
        movementCourseService.removeById(movementCourseId);
        return Result.OK("操作成功");
    }


    @AutoLog(value = "人工静态检查数据-更新轨道信息")
    @ApiOperation(value = "人工静态检查数据-更新轨道信息", notes = "人工静态检查数据-更新轨道信息")
    @PostMapping(value = "/updateAdditiveDetail")
    public Result<String> updateAdditiveDetail(HttpServletRequest request) throws IOException {
        // 获取参数
        StringBuilder buffer = new StringBuilder();
        BufferedReader reader = request.getReader();
        String line;
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
        }
        String requestStr = buffer.toString();


        JSONObject jsonObject = JSONObject.parseObject(requestStr);
        String id = String.valueOf(jsonObject.get("id"));


        movementCourseInfoService.lambdaUpdate().set(jsonObject.containsKey("trackGauge"), MovementCourseInfo::getTrackGauge, jsonObject.get("trackGauge")).set(jsonObject.containsKey("level"), MovementCourseInfo::getLevel, jsonObject.get("level")) // 水平
                .set(jsonObject.containsKey("triangularPit"), MovementCourseInfo::getTriangularPit, jsonObject.get("triangularPit")).set(jsonObject.containsKey("direction"), MovementCourseInfo::getDirection, jsonObject.get("direction")).set(jsonObject.containsKey("height"), MovementCourseInfo::getHeight, jsonObject.get("height")).set(jsonObject.containsKey("structure"), MovementCourseInfo::getStructure, jsonObject.get("structure")).set(jsonObject.containsKey("rectification"), MovementCourseInfo::getRectification, jsonObject.get("rectification")).set(MovementCourseInfo::getUpdateTime, new Date()).eq(MovementCourseInfo::getId, id).update();


        return Result.OK("操作成功");
    }


    //**********************************添乘仪检查******************************

    /**
     * 查询添乘仪详情
     *
     * @param pageNo
     * @param pageSize
     * @param dto
     * @return
     */
    @AutoLog(value = "查询添乘仪详情")
    @ApiOperation(value = "查询添乘仪详情", notes = "查询添乘仪详情")
    @GetMapping(value = "/getMovementAdditiveInfo")
    public Result<IPage<MovementAdditiveInfoVO>> getMovementAdditiveInfo(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo, @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize, MovementAdditiveInfoDTO dto) {
        if (ObjectUtil.isEmpty(dto.getMovementMasterId())) {
            return Result.error("参数不完整");
        }
        Page<MovementAdditiveInfoVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.queryPageAdditiveInfoList(pageData, dto);
        return Result.OK(pageData);
    }

    @AutoLog(value = "添乘仪导入")
    @ApiOperation(value = "添乘仪导入", notes = "添乘仪导入")
    @PostMapping(value = "/uploadAdditive")
    @Transactional
    public Result<String> uploadAdditiveFile(MultipartFile file, @ApiParam(name = "动静态几何尺寸主键id") String id) {
        try {
            //初始化数据模板
            QueryWrapper<MovementAdditiveInfo> rm = new QueryWrapper<>();
            rm.eq("movement_master_id", id);
            movementAdditiveInfoService.remove(rm);

            //读取第一个sheet页的数据
            ExcelReader reader = ExcelUtil.getReader(file.getInputStream(), 0);
            //读取Excel中所有的数据，以行保存
            List<List<Object>> rowRecords = reader.read();
            //初始化测点里程
            String pointMileage = "";
            //初始化水平加速度
            String zontalSpeed = "";
            //初始化水平加速度等级
            String zontalSpeedLevel = "";
            //初始化垂直加速度
            String verticalSpeed = "";
            //初始化垂直加速度等级
            String verticalSpeedLevel = "";
            //初始化速度
            String speed = "";
            //初始化手动标记
            String mark = "";
            //初始化添乘仪排序
            int sort = 0;
            //初始化存储结果
            List<MovementAdditiveInfo> result = new ArrayList<>();
            for (int m = 1; m < rowRecords.size(); m++) {
                MovementAdditiveInfo movementAdditiveInfo = new MovementAdditiveInfo();
                sort++;
                for (int i = 0; i < 7; i++) {
                    //获取当前行
                    List<Object> list = rowRecords.get(m);
                    if (ObjectUtil.isNotEmpty(list.get(i))) {
                        //获取测点里程
                        if (i == 0) {
                            pointMileage = list.get(i).toString().trim();
                        }
                        //获取水平加速度
                        if (i == 1) {
                            zontalSpeed = list.get(i).toString().trim();
                        }
                        //获取水平加速度等级
                        if (i == 2) {
                            zontalSpeedLevel = list.get(i).toString().trim();
                        }
                        //垂直加速度
                        if (i == 3) {
                            verticalSpeed = list.get(i).toString().trim();
                        }
                        //垂直加速度等级
                        if (i == 4) {
                            verticalSpeedLevel = list.get(i).toString().trim();
                        }
                        //手工标记
                        if (i == 5) {
                            mark = list.get(i).toString().trim();
                        }
                        //速度
                        if (i == 6) {
                            speed = list.get(i).toString().trim();
                        }
                    }
                }
                movementAdditiveInfo.setId(IdWorker.get32UUID());
                movementAdditiveInfo.setDelFlag("0");
                movementAdditiveInfo.setMovementMasterId(id);
                movementAdditiveInfo.setInfoSort(sort);
                if (ObjectUtil.isNotEmpty(pointMileage)) {
                    movementAdditiveInfo.setPointMileage(new BigDecimal(pointMileage));
                }
                if (ObjectUtil.isNotEmpty(zontalSpeed)) {
                    movementAdditiveInfo.setZontalSpeed(new BigDecimal(zontalSpeed));
                }
                if (ObjectUtil.isNotEmpty(zontalSpeedLevel)) {
                    movementAdditiveInfo.setZontalSpeedLevel(Integer.valueOf(zontalSpeedLevel));
                }
                if (ObjectUtil.isNotEmpty(verticalSpeed)) {
                    movementAdditiveInfo.setVerticalSpeed(new BigDecimal(verticalSpeed));
                }
                if (ObjectUtil.isNotEmpty(verticalSpeedLevel)) {
                    movementAdditiveInfo.setVerticalSpeedLevel(Integer.valueOf(verticalSpeedLevel));
                }
                if (ObjectUtil.isNotEmpty(mark)) {
                    movementAdditiveInfo.setMark(mark);
                }
                if (ObjectUtil.isNotEmpty(verticalSpeed)) {
                    movementAdditiveInfo.setSpeed(new BigDecimal(speed));
                }
                result.add(movementAdditiveInfo);
            }
            if (result != null && result.size() > 0) {
                movementAdditiveInfoService.saveBatch(result);
            }
        } catch (Exception e) {
            e.getMessage();
        }
        return Result.ok("操作成功");
    }

    /*************************************轨检车相关接口******************************************
     /**
     * 轨检车详情查询
     *
     * @param id 动静态几何尺寸数据id
     * @param type 查询类型
     * @param overType 轨检车->超限查询子类型
     * @return
     */
    @AutoLog(value = "轨检车详情查询")
    @ApiOperation(value = "轨检车详情查询", notes = "轨检车详情查询")
    @GetMapping(value = "/getTrackInfo")
    public Result<Map<String, Object>> getTrackInfo(@ApiParam(name = "动静态几何尺寸数据id") String id, @ApiParam(name = "查询类型") String type, @ApiParam(name = "轨检车->超限查询子类型") String overType) {
        Map<String, Object> map = new HashMap<>();
        if ("1".equals(type)) {
            //轨检车-》轨道动态几何尺寸容许值差管理值
            List<MovementDiferenceManager> list = movementDiferenceManagerService.lambdaQuery().eq(MovementDiferenceManager::getMovementMasterId, id).eq(MovementDiferenceManager::getDelFlag, "0").orderByAsc(MovementDiferenceManager::getSort).list();
            map.put("movementDiference", list);
        } else if ("2".equals(type) && ObjectUtil.isNotEmpty(overType)) {
            //轨检车-》超限记录报告
            List<MovementOverReport> list = movementOverReportService.lambdaQuery().eq(MovementOverReport::getMovementMasterId, id).eq(MovementOverReport::getOverrunLevel, overType).eq(MovementOverReport::getDelFlag, "0").orderByAsc(MovementOverReport::getSort).list();
            map.put("movementOverReport", list);
        } else if ("3".equals(type)) {
            //轨检车-》区段总结报告
            List<MovementSectionReport> list = movementSectionReportService.lambdaQuery().eq(MovementSectionReport::getMovementMasterId, id).eq(MovementSectionReport::getDelFlag, "0").orderByAsc(MovementSectionReport::getSort).list();
            map.put("movementSectionReport", list);
        } else if ("4".equals(type)) {
            //轨检车-》公里总结报告表
            List<MovementSummaryReport> list = movementSummaryReportService.lambdaQuery().eq(MovementSummaryReport::getMovementMasterId, id).eq(MovementSummaryReport::getDelFlag, "0").orderByAsc(MovementSummaryReport::getSort).list();
            map.put("movementSummaryReport", list);
        } else if ("5".equals(type)) {
            //轨检车-》TQI公里总结报告
            List<MovementTqiKilometerReport> list = movementTqiKilometerReportService.lambdaQuery().eq(MovementTqiKilometerReport::getMovementMasterId, id).eq(MovementTqiKilometerReport::getDelFlag, "0").orderByAsc(MovementTqiKilometerReport::getSort).list();
            map.put("movementTqiKilometerReport", list);
        } else if ("6".equals(type)) {
            //轨检车-》TQI公里状态评定标准
            List<MovementTqiKilometerStandardManager> list = movementTqiKilometerStandardManagerService.lambdaQuery().eq(MovementTqiKilometerStandardManager::getMovementMasterId, id).eq(MovementTqiKilometerStandardManager::getDelFlag, "0").orderByAsc(MovementTqiKilometerStandardManager::getSort).list();
            map.put("movementTqiKilometerStandardManager", list);
        } else if ("7".equals(type)) {
            //轨检车-》TQI总结报告
            List<MovementTqiReport> list = movementTqiReportService.lambdaQuery().eq(MovementTqiReport::getMovementMasterId, id).eq(MovementTqiReport::getDelFlag, "0").orderByAsc(MovementTqiReport::getSort).list();
            map.put("movementTqiReport", list);
        } else {
            //轨检车-》200m区段轨道不平顺质量指数TQI管理标准(单位：mm)
            List<MovementTqiStandardManager> list = movementTqiStandardManagerService.lambdaQuery().eq(MovementTqiStandardManager::getMovementMasterId, id).eq(MovementTqiStandardManager::getDelFlag, "0").orderByAsc(MovementTqiStandardManager::getSort).list();
            map.put("movementTqiStandardManager", list);
        }
        return Result.OK(map);
    }

    @AutoLog(value = "轨检车导入")
    @ApiOperation(value = "轨检车导入", notes = "轨检车导入")
    @PostMapping(value = "/trackUpload")
    @Transactional
    public Result<String> trackUploadFile(MultipartFile file, @ApiParam(name = "动静态几何尺寸主键id") String id) {
        List<List<Object>> rowRecords;

        //读取Excel中的数据
        try (InputStream inputStream = file.getInputStream()) {
            rowRecords = ExcelAnalysisUtils.getListByExcel(inputStream);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

        //获取当前登录人信息
        LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        String realname = user.getRealname();
        //初始化导入顺序
        int sort = 0;
        //初始化公里总结报告集合
        List<MovementSummaryReport> movementSummaryReportList = new ArrayList<>();
        //初始化TQI公里总结报告集合
        List<MovementTqiKilometerReport> movementTqiKilometerReportList = new ArrayList<>();
        //初始化TQI总结报告表集合
        List<MovementTqiReport> movementTqiReportList = new ArrayList<>();
        //初始化区段总结报告集合
        List<MovementSectionReport> movementSectionReportList = new ArrayList<>();
        //初始化超限记录报告集合
        List<MovementOverReport> movementOverReportList = new ArrayList<>();
        //初始化轨道动态几何尺寸容许值差管理值集合
        List<MovementDiferenceManager> movementDiferenceManagertList = new ArrayList<>();
        //初始化200m区段轨道不平顺质量指数TQI管理标准(单位：mm)集合
        List<MovementTqiStandardManager> movementTqiStandardManagerList = new ArrayList<>();
        //初始化TQI公里状态评定标准集合
        List<MovementTqiKilometerStandardManager> movementTqiKilometerStandardManagerList = new ArrayList<>();

        // 模板检查list
        Map<String, Boolean> templateCheckMap = new LinkedHashMap<>();
        for (int i = 0; i < rowRecords.size(); i++) {
            List<Object> list = rowRecords.get(i);
            if (list == null || list.size() <= 0) {
                continue;
            }
            String str = list.get(0).toString().trim();
            if (str.equals("")) {
                continue;
            }

            if (str.equals("轨道动态几何尺寸容许值差管理值")) {
                //处理轨道动态几何尺寸容许值差管理值解析封装逻辑
                int dataOne = this.uploadMovementDiferenceManager(movementDiferenceManagertList, i, sort, realname, rowRecords, id);
                i = i + dataOne;
                templateCheckMap.put(str, true); // 表示存在
            } else if (str.equals("200m区段轨道不平顺质量指数TQI管理标准(单位：mm)")) {
                //处理200m区段轨道不平顺质量指数TQI管理标准(单位：mm)解析封装逻辑
                int dataOne = this.uploadMovementTqiStandardManager(movementTqiStandardManagerList, i, sort, realname, rowRecords, id);
                i = i + dataOne;
                templateCheckMap.put(str, true); // 表示存在
            } else if (str.equals("TQI公里状态评定标准")) {
                //处理TQI公里状态评定标准解析封装逻辑
                int dataOne = this.uploadMovementTqiKilometerStandardManager(movementTqiKilometerStandardManagerList, i, sort, realname, rowRecords, id);
                i = i + dataOne;
                templateCheckMap.put(str, true); // 表示存在
            } else if (str.equals("四级缺陷记录报告表") || str.equals("三级缺陷记录报告表") || str.equals("二级缺陷记录报告表") || str.equals("一级缺陷记录报告表")) {
                //处理超限记录报告解析封装逻辑
                int dataOne = this.uploadMovementOverReport(movementOverReportList, i, sort, realname, rowRecords, id);
                i = i + dataOne;
                templateCheckMap.put(str, true); // 表示存在
            } else if (str.equals("TQI总结报告表")) {
                //处理TQI总结报告表解析封装逻辑
                int dataOne = this.uploadMovementTqiReport(movementTqiReportList, i, sort, realname, rowRecords, id);
                i = i + dataOne;
                templateCheckMap.put(str, true); // 表示存在
            } else if (str.equals("TQI公里总结报告表")) {
                //处理TQI公里总结报告表解析封装逻辑
                int dataOne = this.uploadMovementTqiKilometerReport(movementTqiKilometerReportList, i, sort, realname, rowRecords, id);
                i = i + dataOne;
                templateCheckMap.put(str, true); // 表示存在
            } else if (str.equals("公里总结报告表")) {
                //处理公里总结报告表解析封装逻辑
                int dataOne = this.uploadMovementSummaryReport(movementSummaryReportList, i, sort, realname, rowRecords, id);
                i = i + dataOne;
                templateCheckMap.put(str, true); // 表示存在
            } else if (str.equals("区段总结报告表")) {
                //处理区段总结报告表解析封装逻辑
                int dataOne = this.uploadMovementSectionReport(movementSectionReportList, i, sort, realname, rowRecords, id);
                i = i + dataOne;
                templateCheckMap.put(str, true); // 表示存在
            } else {
                if (i != rowRecords.size() - 1) {
                    continue;
                }
            }
        }

        List<String> templateCheckList = Arrays.asList("轨道动态几何尺寸容许值差管理值", "TQI公里状态评定标准", "200m区段轨道不平顺质量指数TQI管理标准(单位：mm)", "TQI总结报告表", "TQI公里总结报告表", "公里总结报告表", "区段总结报告表");
        for (String item : templateCheckList) {
            if (!templateCheckMap.containsKey(item)) {
                throw JeecgBootException.error("请导入正确的模板");
            }
        }


        //初始化数据模板
        boolean state = this.initData(id);
        if (!state) {
            return Result.error("初始化数据失败");
        }
        //维护公里总结报告表
        if (movementSummaryReportList != null && movementSummaryReportList.size() > 0) {
            asyncTask.getAsyncExecutor().execute(() -> {
                movementSummaryReportService.saveBatch(movementSummaryReportList);
            });
        }
        //维护TQI公里总结报告表
        if (movementTqiKilometerReportList != null && movementTqiKilometerReportList.size() > 0) {
            asyncTask.getAsyncExecutor().execute(() -> {
                movementTqiKilometerReportService.saveBatch(movementTqiKilometerReportList);
            });
        }
        //维护TQI总结报告表
        if (movementTqiReportList != null && movementTqiReportList.size() > 0) {
            asyncTask.getAsyncExecutor().execute(() -> {
                movementTqiReportService.saveBatch(movementTqiReportList);
            });
        }
        //维护超限记录报告
        if (movementOverReportList != null && movementOverReportList.size() > 0) {
            asyncTask.getAsyncExecutor().execute(() -> {
                movementOverReportService.saveBatch(movementOverReportList);
            });
        }
        //维护区段总结报告
        if (movementSectionReportList != null && movementSectionReportList.size() > 0) {
            asyncTask.getAsyncExecutor().execute(() -> {
                movementSectionReportService.saveBatch(movementSectionReportList);
            });
        }
        //维护轨道动态几何尺寸容许值差管理值
        if (movementDiferenceManagertList != null && movementDiferenceManagertList.size() > 0) {
            asyncTask.getAsyncExecutor().execute(() -> {
                movementDiferenceManagerService.saveBatch(movementDiferenceManagertList);
            });
        }
        //维护200m区段轨道不平顺质量指数TQI管理标准(单位：mm)
        if (movementTqiStandardManagerList != null && movementTqiStandardManagerList.size() > 0) {
            asyncTask.getAsyncExecutor().execute(() -> {
                movementTqiStandardManagerService.saveBatch(movementTqiStandardManagerList);
            });
        }
        //维护TQI公里状态评定标准
        if (movementTqiKilometerStandardManagerList != null && movementTqiKilometerStandardManagerList.size() > 0) {
            asyncTask.getAsyncExecutor().execute(() -> {
                movementTqiKilometerStandardManagerService.saveBatch(movementTqiKilometerStandardManagerList);
            });
        }

        try {
            Thread.sleep(2000); //等待2000毫秒，即2秒
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        return Result.ok("操作成功");
    }

    //************************************公共方法封装******************************************************

    /**
     * @param movementTqiStandardManagerList 最终的TQI公里状态评定标准集合
     * @param i                              当前行坐标
     * @param sort                           顺序
     * @param realname                       当前登录人姓名
     * @param rowRecords                     总行列数据集合
     * @param id                             主表id
     */
    public int uploadMovementTqiKilometerStandardManager(List<MovementTqiKilometerStandardManager> movementTqiStandardManagerList, int i, int sort, String realname, List<List<Object>> rowRecords, String id) {
        String regEx = "[^0-9 .]";
        Pattern p = Pattern.compile(regEx);
        int dataOne = 0;
        for (int j = i + 2; j < rowRecords.size(); j++) {
            List<Object> list1 = rowRecords.get(j);
            if (list1 == null || list1.size() <= 0) {
                return dataOne;
            }
            String str = list1.get(0).toString().trim();
            if (str.equals("")) {
                return dataOne;
            }
            dataOne++;
            sort++;
            //初始化TQI公里状态评定标准
            MovementTqiKilometerStandardManager model = new MovementTqiKilometerStandardManager();
            model.setId(IdWorker.get32UUID());
            model.setDelFlag("0");
            model.setMovementMasterId(id);
            model.setCreateTime(new Date());
            model.setUpdateTime(new Date());
            model.setCreateBy(realname);
            model.setUpdateBy(realname);
            model.setSort(sort);
            //评价定义
            String evaluate = "";
            evaluate = rowRecords.get(j).get(0).toString().trim();
            if (ObjectUtil.isNotEmpty(evaluate)) {
                model.setEvaluate(evaluate);
            }

            //均衡
            String balanced = "";
            String str1 = rowRecords.get(j).get(23).toString().trim();
            if (ObjectUtil.isNotEmpty(str1)) {
                Matcher m = p.matcher(str1);
                balanced = m.replaceAll("").trim();
                model.setBalanced(balanced);
            }

            //计划最小值
            String minPlan = "";
            //计划最大值
            String maxPlan = "";
            String plan = rowRecords.get(j).get(60).toString().trim();
            if (ObjectUtil.isNotEmpty(plan)) {
                String[] vs = plan.split("T");
                String start = vs[0];
                Matcher m = p.matcher(start);
                minPlan = m.replaceAll("").trim();
                model.setMinPlan(minPlan);
                String end = vs[1];
                Matcher m1 = p.matcher(end);
                maxPlan = m1.replaceAll("").trim();
                model.setMaxPlan(maxPlan);

            }
            //优先值
            String first = "";
            String data = rowRecords.get(j).get(96).toString().trim();
            if (ObjectUtil.isNotEmpty(data)) {
                Matcher m = p.matcher(data);
                first = m.replaceAll("").trim();
                model.setFirst(first);
            }
            movementTqiStandardManagerList.add(model);
        }
        return dataOne;
    }

    /**
     * @param movementTqiStandardManagerList 最终的200m区段轨道不平顺质量指数TQI管理标准(单位：mm)集合
     * @param i                              当前行坐标
     * @param sort                           顺序
     * @param realname                       当前登录人姓名
     * @param rowRecords                     总行列数据集合
     * @param id                             主表id
     */
    public int uploadMovementTqiStandardManager(List<MovementTqiStandardManager> movementTqiStandardManagerList, int i, int sort, String realname, List<List<Object>> rowRecords, String id) {
        String regEx = "[^0-9 .]";
        Pattern p = Pattern.compile(regEx);
        int dataOne = 0;
        for (int j = i + 3; j < rowRecords.size(); j++) {
            List<Object> list1 = rowRecords.get(j);
            if (list1 == null || list1.size() <= 0) {
                return dataOne;
            }
            String str = list1.get(0).toString().trim();
            if (str.equals("")) {
                return dataOne;
            }
            dataOne++;
            sort++;
            //初始化区段总结报告表
            MovementTqiStandardManager model = new MovementTqiStandardManager();
            model.setId(IdWorker.get32UUID());
            model.setDelFlag("0");
            model.setMovementMasterId(id);
            model.setCreateTime(new Date());
            model.setUpdateTime(new Date());
            model.setCreateBy(realname);
            model.setUpdateBy(realname);
            model.setSort(sort);
            //最小速度等级
            String minSpendLevel = "";
            //最大速度等级
            String maxSpendLevel = "";
            String spendLevel = rowRecords.get(j).get(0).toString().trim();
            if (ObjectUtil.isNotEmpty(spendLevel)) {
                String[] vs = spendLevel.split("V");
                String start = vs[0];
                Matcher m = p.matcher(start);
                minSpendLevel = m.replaceAll("").trim();
                model.setMinSpendLevel(minSpendLevel);
                String end = vs[1];
                Matcher m1 = p.matcher(end);
                maxSpendLevel = m1.replaceAll("").trim();
                model.setMaxSpendLevel(maxSpendLevel);
            }

            //高低（mm）
            String height = "";
            height = rowRecords.get(j).get(9).toString().trim();
            if (ObjectUtil.isNotEmpty(height)) {
                model.setHeight(height);
            }
            //轨向（mm）
            String trackAlignment = "";
            trackAlignment = rowRecords.get(j).get(19).toString().trim();
            if (ObjectUtil.isNotEmpty(trackAlignment)) {
                model.setTrackAlignment(trackAlignment);
            }
            //轨距（mm）
            String trackGauge = "";
            trackGauge = rowRecords.get(j).get(27).toString().trim();
            if (ObjectUtil.isNotEmpty(trackGauge)) {
                model.setTrackGauge(trackGauge);
            }
            //水平（mm）
            String level = "";
            level = rowRecords.get(j).get(36).toString().trim();
            if (ObjectUtil.isNotEmpty(level)) {
                model.setLevel(level);
            }
            //三角坑（mm）
            String triangularPit = "";
            triangularPit = rowRecords.get(j).get(46).toString().trim();
            if (ObjectUtil.isNotEmpty(triangularPit)) {
                model.setTriangularPit(triangularPit);
            }
            //TQI
            String tqiValue = "";
            tqiValue = rowRecords.get(j).get(58).toString().trim();
            if (ObjectUtil.isNotEmpty(tqiValue)) {
                model.setTqiValue(tqiValue);
            }
            //超标<=10%->TQI最小值
            String minTqiExceedTen = "";
            //超标<=10%->TQI最大值
            String maxTqiExceedTen = "";
            String tqiExceedTen = rowRecords.get(j).get(70).toString().trim();
            if (ObjectUtil.isNotEmpty(tqiExceedTen)) {
                String[] vs = tqiExceedTen.split("T");
                String start = vs[0];
                Matcher m = p.matcher(start);
                minTqiExceedTen = m.replaceAll("").trim();
                model.setMinTqiExceedTen(minTqiExceedTen);
                String end = vs[1];
                Matcher m1 = p.matcher(end);
                maxTqiExceedTen = m1.replaceAll("").trim();
                model.setMaxTqiExceedTen(maxTqiExceedTen);

            }
            //超标<=10%->扣分
            String tqiExceedTenDeduct = "";
            tqiExceedTenDeduct = rowRecords.get(j).get(84).toString().trim();
            if (ObjectUtil.isNotEmpty(tqiExceedTenDeduct)) {
                model.setTqiExceedTenDeduct(tqiExceedTenDeduct);
            }
            //超标<=20%->TQI最小值
            String minTqiExceedTwenty = "";
            //超标<=20%->TQI最大值
            String maxTqiExceedTwenty = "";
            String tqiExceedTwenty = rowRecords.get(j).get(92).toString().trim();
            if (ObjectUtil.isNotEmpty(tqiExceedTwenty)) {
                String[] vs = tqiExceedTwenty.split("T");
                String start = vs[0];
                Matcher m = p.matcher(start);
                minTqiExceedTwenty = m.replaceAll("").trim();
                model.setMinTqiExceedTwenty(minTqiExceedTwenty);
                String end = vs[1];
                Matcher m1 = p.matcher(end);
                maxTqiExceedTwenty = m1.replaceAll("").trim();
                model.setMaxTqiExceedTwenty(maxTqiExceedTwenty);
            }

            //超标<=20%->扣分
            String tqiExceedTwentyDeduct = "";
            tqiExceedTwentyDeduct = rowRecords.get(j).get(107).toString().trim();
            if (ObjectUtil.isNotEmpty(tqiExceedTwentyDeduct)) {
                model.setTqiExceedTwentyDeduct(tqiExceedTwentyDeduct);
            }
            //超标>20%->TQI最小值
            String minTqiExceedPassTwenty = "";
            String tqiExceedPassTwenty = rowRecords.get(j).get(113).toString().trim();
            if (ObjectUtil.isNotEmpty(tqiExceedPassTwenty)) {
                String[] vs = tqiExceedPassTwenty.split("T");
                String start = vs[0];
                Matcher m = p.matcher(start);
                minTqiExceedPassTwenty = m.replaceAll("").trim();
                model.setMinTqiExceedPassTwenty(minTqiExceedPassTwenty);

            }
            //超标>20%->TQI扣分
            String tqiExceedPassTwentyDeduct = "";
            tqiExceedPassTwentyDeduct = rowRecords.get(j).get(126).toString().trim();
            if (ObjectUtil.isNotEmpty(tqiExceedPassTwentyDeduct)) {
                model.setTqiExceedPassTwentyDeduct(tqiExceedPassTwentyDeduct);
            }
            movementTqiStandardManagerList.add(model);
        }
        return dataOne;
    }

    /**
     * @param movementDiferenceManagerList 最终的轨道动态几何尺寸容许值差管理值集合
     * @param i                            当前行坐标
     * @param sort                         顺序
     * @param realname                     当前登录人姓名
     * @param rowRecords                   总行列数据集合
     * @param id                           主表id
     */
    public int uploadMovementDiferenceManager(List<MovementDiferenceManager> movementDiferenceManagerList, int i, int sort, String realname, List<List<Object>> rowRecords, String id) {
        String regEx = "[^0-9]";
        Pattern p = Pattern.compile(regEx);
        int dataOne = 0;
        for (int j = i + 2; j < rowRecords.size(); j++) {
            List<Object> list1 = rowRecords.get(j);
            if (list1 == null || list1.size() <= 0) {
                return dataOne;
            }
            String str = list1.get(0).toString().trim();
            if (str.equals("")) {
                return dataOne;
            }
            dataOne++;
            sort++;
            //初始化区段总结报告表
            MovementDiferenceManager model = new MovementDiferenceManager();
            model.setId(IdWorker.get32UUID());
            model.setDelFlag("0");
            model.setMovementMasterId(id);
            model.setCreateTime(new Date());
            model.setUpdateTime(new Date());
            model.setCreateBy(realname);
            model.setUpdateBy(realname);
            model.setSort(sort);
            //最小速度等级
            String minSpendLevel = "";
            //最大速度等级
            String maxSpendLevel = "";
            String spendLevel = rowRecords.get(j).get(0).toString().trim();
            if (ObjectUtil.isNotEmpty(spendLevel)) {
                String[] vs = spendLevel.split("V");
                String start = vs[0];
                Matcher m = p.matcher(start);
                minSpendLevel = m.replaceAll("").trim();
                model.setMinSpendLevel(minSpendLevel);
                String end = vs[1];
                Matcher m1 = p.matcher(end);
                maxSpendLevel = m1.replaceAll("").trim();
                model.setMaxSpendLevel(maxSpendLevel);
            }
            //超限等级
            String exceedLevel = "";
            exceedLevel = rowRecords.get(j).get(7).toString().trim();
            if (ObjectUtil.isNotEmpty(exceedLevel)) {
                model.setExceedLevel(exceedLevel);
            }
            //高低（mm）
            String height = "";
            height = rowRecords.get(j).get(18).toString().trim();
            if (ObjectUtil.isNotEmpty(height)) {
                model.setHeight(height);
            }
            //轨向（mm）
            String trackAlignment = "";
            trackAlignment = rowRecords.get(j).get(27).toString().trim();
            if (ObjectUtil.isNotEmpty(trackAlignment)) {
                model.setTrackAlignment(trackAlignment);
            }
            //大轨距（mm）
            String maxTrackGauge = "";
            maxTrackGauge = rowRecords.get(j).get(36).toString().trim();
            if (ObjectUtil.isNotEmpty(maxTrackGauge)) {
                model.setMaxTrackGauge(maxTrackGauge);
            }
            //小轨距（mm）
            String minTrackGauge = "";
            minTrackGauge = rowRecords.get(j).get(47).toString().trim();
            if (ObjectUtil.isNotEmpty(minTrackGauge)) {
                model.setMinTrackGauge(minTrackGauge);
            }
            //水平（mm）
            String level = "";
            level = rowRecords.get(j).get(59).toString().trim();
            if (ObjectUtil.isNotEmpty(level)) {
                model.setLevel(level);
            }
            //三角坑（mm）
            String triangularPit = "";
            triangularPit = rowRecords.get(j).get(69).toString().trim();
            if (ObjectUtil.isNotEmpty(triangularPit)) {
                model.setTriangularPit(triangularPit);
            }
            //垂直加速度（g）
            String verticalSpend = "";
            verticalSpend = rowRecords.get(j).get(79).toString().trim();
            if (ObjectUtil.isNotEmpty(verticalSpend)) {
                model.setVerticalSpend(verticalSpend);
            }
            //横向加速度（g）
            String transverseSpend = "";
            transverseSpend = rowRecords.get(j).get(89).toString().trim();
            if (ObjectUtil.isNotEmpty(transverseSpend)) {
                model.setTransverseSpend(transverseSpend);
            }
            //轨距变化率
            String gaugeChange = "";
            gaugeChange = rowRecords.get(j).get(98).toString().trim();
            if (ObjectUtil.isNotEmpty(gaugeChange)) {
                model.setGaugeChange(gaugeChange);
            } else {
                model.setGaugeChange("");
            }
            //曲率变化率
            String curvatureChange = "";
            curvatureChange = rowRecords.get(j).get(111).toString().trim();
            if (ObjectUtil.isNotEmpty(curvatureChange)) {
                model.setCurvatureChange(curvatureChange);
            } else {
                model.setCurvatureChange("");
            }
            //扣分标准
            String deductStandard = "";
            deductStandard = rowRecords.get(j).get(122).toString().trim();
            if (ObjectUtil.isNotEmpty(deductStandard)) {
                model.setDeductStandard(deductStandard);
            } else {
                model.setDeductStandard("");
            }
            movementDiferenceManagerList.add(model);
        }
        return dataOne;
    }

    /**
     * @param movementSectionReportList 最终的区段总结报告集合
     * @param i                         当前行坐标
     * @param sort                      顺序
     * @param realname                  当前登录人姓名
     * @param rowRecords                总行列数据集合
     * @param id                        主表id
     */
    public int uploadMovementSectionReport(List<MovementSectionReport> movementSectionReportList, int i, int sort, String realname, List<List<Object>> rowRecords, String id) {
        int dataOne = 0;
        for (int j = i + 5; j < rowRecords.size(); j++) {
            List<Object> list1 = rowRecords.get(j);
            if (list1 == null || list1.size() <= 0) {
                return dataOne;
            }
            String str = list1.get(0).toString().trim();
            if (str.equals("")) {
                return dataOne;
            }
            dataOne++;
            sort++;
            //初始化区段总结报告表
            MovementSectionReport model = new MovementSectionReport();
            model.setId(IdWorker.get32UUID());
            model.setDelFlag("0");
            model.setMovementMasterId(id);
            model.setCreateTime(new Date());
            model.setUpdateTime(new Date());
            model.setCreateBy(realname);
            model.setUpdateBy(realname);
            model.setSort(sort);
            //项目名称
            String projectName = "";
            projectName = rowRecords.get(j).get(0).toString().trim();
            if (ObjectUtil.isNotEmpty(projectName)) {
                model.setProjectName(projectName);
            }
            //个数->一级
            String numberOne = "";
            numberOne = rowRecords.get(j).get(5).toString().trim();
            if (ObjectUtil.isNotEmpty(numberOne)) {
                model.setNumberOne(numberOne);
            }
            //个数->二级
            String numberTwo = "";
            numberTwo = rowRecords.get(j).get(13).toString().trim();
            if (ObjectUtil.isNotEmpty(numberTwo)) {
                model.setNumberTwo(numberTwo);
            }
            //个数->三级
            String numberThree = "";
            numberThree = rowRecords.get(j).get(21).toString().trim();
            if (ObjectUtil.isNotEmpty(numberThree)) {
                model.setNumberThree(numberThree);
            }
            //个数->四级
            String numberFour = "";
            numberFour = rowRecords.get(j).get(28).toString().trim();
            if (ObjectUtil.isNotEmpty(numberFour)) {
                model.setNumberFour(numberFour);
            }
            //个数->总数
            String numberSum = "";
            numberSum = rowRecords.get(j).get(35).toString().trim();
            if (ObjectUtil.isNotEmpty(numberSum)) {
                model.setNumberSum(numberSum);
            }
            //个数->个数/公里
            String numberAve = "";
            numberAve = rowRecords.get(j).get(45).toString().trim();
            if (ObjectUtil.isNotEmpty(numberAve)) {
                model.setNumberAve(numberAve);
            }
            //个数->百分比
            String numberPer = "";
            String data = rowRecords.get(j).get(57).toString().trim();
            if (ObjectUtil.isNotEmpty(data)) {
                numberPer = data.replace("%", "").trim();
                model.setNumberPer(numberPer);
            }
            //扣分->扣分总计
            String deductSum = "";
            deductSum = rowRecords.get(j).get(71).toString().trim();
            if (ObjectUtil.isNotEmpty(deductSum)) {
                model.setDeductSum(deductSum);
            }
            //扣分->扣分/公里
            String deductAve = "";
            deductAve = rowRecords.get(j).get(81).toString().trim();
            if (ObjectUtil.isNotEmpty(deductAve)) {
                model.setDeductAve(deductAve);
            }
            //扣分->扣分百分比
            String deductPer = "";
            String data1 = rowRecords.get(j).get(90).toString().trim();
            if (ObjectUtil.isNotEmpty(data1)) {
                deductPer = data1.replace("%", "").trim();
                model.setDeductPer(deductPer);
            }
            //TQI->平均指数
            String tqiAve = "";
            tqiAve = rowRecords.get(j).get(100).toString().trim();
            if (ObjectUtil.isNotEmpty(tqiAve)) {
                model.setTqiAve(tqiAve);
            }
            //TQI->超标段数
            String tqiExceedNum = "";
            tqiExceedNum = rowRecords.get(j).get(110).toString().trim();
            if (ObjectUtil.isNotEmpty(tqiExceedNum)) {
                model.setTqiExceedNum(tqiExceedNum);
            }
            //TQI->超标百分比
            String tqiExceedPer = "";
            String data2 = rowRecords.get(j).get(122).toString().trim();
            if (ObjectUtil.isNotEmpty(data2)) {
                tqiExceedPer = data2.replace("%", "").trim();
                model.setTqiExceedPer(tqiExceedPer);
            }
            movementSectionReportList.add(model);
        }
        return dataOne;
    }

    /**
     * @param movementOverReportList 最终的超限总结报告集合
     * @param i                      当前行坐标
     * @param sort                   顺序
     * @param realname               当前登录人姓名
     * @param rowRecords             总行列数据集合
     * @param id                     主表id
     */
    public int uploadMovementOverReport(List<MovementOverReport> movementOverReportList, int i, int sort, String realname, List<List<Object>> rowRecords, String id) {
        String regEx = "[^0-9]";
        Pattern p = Pattern.compile(regEx);
        int dataOne = 0;
        for (int j = i + 4; j < rowRecords.size(); j++) {
            List<Object> list1 = rowRecords.get(j);
            if (list1 == null || list1.size() <= 0) {
                return dataOne;
            }
            String str = list1.get(0).toString().trim();
            if (str.equals("")) {
                return dataOne;
            }
            dataOne++;
            sort++;
            //初始化公里总结报告表
            MovementOverReport model = new MovementOverReport();
            model.setId(IdWorker.get32UUID());
            model.setDelFlag("0");
            model.setMovementMasterId(id);
            model.setCreateTime(new Date());
            model.setUpdateTime(new Date());
            model.setCreateBy(realname);
            model.setUpdateBy(realname);
            model.setSort(sort);
            //序号
            String code = "";
            code = rowRecords.get(j).get(0).toString().trim();
            if (ObjectUtil.isNotEmpty(code)) {
                model.setXuhao(code);
            }
            //里程(m)
            String mileage = "";
            String data = rowRecords.get(j).get(4).toString().trim();
            if (ObjectUtil.isNotEmpty(data)) {
                Matcher m = p.matcher(data);
                mileage = m.replaceAll("").trim();
                model.setMileage(new BigDecimal(mileage));
            }
            //区间名称
            String sectionName = "";
            sectionName = rowRecords.get(j).get(14).toString().trim();
            if (ObjectUtil.isNotEmpty(sectionName)) {
                model.setSectionName(sectionName);
            }
            //超限类型
            String overrunType = "";
            overrunType = rowRecords.get(j).get(32).toString().trim();
            if (ObjectUtil.isNotEmpty(overrunType)) {
                model.setOverrunType(overrunType);
            }
            //超限等级
            String overrunLevel = "";
            overrunLevel = rowRecords.get(j).get(42).toString().trim();
            if (ObjectUtil.isNotEmpty(overrunLevel)) {
                model.setOverrunLevel(overrunLevel);
            }
            //长度
            String longitude = "";
            longitude = rowRecords.get(j).get(53).toString().trim();
            if (ObjectUtil.isNotEmpty(longitude)) {
                model.setLongitude(longitude);
            }
            //峰值（mm或g）
            String peakValue = "";
            peakValue = rowRecords.get(j).get(66).toString().trim();
            if (ObjectUtil.isNotEmpty(peakValue)) {
                model.setPeakValue(peakValue);
            }
            //管理数据差
            String dataDifference = "";
            dataDifference = rowRecords.get(j).get(77).toString().trim();
            if (ObjectUtil.isNotEmpty(dataDifference)) {
                model.setDataDifference(dataDifference);
            }
            //线性
            String xianxing = "";
            xianxing = rowRecords.get(j).get(86).toString().trim();
            if (ObjectUtil.isNotEmpty(xianxing)) {
                model.setXianxing(xianxing);
            }
            //检测标准
            String standard = "";
            standard = rowRecords.get(j).get(98).toString().trim();
            if (ObjectUtil.isNotEmpty(standard)) {
                model.setStandard(standard);
            }
            //速度（km/h）
            String spend = "";
            spend = rowRecords.get(j).get(109).toString().trim();
            if (ObjectUtil.isNotEmpty(spend)) {
                model.setSpend(spend);
            }
            //备注
            String remark = "";
            remark = rowRecords.get(j).get(124).toString().trim();
            if (ObjectUtil.isNotEmpty(remark)) {
                model.setRemark(remark);
            }
            movementOverReportList.add(model);
        }
        return dataOne;
    }

    /**
     * @param movementTqiReportList 最终的TQI总结报告集合
     * @param i                     当前行坐标
     * @param sort                  顺序
     * @param realname              当前登录人姓名
     * @param rowRecords            总行列数据集合
     * @param id                    主表id
     */
    public int uploadMovementTqiReport(List<MovementTqiReport> movementTqiReportList, int i, int sort, String realname, List<List<Object>> rowRecords, String id) {
        String regEx = "[^0-9]";
        Pattern p = Pattern.compile(regEx);
        int dataOne = 0;
        for (int j = i + 5; j < rowRecords.size(); j++) {
            List<Object> list1 = rowRecords.get(j);
            if (list1 == null || list1.size() <= 0) {
                return dataOne;
            }
            String str = list1.get(0).toString().trim();
            if (str.equals("")) {
                return dataOne;
            }
            dataOne++;
            sort++;
            //初始化公里总结报告表
            MovementTqiReport model = new MovementTqiReport();
            model.setId(IdWorker.get32UUID());
            model.setDelFlag("0");
            model.setMovementMasterId(id);
            model.setCreateTime(new Date());
            model.setUpdateTime(new Date());
            model.setCreateBy(realname);
            model.setUpdateBy(realname);
            model.setSort(sort);
            //开始里程(m)
            String startMileage = "";
            //终点里程(m)
            String endMileage = "";
            String mileage = rowRecords.get(j).get(0).toString().trim();
            if (ObjectUtil.isNotEmpty(mileage)) {
                //使用符号进行分割
                String[] s1 = mileage.split("->");
                String start = s1[0];
                Matcher m = p.matcher(start);
                startMileage = m.replaceAll("").trim();
                model.setStartMileage(new BigDecimal(startMileage));
                String end = s1[1];
                Matcher m1 = p.matcher(end);
                endMileage = m1.replaceAll("").trim();
                model.setEndMileage(new BigDecimal(endMileage));
            }
            //区间名称
            String sectionName = "";
            sectionName = rowRecords.get(j).get(11).toString().trim();
            if (ObjectUtil.isNotEmpty(sectionName)) {
                model.setSectionName(sectionName);
            }
            //高低左
            String highLowLeft = "";
            highLowLeft = rowRecords.get(j).get(30).toString().trim();
            if (ObjectUtil.isNotEmpty(highLowLeft)) {
                model.setHighLowLeft(highLowLeft);
            }
            //高低右
            String highLowRight = "";
            highLowRight = rowRecords.get(j).get(35).toString().trim();
            if (ObjectUtil.isNotEmpty(highLowRight)) {
                model.setHighLowRight(highLowRight);
            }
            //轨向左
            String trackLeft = "";
            trackLeft = rowRecords.get(j).get(44).toString().trim();
            if (ObjectUtil.isNotEmpty(trackLeft)) {
                model.setTrackLeft(trackLeft);
            }
            //轨向右
            String trackRight = "";
            trackRight = rowRecords.get(j).get(52).toString().trim();
            if (ObjectUtil.isNotEmpty(trackRight)) {
                model.setTrackRight(trackRight);
            }
            //水平（mm）
            String level = "";
            level = rowRecords.get(j).get(65).toString().trim();
            if (ObjectUtil.isNotEmpty(level)) {
                model.setLevel(level);
            }
            //轨距（mm）
            String trackGauge = "";
            trackGauge = rowRecords.get(j).get(75).toString().trim();
            if (ObjectUtil.isNotEmpty(trackGauge)) {
                model.setTrackGauge(trackGauge);
            }
            //三角坑（mm）
            String triangularPit = "";
            triangularPit = rowRecords.get(j).get(81).toString().trim();
            if (ObjectUtil.isNotEmpty(triangularPit)) {
                model.setTriangularPit(triangularPit);
            }
            //TQI数值
            String tqiComeUpon = "";
            tqiComeUpon = rowRecords.get(j).get(87).toString().trim();
            if (ObjectUtil.isNotEmpty(tqiComeUpon)) {
                model.setTqiComeUpon(tqiComeUpon);
            }
            //TQI超标
            String tqiAboveStandard = "";
            tqiAboveStandard = rowRecords.get(j).get(95).toString().trim();
            if (ObjectUtil.isNotEmpty(tqiAboveStandard)) {
                model.setTqiAboveStandard(tqiAboveStandard);
            }
            //扣分
            String deduct = "";
            deduct = rowRecords.get(j).get(103).toString().trim();
            if (ObjectUtil.isNotEmpty(deduct)) {
                model.setDeduct(deduct);
            }
            //检测标准
            String standard = "";
            standard = rowRecords.get(j).get(112).toString().trim();
            if (ObjectUtil.isNotEmpty(standard)) {
                model.setStandard(standard);
            }
            //速度（km/h）
            String spend = "";
            spend = rowRecords.get(j).get(125).toString().trim();
            if (ObjectUtil.isNotEmpty(spend)) {
                model.setSpend(spend);
            }
            movementTqiReportList.add(model);
        }
        return dataOne;
    }

    /**
     * @param movementTqiKilometerReportList 最终的TQI公里总结报告集合
     * @param i                              当前行坐标
     * @param sort                           顺序
     * @param realname                       当前登录人姓名
     * @param rowRecords                     总行列数据集合
     * @param id                             主表id
     */
    public int uploadMovementTqiKilometerReport(List<MovementTqiKilometerReport> movementTqiKilometerReportList, int i, int sort, String realname, List<List<Object>> rowRecords, String id) {
        int dataOne = 0;
        for (int j = i + 5; j < rowRecords.size(); j++) {
            List<Object> list1 = rowRecords.get(j);
            if (list1 == null || list1.size() <= 0) {
                return dataOne;
            }
            String str = list1.get(0).toString().trim();
            if (str.equals("")) {
                return dataOne;
            }
            dataOne++;
            sort++;
            //初始化公里总结报告表
            MovementTqiKilometerReport model = new MovementTqiKilometerReport();
            model.setId(IdWorker.get32UUID());
            model.setDelFlag("0");
            model.setMovementMasterId(id);
            model.setCreateTime(new Date());
            model.setUpdateTime(new Date());
            model.setCreateBy(realname);
            model.setUpdateBy(realname);
            model.setSort(sort);
            //公里
            String kilometer = "";
            kilometer = rowRecords.get(j).get(0).toString().trim();
            if (ObjectUtil.isNotEmpty(kilometer)) {
                model.setKilometer(kilometer);
            }
            //标准
            String standard = "";
            standard = rowRecords.get(j).get(10).toString().trim();
            if (ObjectUtil.isNotEmpty(standard)) {
                model.setStandard(standard);
            }
            //未超标
            String notAboveStandard = "";
            notAboveStandard = rowRecords.get(j).get(25).toString().trim();
            if (ObjectUtil.isNotEmpty(notAboveStandard)) {
                model.setNotAboveStandard(notAboveStandard);
            }
            //超标
            String aboveStandard = "";
            aboveStandard = rowRecords.get(j).get(39).toString().trim();
            if (ObjectUtil.isNotEmpty(aboveStandard)) {
                model.setAboveStandard(aboveStandard);
            }
            //超标10
            String aboveStandardTen = "";
            aboveStandardTen = rowRecords.get(j).get(62).toString().trim();
            if (ObjectUtil.isNotEmpty(aboveStandardTen)) {
                model.setAboveStandardTen(aboveStandardTen);
            }
            //超标20
            String aboveStandardTwenty = "";
            aboveStandardTwenty = rowRecords.get(j).get(80).toString().trim();
            if (ObjectUtil.isNotEmpty(aboveStandardTwenty)) {
                model.setAboveStandardTwenty(aboveStandardTwenty);
            }
            //T值
            String comeUpon = "";
            comeUpon = rowRecords.get(j).get(95).toString().trim();
            if (ObjectUtil.isNotEmpty(comeUpon)) {
                model.setComeUpon(comeUpon);
            }
            //评价
            String rate = "";
            rate = rowRecords.get(j).get(114).toString().trim();
            if (ObjectUtil.isNotEmpty(rate)) {
                model.setRate(rate);
            }

            movementTqiKilometerReportList.add(model);
        }
        return dataOne;
    }

    /**
     * @param movementSummaryReportList 最终的公里总结报告集合
     * @param i                         当前行坐标
     * @param sort                      顺序
     * @param realname                  当前登录人姓名
     * @param rowRecords                总行列数据集合
     * @param id                        主表id
     */
    public int uploadMovementSummaryReport(List<MovementSummaryReport> movementSummaryReportList, int i, int sort, String realname, List<List<Object>> rowRecords, String id) {
        int dataOne = 0;
        for (int j = i + 4; j < rowRecords.size(); j++) {
            List<Object> list1 = rowRecords.get(j);
            if (list1 == null || list1.size() <= 0) {
                return dataOne;
            }
            String str = list1.get(0).toString().trim();
            if (str.equals("")) {
                return dataOne;
            }
            dataOne++;
            sort++;
            //初始化公里总结报告表
            MovementSummaryReport model = new MovementSummaryReport();
            model.setId(IdWorker.get32UUID());
            model.setDelFlag("0");
            model.setMovementMasterId(id);
            model.setCreateTime(new Date());
            model.setUpdateTime(new Date());
            model.setCreateBy(realname);
            model.setUpdateBy(realname);
            model.setSort(sort);
            //公里
            String kilometer = "";
            kilometer = rowRecords.get(j).get(0).toString().trim();
            if (ObjectUtil.isNotEmpty(kilometer)) {
                model.setKilometer(kilometer);
            }
            //长度
            String longitude = "";
            longitude = rowRecords.get(j).get(2).toString().trim();
            if (ObjectUtil.isNotEmpty(longitude)) {
                model.setLongitude(longitude);
            }
            //左高低1
            String leftHighLowOne = "";
            leftHighLowOne = rowRecords.get(j).get(5).toString().trim();
            if (ObjectUtil.isNotEmpty(leftHighLowOne)) {
                model.setLeftHighLowOne(leftHighLowOne);
            }
            //左高低2
            String leftHighLowTwo = "";
            leftHighLowTwo = rowRecords.get(j).get(6).toString().trim();
            if (ObjectUtil.isNotEmpty(leftHighLowTwo)) {
                model.setLeftHighLowTwo(leftHighLowTwo);
            }
            //左高低3
            String leftHighLowThree = "";
            leftHighLowThree = rowRecords.get(j).get(8).toString().trim();
            if (ObjectUtil.isNotEmpty(leftHighLowThree)) {
                model.setLeftHighLowThree(leftHighLowThree);
            }
            //左高低4
            String leftHighLowFour = "";
            leftHighLowFour = rowRecords.get(j).get(12).toString().trim();
            if (ObjectUtil.isNotEmpty(leftHighLowFour)) {
                model.setLeftHighLowFour(leftHighLowFour);
            }
            //右高低1
            String rightHighLowOne = "";
            rightHighLowOne = rowRecords.get(j).get(15).toString().trim();
            if (ObjectUtil.isNotEmpty(rightHighLowOne)) {
                model.setRightHighLowOne(rightHighLowOne);
            }
            //右高低2
            String rightHighLowTwo = "";
            rightHighLowTwo = rowRecords.get(j).get(17).toString().trim();
            if (ObjectUtil.isNotEmpty(rightHighLowTwo)) {
                model.setRightHighLowTwo(rightHighLowTwo);
            }
            //右高低3
            String rightHighLowThree = "";
            rightHighLowThree = rowRecords.get(j).get(20).toString().trim();
            if (ObjectUtil.isNotEmpty(rightHighLowThree)) {
                model.setRightHighLowThree(rightHighLowThree);
            }
            //右高低4
            String rightHighLowFour = "";
            rightHighLowFour = rowRecords.get(j).get(22).toString().trim();
            if (ObjectUtil.isNotEmpty(rightHighLowFour)) {
                model.setRightHighLowFour(rightHighLowFour);
            }
            //左轨向1
            String leftTrackOne = "";
            leftTrackOne = rowRecords.get(j).get(24).toString().trim();
            if (ObjectUtil.isNotEmpty(leftTrackOne)) {
                model.setLeftTrackOne(leftTrackOne);
            }
            //左轨向2
            String leftTrackTwo = "";
            leftTrackTwo = rowRecords.get(j).get(26).toString().trim();
            if (ObjectUtil.isNotEmpty(leftTrackTwo)) {
                model.setLeftTrackTwo(leftTrackTwo);
            }
            //左轨向3
            String leftTrackThree = "";
            leftTrackThree = rowRecords.get(j).get(29).toString().trim();
            if (ObjectUtil.isNotEmpty(leftTrackThree)) {
                model.setLeftTrackThree(leftTrackThree);
            }
            //左轨向4
            String leftTrackFour = "";
            leftTrackFour = rowRecords.get(j).get(31).toString().trim();
            if (ObjectUtil.isNotEmpty(leftTrackFour)) {
                model.setLeftTrackFour(leftTrackFour);
            }
            //右轨向1
            String rightTrackOne = "";
            rightTrackOne = rowRecords.get(j).get(33).toString().trim();
            if (ObjectUtil.isNotEmpty(rightTrackOne)) {
                model.setRightTrackOne(rightTrackOne);
            }
            //右轨向2
            String rigTrackTwo = "";
            rigTrackTwo = rowRecords.get(j).get(34).toString().trim();
            if (ObjectUtil.isNotEmpty(rigTrackTwo)) {
                model.setRightTrackTwo(rigTrackTwo);
            }
            //右轨向3
            String rigTrackThree = "";
            rigTrackThree = rowRecords.get(j).get(37).toString().trim();
            if (ObjectUtil.isNotEmpty(rigTrackThree)) {
                model.setRightTrackThree(rigTrackThree);
            }
            //右轨向4
            String rightTrackFour = "";
            rightTrackFour = rowRecords.get(j).get(38).toString().trim();
            if (ObjectUtil.isNotEmpty(rightTrackFour)) {
                model.setRightTrackFour(rightTrackFour);
            }
            //轨距1
            String trackGaugeOne = "";
            trackGaugeOne = rowRecords.get(j).get(40).toString().trim();
            if (ObjectUtil.isNotEmpty(trackGaugeOne)) {
                model.setTrackGaugeOne(trackGaugeOne);
            }
            //轨距2
            String trackGaugeTwo = "";
            trackGaugeTwo = rowRecords.get(j).get(43).toString().trim();
            if (ObjectUtil.isNotEmpty(trackGaugeTwo)) {
                model.setTrackGaugeTwo(trackGaugeTwo);
            }
            //轨距3
            String trackGaugeThree = "";
            trackGaugeThree = rowRecords.get(j).get(48).toString().trim();
            if (ObjectUtil.isNotEmpty(trackGaugeThree)) {
                model.setTrackGaugeThree(trackGaugeThree);
            }
            //轨距4
            String trackGaugeFour = "";
            trackGaugeFour = rowRecords.get(j).get(50).toString().trim();
            if (ObjectUtil.isNotEmpty(trackGaugeFour)) {
                model.setTrackGaugeFour(trackGaugeFour);
            }
            //水平1
            String levelOne = "";
            levelOne = rowRecords.get(j).get(51).toString().trim();
            if (ObjectUtil.isNotEmpty(levelOne)) {
                model.setLevelOne(levelOne);
            }
            //水平2
            String levelTwo = "";
            levelTwo = rowRecords.get(j).get(54).toString().trim();
            if (ObjectUtil.isNotEmpty(levelTwo)) {
                model.setLevelTwo(levelTwo);
            }
            //水平3
            String levelThree = "";
            levelThree = rowRecords.get(j).get(61).toString().trim();
            if (ObjectUtil.isNotEmpty(levelThree)) {
                model.setLevelThree(levelThree);
            }
            //水平4
            String levelFour = "";
            levelFour = rowRecords.get(j).get(64).toString().trim();
            if (ObjectUtil.isNotEmpty(levelFour)) {
                model.setLevelFour(levelFour);
            }
            //三角坑1
            String triangularPitOne = "";
            triangularPitOne = rowRecords.get(j).get(66).toString().trim();
            if (ObjectUtil.isNotEmpty(triangularPitOne)) {
                model.setTriangularPitOne(triangularPitOne);
            }
            //三角坑2
            String triangularPitTwo = "";
            triangularPitTwo = rowRecords.get(j).get(68).toString().trim();
            if (ObjectUtil.isNotEmpty(triangularPitTwo)) {
                model.setTriangularPitTwo(triangularPitTwo);
            }
            //三角坑3
            String triangularPitThree = "";
            triangularPitThree = rowRecords.get(j).get(73).toString().trim();
            if (ObjectUtil.isNotEmpty(triangularPitThree)) {
                model.setTriangularPitThree(triangularPitThree);
            }
            //三角坑4
            String triangularPitFour = "";
            triangularPitFour = rowRecords.get(j).get(76).toString().trim();
            if (ObjectUtil.isNotEmpty(triangularPitFour)) {
                model.setTriangularPitFour(triangularPitFour);
            }
            //曲率1
            String curvatureOne = "";
            curvatureOne = rowRecords.get(j).get(77).toString().trim();
            if (ObjectUtil.isNotEmpty(curvatureOne)) {
                model.setCurvatureOne(curvatureOne);
            }
            //曲率2
            String curvatureTwo = "";
            curvatureTwo = rowRecords.get(j).get(79).toString().trim();
            if (ObjectUtil.isNotEmpty(curvatureTwo)) {
                model.setCurvatureTwo(curvatureTwo);
            }
            //曲率3
            String curvatureThree = "";
            curvatureThree = rowRecords.get(j).get(82).toString().trim();
            if (ObjectUtil.isNotEmpty(curvatureThree)) {
                model.setCurvatureThree(curvatureThree);
            }
            //曲率4
            String curvatureFour = "";
            curvatureFour = rowRecords.get(j).get(83).toString().trim();
            if (ObjectUtil.isNotEmpty(curvatureFour)) {
                model.setCurvatureFour(curvatureFour);
            }
            //垂向加速度1
            String droopVelocityOne = "";
            droopVelocityOne = rowRecords.get(j).get(85).toString().trim();
            if (ObjectUtil.isNotEmpty(droopVelocityOne)) {
                model.setDroopVelocityOne(droopVelocityOne);
            }
            //垂向加速度2
            String droopVelocityTwo = "";
            droopVelocityTwo = rowRecords.get(j).get(88).toString().trim();
            if (ObjectUtil.isNotEmpty(droopVelocityTwo)) {
                model.setDroopVelocityTwo(droopVelocityTwo);
            }
            //垂向加速度3
            String droopVelocityThree = "";
            droopVelocityThree = rowRecords.get(j).get(91).toString().trim();
            if (ObjectUtil.isNotEmpty(droopVelocityThree)) {
                model.setDroopVelocityThree(droopVelocityThree);
            }
            //垂向加速度4
            String droopVelocityFour = "";
            droopVelocityFour = rowRecords.get(j).get(93).toString().trim();
            if (ObjectUtil.isNotEmpty(droopVelocityFour)) {
                model.setDroopVelocityFour(droopVelocityFour);
            }
            //横向加速度1
            String acrossVelocityOne = "";
            acrossVelocityOne = rowRecords.get(j).get(94).toString().trim();
            if (ObjectUtil.isNotEmpty(acrossVelocityOne)) {
                model.setAcrossVelocityOne(acrossVelocityOne);
            }
            //横向加速度2
            String acrossVelocityTwo = "";
            acrossVelocityTwo = rowRecords.get(j).get(97).toString().trim();
            if (ObjectUtil.isNotEmpty(acrossVelocityTwo)) {
                model.setAcrossVelocityTwo(acrossVelocityTwo);
            }
            //横向加速度3
            String acrossVelocityThree = "";
            acrossVelocityThree = rowRecords.get(j).get(99).toString().trim();
            if (ObjectUtil.isNotEmpty(acrossVelocityThree)) {
                model.setAcrossVelocityThree(acrossVelocityThree);
            }
            //横向加速度4
            String acrossVelocityFour = "";
            acrossVelocityFour = rowRecords.get(j).get(101).toString().trim();
            if (ObjectUtil.isNotEmpty(acrossVelocityFour)) {
                model.setAcrossVelocityFour(acrossVelocityFour);
            }
            //曲率变化率1
            String curvatureChangeOne = "";
            curvatureChangeOne = rowRecords.get(j).get(104).toString().trim();
            if (ObjectUtil.isNotEmpty(curvatureChangeOne)) {
                model.setCurvatureChangeOne(curvatureChangeOne);
            }
            //曲率变化率2
            String curvatureChangeTwo = "";
            curvatureChangeTwo = rowRecords.get(j).get(108).toString().trim();
            if (ObjectUtil.isNotEmpty(curvatureChangeTwo)) {
                model.setCurvatureChangeTwo(curvatureChangeTwo);
            }
            //轨距变化率1
            String trackGaugeChangeOne = "";
            trackGaugeChangeOne = rowRecords.get(j).get(111).toString().trim();
            if (ObjectUtil.isNotEmpty(trackGaugeChangeOne)) {
                model.setTrackGaugeChangeOne(trackGaugeChangeOne);
            }
            //轨距变化率2
            String trackGaugeChangeTwo = "";
            trackGaugeChangeTwo = rowRecords.get(j).get(115).toString().trim();
            if (ObjectUtil.isNotEmpty(trackGaugeChangeTwo)) {
                model.setTrackGaugeChangeTwo(trackGaugeChangeTwo);
            }
            //公里扣分
            String kilometerDeduct = "";
            kilometerDeduct = rowRecords.get(j).get(119).toString().trim();
            if (ObjectUtil.isNotEmpty(kilometerDeduct)) {
                model.setKilometerDeduct(kilometerDeduct);
            }
            //评定
            String evaluate = "";
            evaluate = rowRecords.get(j).get(123).toString().trim();
            if (ObjectUtil.isNotEmpty(evaluate)) {
                model.setEvaluate(evaluate);
            }
            //速度 (km/h)
            String speed = "";
            speed = rowRecords.get(j).get(127).toString().trim();
            if (ObjectUtil.isNotEmpty(speed)) {
                model.setSpeed(speed);
            }
            movementSummaryReportList.add(model);
        }
        return dataOne;
    }

    /**
     * 导入初始化轨检车数据
     *
     * @param id
     * @return
     */
    private boolean initData(String id) {
        //轨检车-》轨道动态几何尺寸容许值差管理值
        QueryWrapper<MovementDiferenceManager> movementDiferenceManagerRemove = new QueryWrapper<>();
        movementDiferenceManagerRemove.eq("movement_master_id", id);
        movementDiferenceManagerService.remove(movementDiferenceManagerRemove);
        //轨检车-》超限记录报告
        QueryWrapper<MovementOverReport> movementOverReportRemove = new QueryWrapper<>();
        movementOverReportRemove.eq("movement_master_id", id);
        movementOverReportService.remove(movementOverReportRemove);
        //轨检车-》区段总结报告
        QueryWrapper<MovementSectionReport> movementSectionReportRemove = new QueryWrapper<>();
        movementSectionReportRemove.eq("movement_master_id", id);
        movementSectionReportService.remove(movementSectionReportRemove);
        //轨检车-》区段总结报告
        QueryWrapper<MovementSummaryReport> movementSummaryReportRemove = new QueryWrapper<>();
        movementSummaryReportRemove.eq("movement_master_id", id);
        movementSummaryReportService.remove(movementSummaryReportRemove);
        //轨检车-》TQI公里总结报告
        QueryWrapper<MovementTqiKilometerReport> movementTqiKilometerReportRemove = new QueryWrapper<>();
        movementTqiKilometerReportRemove.eq("movement_master_id", id);
        movementTqiKilometerReportService.remove(movementTqiKilometerReportRemove);
        //轨检车-》TQI公里状态评定标准
        QueryWrapper<MovementTqiKilometerStandardManager> movementTqiKilometerStandardManagerRemove = new QueryWrapper<>();
        movementTqiKilometerStandardManagerRemove.eq("movement_master_id", id);
        movementTqiKilometerStandardManagerService.remove(movementTqiKilometerStandardManagerRemove);
        //轨检车-》TQI总结报告
        QueryWrapper<MovementTqiReport> movementTqiReportRemove = new QueryWrapper<>();
        movementTqiReportRemove.eq("movement_master_id", id);
        movementTqiReportService.remove(movementTqiReportRemove);
        //轨检车-》200m区段轨道不平顺质量指数TQI管理标准(单位：mm)
        QueryWrapper<MovementTqiStandardManager> movementTqiStandardManagerRemove = new QueryWrapper<>();
        movementTqiStandardManagerRemove.eq("movement_master_id", id);
        movementTqiStandardManagerService.remove(movementTqiStandardManagerRemove);
        return true;
    }

    /**
     * 校验参数
     *
     * @param movementRecordsMaster
     */
    private boolean validate(MovementRecordsMaster movementRecordsMaster) {
        if (ObjectUtil.isEmpty(movementRecordsMaster.getType())) {
            return false;
        }
        if (ObjectUtil.isEmpty(movementRecordsMaster.getEkCode())) {
            return false;
        }
        return true;
    }

}
