package org.jeecg.modules.checkData.controller;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.checkData.dto.RecordsMasterCheckDTO;
import org.jeecg.modules.checkData.entity.*;
import org.jeecg.modules.checkData.service.*;
import org.jeecg.modules.checkData.vo.RecordsMasterCheckVO;
import org.jeecg.modules.checkData.vo.RecordsMasterTurnoutInfoVO;
import org.jeecg.modules.checkData.vo.TrackBedManagementCheckVO;
import org.jeecg.modules.deviceAsset.entity.TrackBedManagement;
import org.jeecg.modules.deviceAsset.service.ITrackBedManagementService;
import org.jeecg.modules.utils.BeanCopyUtil;
import org.jeecg.modules.utils.ExcelAnalysisUtils;
import org.jeecg.modules.utils.ExcelUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transactional;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;

/**
 * <p>
 * 设备检查记录主表 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-07-07
 */
@RestController
@RequestMapping("/recordsMaster/check")
@Api(tags = "设备检查记录主表控制器")
public class RecordsMasterCheckController extends JeecgController<RecordsMasterCheck, IRecordsMasterCheckService> {
    @Resource
    private ITrackBedManagementService trackBedManagementService;
    @Resource
    private ITrackBedManagementCheckService trackBedManagementCheckService;
    @Resource
    private IRecordsMasterTurnoutInfoService recordsMasterTurnoutInfoService;
    @Resource
    private IRailWearRecordService railWearRecordService;
    @Resource
    private ICurveWearRecordService curveWearRecordService;
    @Resource
    private IRecordsMasterCorrWaveService recordsMasterCorrWaveService;
    @Resource
    private IRecordsMasterCorrWaveInfoService recordsMasterCorrWaveInfoService;
    @Resource
    private ICorrugationRecordService corrugationRecordService;

    //********************************设备检查记录相关接口*************************************************************

    /**
     * 设备检查记录-分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param dto
     * @return
     */
    @AutoLog(value = "设备检查记录-分页列表查询")
    @ApiOperation(value = "设备检查记录-分页列表查询", notes = "设备检查记录-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<RecordsMasterCheckVO>> queryPageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                             @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                             RecordsMasterCheckDTO dto) {
        Page<RecordsMasterCheckVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.queryPageList(pageData, dto);
        return Result.OK(pageData);
    }

    /**
     * 根据区间id和线别id查询道床列表
     *
     * @param sectionId
     * @param lineAliasId
     * @return
     */
    @AutoLog(value = "根据区间id查询道床列表")
    @ApiOperation(value = "根据区间id查询道床列表", notes = "根据区间id和线别id查询道床列表")
    @GetMapping(value = "/getTrackBedBySubwayIdAndLineId")
    public Result<List<TrackBedManagement>> getTrackBedBySubwayIdAndLineId(@ApiParam(name = "区间id") String sectionId,
                                                                           @ApiParam(name = "线别id") String lineAliasId) {
        List<TrackBedManagement> listResult = trackBedManagementService.lambdaQuery()
                .eq(ObjectUtil.isNotEmpty(sectionId), TrackBedManagement::getSectionId, sectionId)
                .eq(ObjectUtil.isNotEmpty(lineAliasId), TrackBedManagement::getLineAliasId, lineAliasId)
                .orderByAsc(TrackBedManagement::getTrackBedCode)
                .list();
//        List<TrackBedManagement> listResult  = trackBedManagementService

        return Result.OK(listResult);
    }

    @AutoLog(value = "根据区间id查询道床列表")
    @ApiOperation(value = "根据区间id查询道床列表", notes = "根据区间id查询道床列表")
    @GetMapping(value = "/getTrackBedById")
    public Result<List<TrackBedManagement>> getTrackBedById(String id) {

        List<TrackBedManagement> listResult = trackBedManagementService.getTrackBedById(id);

        return Result.OK(listResult);
    }


    /**
     * 根据道床使用情况记录数据表的道床id查询对应的实用情况
     *
     * @param managementId 道床id
     * @return
     */
    @AutoLog(value = "根据道床使用情况记录数据表的道床id和检查记录主表的id查询对应的实用情况")
    @ApiOperation(value = "根据道床使用情况记录数据表的道床id和检查记录主表的id查询对应的实用情况", notes = "根据道床使用情况记录数据表的道床id和检查记录主表的id查询对应的实用情况")
    @GetMapping(value = "/getTrackBedByManagementIdAndRecordId")
    public Result<List<TrackBedManagementCheckVO>> getTrackBedByManagementId(@ApiParam(name = "道床id") String managementId, @ApiParam(name = "检查记录表主键id") String recordId) {
        List<TrackBedManagementCheck> listResult = trackBedManagementCheckService.lambdaQuery()
                .eq(ObjectUtil.isNotEmpty(managementId), TrackBedManagementCheck::getTrakBedManagementId, managementId)
                .eq(ObjectUtil.isNotEmpty(recordId), TrackBedManagementCheck::getRecordsMasterCheckId, recordId)
                .eq(TrackBedManagementCheck::getDelFlag, "0")
                .orderByAsc(TrackBedManagementCheck::getCreateTime)
                .list();
        if (listResult != null) {
            List<TrackBedManagementCheckVO> resultList = BeanCopyUtil.copyListProperties(listResult, TrackBedManagementCheckVO::new);
            return Result.OK(resultList);
        }
        return Result.OK(new ArrayList<>());
    }

    @AutoLog(value = "设备检查记录主数据新增或者编辑")
    @ApiOperation(value = "设备检查记录主数据新增或者编辑", notes = "设备检查记录主数据新增或者编辑")
    @PostMapping(value = "/saveOrUpdate")
    @ResponseBody
    public Result<String> saveOrUpdate(@RequestBody RecordsMasterCheck recordsMasterCheck) {
        if (ObjectUtil.isEmpty(recordsMasterCheck.getType())) {
            return Result.error("传递参数不完整");
        }
        recordsMasterCheck.setUpdateTime(new Date());
        recordsMasterCheck.setDelFlag("0");
        if (ObjectUtil.isEmpty(recordsMasterCheck.getId())) {
            recordsMasterCheck.setId(UUIDGenerator.generate());
            this.service.save(recordsMasterCheck);
        } else {
            this.service.updateById(recordsMasterCheck);
        }
        return Result.OK("操作成功!");
    }


    /**
     * 删除设备检查记录主数据及相关联的数据
     *
     * @param id
     * @param type
     * @return
     */
    @AutoLog(value = "删除设备检查记录主数据及相关联的数据")
    @ApiOperation(value = "删除设备检查记录主数据及相关联的数据", notes = "删除设备检查记录主数据及相关联的数据")
    @GetMapping(value = "/delete")
    public Result<String> delete(@ApiParam(name = "动静态几何尺寸数据id", required = true) String id, @ApiParam(name = "动静态几何尺寸数据类型", required = true) String type) {
        //设备检查类型（1：道岔使用情况；2：钢轨伤损情况；3：曲线磨损情况；4：钢轨波磨情况；5：道床使用情况）
        if ("1".equals(type)) {
            //删除道岔使用情况检查数据
            recordsMasterTurnoutInfoService.lambdaUpdate().eq(RecordsMasterTurnoutInfo::getRecordsMasterId, id).remove();
        } else if ("2".equals(type)) {
            //钢轨伤损情况检查表
            railWearRecordService.lambdaUpdate().eq(RailWearRecord::getRecordsMasterCheckId, id).remove();
        } else if ("3".equals(type)) {
            //曲线磨损情况检查数据
            curveWearRecordService.lambdaUpdate().eq(CurveWearRecord::getRecordsMasterCheckId, id).remove();
        } else if ("5".equals(type)) {
            //道床使用情况检查数据
            trackBedManagementCheckService.lambdaUpdate().eq(TrackBedManagementCheck::getRecordsMasterCheckId, id).remove();
        } else {
            //钢轨波磨情况检查数据
//            recordsMasterCorrWaveService.lambdaUpdate().eq(RecordsMasterCorrWave::getRecordsMasterId, id).remove();
//            recordsMasterCorrWaveInfoService.lambdaUpdate().eq(RecordsMasterCorrWaveInfo::getRecordsMasterId, id).remove();
            corrugationRecordService.lambdaUpdate().eq(CorrugationRecord::getRecordsMasterCheckId, id).remove();
        }
        //删除设备检查记录主数据
        this.service.lambdaUpdate().eq(RecordsMasterCheck::getId, id).remove();
        return Result.OK("删除成功!");
    }
//****************************道岔使用情况检查数据相关接口**************************************************************************************************************

    /**
     * 根据设备检查记录主键查询道岔使用情况检查数据
     *
     * @param id 设备检查记录主键
     * @return
     */
    @AutoLog(value = "根据设备检查记录主键查询道岔使用情况检查数据")
    @ApiOperation(value = "根据设备检查记录主键查询道岔使用情况检查数据", notes = "根据设备检查记录主键查询道岔使用情况检查数据")
    @GetMapping(value = "/getTurnoutInfoList")
    public Result<List<RecordsMasterTurnoutInfoVO>> getTurnoutInfoList(@ApiParam(name = "设备检查记录主键id") String id, @ApiParam(name = "道岔编码") String code) {
        List<RecordsMasterTurnoutInfo> listResult = recordsMasterTurnoutInfoService.lambdaQuery()
                .eq(ObjectUtil.isNotEmpty(id), RecordsMasterTurnoutInfo::getRecordsMasterId, id)
                .eq(RecordsMasterTurnoutInfo::getSwitchCode, code)
                .eq(RecordsMasterTurnoutInfo::getDelFlag, "0")
                .list();
        List<RecordsMasterTurnoutInfoVO> resultList = new ArrayList<>();
        if (listResult != null) {
            resultList = BeanCopyUtil.copyListProperties(listResult, RecordsMasterTurnoutInfoVO::new);
        }
        return Result.OK(resultList);
    }

    /**
     * 根据设备检查记录主键回显道岔编号的集合
     *
     * @param id 设备检查记录主键
     * @return
     */
    @AutoLog(value = "根据设备检查记录主键回显道岔编号的集合")
    @ApiOperation(value = "根据设备检查记录主键回显道岔编号的集合", notes = "根据设备检查记录主键回显道岔编号的集合")
    @GetMapping(value = "/getTurnoutCodeList")
    public Result<List<RecordsMasterTurnoutInfo>> getTurnoutCodeList(@ApiParam(name = "设备检查记录主键id") String id) {
        List<RecordsMasterTurnoutInfo> listResult = recordsMasterTurnoutInfoService.lambdaQuery()
                .eq(ObjectUtil.isNotEmpty(id), RecordsMasterTurnoutInfo::getRecordsMasterId, id)
                .eq(RecordsMasterTurnoutInfo::getDelFlag, "0")
                .eq(RecordsMasterTurnoutInfo::getType, "9")
                .orderByAsc(RecordsMasterTurnoutInfo::getSort)
                .list();
        return Result.OK(listResult);
    }

    @AutoLog(value = "道岔使用情况导入")
    @ApiOperation(value = "道岔使用情况导入", notes = "道岔使用情况导入")
    @PostMapping(value = "/turnoutInfoUpload")
    @Transactional
    public Result<String> turnoutInfoUpload(MultipartFile file, @ApiParam(name = "设备检查记录主键id") String id) throws Exception {
        try {
            //初始化数据模板
            QueryWrapper<RecordsMasterTurnoutInfo> wrapper = new QueryWrapper<>();
            wrapper.eq("records_master_id", id);
            recordsMasterTurnoutInfoService.remove(wrapper);

            InputStream in = file.getInputStream();
            //读取Excel中的数据
            List<List<Object>> rowRecords = ExcelAnalysisUtils.getListByExcel(in);
            //获取当前登录人信息
            LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
            String realname = user.getRealname();
            //初始化道岔编号
            String switchCode = "";
            //初始化道岔号数
            String switchCodeNum = "";
            //初始化备注
            String remark = "";
            //初始化道岔使用情况检查数据集合
            List<RecordsMasterTurnoutInfo> recordsMasterTurnoutInfoList = new ArrayList<>();
            //初始化道岔顺序
            Integer sort = 0;
            for (int i = 0; i < rowRecords.size(); i++) {
                List<Object> list = rowRecords.get(i);
                String str = list.get(0).toString().trim();
                if (str.contains("道岔编号")) {
                    //截取最后一个:号之后的字符串并去除首位空格
                    switchCode = str.substring(str.indexOf("道岔编号") + 5).trim();
                } else if (str.contains("道岔号数")) {
                    switchCodeNum = str.substring(str.indexOf("道岔号数") + 5).trim();
                } else if (str.contains("备注")) {
                    sort = sort + 1;
                    //截取最后一个:号之后的字符串并去除首位空格
                    remark = list.get(1).toString().trim();
                    RecordsMasterTurnoutInfo model = new RecordsMasterTurnoutInfo();
                    model.setId(IdWorker.get32UUID());
                    model.setDelFlag("0");
                    model.setRecordsMasterId(id);
                    model.setCreateTime(new Date());
                    model.setUpdateTime(new Date());
                    model.setCreateBy(realname);
                    model.setUpdateBy(realname);
                    model.setType("9");
                    model.setSwitchCode(switchCode);
                    model.setSwitchCodeNum(switchCodeNum);
                    model.setRemark(remark);
                    model.setSort(sort);
                    recordsMasterTurnoutInfoList.add(model);
                } else if (str.equals("轨距")) {
                    this.uploadTrackGauge(recordsMasterTurnoutInfoList, i, realname, rowRecords, id, "1", switchCode, switchCodeNum);
                } else if (str.equals("水平")) {
                    this.uploadTrackGauge(recordsMasterTurnoutInfoList, i, realname, rowRecords, id, "2", switchCode, switchCodeNum);
                } else if (str.equals("支距")) {
                    //获取支距下一行的数据
                    List<Object> offsetList = rowRecords.get(i + 1);
                    this.uploadOffset(recordsMasterTurnoutInfoList, offsetList, realname, id, switchCode, switchCodeNum);
                } else if (str.equals("轮缘槽")) {
                    //获取支距下两行的数据
                    List<Object> flangeList = rowRecords.get(i + 2);
                    this.uploadFlange(recordsMasterTurnoutInfoList, flangeList, realname, id, switchCode, switchCodeNum);
                } else if (str.equals("2.1")) {
                    this.uploadSwitchPlate(recordsMasterTurnoutInfoList, list, realname, id, "5",switchCode, switchCodeNum);
                } else if (str.equals("2.2")) {
                    this.uploadSwitchPlate(recordsMasterTurnoutInfoList, list, realname, id, "6",switchCode, switchCodeNum);
                } else if (str.equals("3.1")) {
                    this.uploadSwitchPlate(recordsMasterTurnoutInfoList, list, realname, id, "7",switchCode, switchCodeNum);
                } else if (str.equals("3.2")) {
                    this.uploadSwitchPlate(recordsMasterTurnoutInfoList, list, realname, id, "8",switchCode, switchCodeNum);
                } else {
                    if (i != rowRecords.size() - 1) {
                        continue;
                    } else {
                        //释放资源
                        in.close();
                    }
                }
            }

            //维护道岔使用情况检查数据表
            if (recordsMasterTurnoutInfoList != null && recordsMasterTurnoutInfoList.size() > 0) {
                recordsMasterTurnoutInfoService.saveBatch(recordsMasterTurnoutInfoList);
            }
            //释放资源
            in.close();
        } catch (Exception e) {
            e.getMessage();
        }
        return Result.ok("操作成功");
    }
//*****************************************钢轨波磨情况检查数据********************************************************

    /**
     * 根据设备检查记录主键回显钢轨波磨情况检查数据
     *
     * @param id 设备检查记录主键
     * @return
     */
    @AutoLog(value = "根据设备检查记录主键回显钢轨波磨情况检查数据")
    @ApiOperation(value = "根据设备检查记录主键回显钢轨波磨情况检查数据", notes = "根据设备检查记录主键回显钢轨波磨情况检查数据")
    @GetMapping(value = "/getCorrWaveList")
    public Result<Map<String, Object>> getCorrWaveList(@ApiParam(name = "设备检查记录主键id") String id, @ApiParam(name = "检查类型") String type) {
        Map<String, Object> map = new HashMap<>();
        List<RecordsMasterCorrWave> listResult = recordsMasterCorrWaveService.lambdaQuery()
                .eq(ObjectUtil.isNotEmpty(id), RecordsMasterCorrWave::getRecordsMasterId, id)
                .eq(ObjectUtil.isNotEmpty(type), RecordsMasterCorrWave::getType, type)
                .eq(RecordsMasterCorrWave::getDelFlag, "0")
                .orderByAsc(RecordsMasterCorrWave::getSort)
                .list();
        map.put("corrWave", listResult);
        List<RecordsMasterCorrWaveInfo> infoList = recordsMasterCorrWaveInfoService.lambdaQuery()
                .eq(ObjectUtil.isNotEmpty(id), RecordsMasterCorrWaveInfo::getRecordsMasterId, id)
                .eq(ObjectUtil.isNotEmpty(type), RecordsMasterCorrWaveInfo::getType, type)
                .eq(RecordsMasterCorrWaveInfo::getDelFlag, "0")
                .orderByAsc(RecordsMasterCorrWaveInfo::getSort)
                .list();
        map.put("corrWaveInfo", infoList);
        return Result.OK(map);
    }

    @AutoLog(value = "钢轨波磨情况导入")
    @ApiOperation(value = "钢轨波磨情况导入", notes = "钢轨波磨情况导入")
    @PostMapping(value = "/corrWaveUpload")
    @Transactional
    public Result<String> corrWaveUpload(MultipartFile file, @ApiParam(name = "设备检查记录主键id") String id) throws Exception {
        try {
            //初始化数据模板
            QueryWrapper<RecordsMasterCorrWave> wrapper = new QueryWrapper<>();
            wrapper.eq("records_master_id", id);
            recordsMasterCorrWaveService.remove(wrapper);
            QueryWrapper<RecordsMasterCorrWaveInfo> infoWrapper = new QueryWrapper<>();
            infoWrapper.eq("records_master_id", id);
            recordsMasterCorrWaveInfoService.remove(infoWrapper);

            InputStream in = file.getInputStream();
            //读取Excel中的数据
            List<List<Object>> rowRecords = ExcelAnalysisUtils.getListByExcel(in);
            //获取当前登录人信息
            LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
            String realname = user.getRealname();
            //初始化钢轨波磨情况波长数据集合
            List<RecordsMasterCorrWave> recordsMasterCorrWaveList = new ArrayList<>();
            //初始化钢轨波磨情况波长详情数据集合
            List<RecordsMasterCorrWaveInfo> infoList = new ArrayList<>();
            //初始化顺序
            Integer sort = 0;
            Integer type = 0;
            Integer infoType = 1;
            for (int i = 0; i < rowRecords.size(); i++) {
                List<Object> list = rowRecords.get(i);
                String str = list.get(0).toString().trim();
                if (str.equals("波长")) {
                    type = type + 1;
                    sort = sort + 1;
                    this.uploadCorrWave(recordsMasterCorrWaveList, rowRecords, i, realname, id, type, sort);
                } else if (str.equals("D.N.")) {
                    infoType = this.uploadCorrWaveInfo(infoList, rowRecords, i, realname, id, infoType);
                } else {
                    if (i != rowRecords.size() - 1) {
                        continue;
                    } else {
                        //释放资源
                        in.close();
                    }
                }
            }
            if (recordsMasterCorrWaveList != null && recordsMasterCorrWaveList.size() > 0) {
                recordsMasterCorrWaveService.saveBatch(recordsMasterCorrWaveList);
            }
            if (infoList != null && infoList.size() > 0) {
                recordsMasterCorrWaveInfoService.saveBatch(infoList);
            }
            //释放资源
            in.close();
        } catch (Exception e) {
            e.getMessage();
        }
        return Result.ok("操作成功");
    }
//*****************************************封装解析方法*************************************************************

    /**
     * 处理波长详情部分
     *
     * @param recordsMasterCorrWaveInfoList
     * @param rowRecords
     * @param i
     * @param realname
     * @param id
     * @param type
     */
    public Integer uploadCorrWaveInfo(List<RecordsMasterCorrWaveInfo> recordsMasterCorrWaveInfoList, List<List<Object>> rowRecords, int i, String realname, String id, Integer type) {
        Integer sort1 = 0;
        for (int j = i + 1; j < rowRecords.size(); j++) {
            String data = rowRecords.get(j).get(0).toString().trim();
            if (ObjectUtil.isEmpty(data)) {
                return type + 1;
            }
            sort1++;
            RecordsMasterCorrWaveInfo model = new RecordsMasterCorrWaveInfo();
            model.setId(IdWorker.get32UUID());
            model.setDelFlag("0");
            model.setRecordsMasterId(id);
            model.setCreateTime(new Date());
            model.setUpdateTime(new Date());
            model.setCreateBy(realname);
            model.setUpdateBy(realname);
            model.setSort(sort1);
            model.setType(type.toString());
            //获取编号
            String code = "";
            code = rowRecords.get(j).get(0).toString().trim();
            //获取里程
            String mileage = "";
            mileage = rowRecords.get(j).get(1).toString().trim();
            //获取波长
            String waveNum = "";
            waveNum = rowRecords.get(j).get(2).toString().trim();
            //获取值
            String one = "";
            one = rowRecords.get(j).get(3).toString().trim();
            //获取限定值
            String restrictNum = "";
            restrictNum = rowRecords.get(j).get(4).toString().trim();
            if (ObjectUtil.isNotEmpty(code)) {
                model.setCode(code);
            }
            if (ObjectUtil.isNotEmpty(mileage)) {
                model.setMileage(mileage);
            }
            if (ObjectUtil.isNotEmpty(waveNum)) {
                model.setWaveNum(waveNum);
            }
            if (ObjectUtil.isNotEmpty(one)) {
                model.setNumOne(one);
            }
            if (ObjectUtil.isNotEmpty(restrictNum)) {
                model.setRestrictNum(restrictNum);
            }
            recordsMasterCorrWaveInfoList.add(model);
        }
        return type;
    }

    /**
     * 处理波长部分
     *
     * @param recordsMasterCorrWaveList
     * @param rowRecords
     * @param i
     * @param realname
     * @param id
     * @param type
     * @param sort
     */
    public void uploadCorrWave(List<RecordsMasterCorrWave> recordsMasterCorrWaveList, List<List<Object>> rowRecords, int i, String realname, String id, Integer type, Integer sort) {
        RecordsMasterCorrWave model = new RecordsMasterCorrWave();
        model.setId(IdWorker.get32UUID());
        model.setDelFlag("0");
        model.setRecordsMasterId(id);
        model.setCreateTime(new Date());
        model.setUpdateTime(new Date());
        model.setCreateBy(realname);
        model.setUpdateBy(realname);
        model.setSort(sort);
        if (type <= 4) {
            model.setType("1");
        } else if (type > 4 && type <= 8) {
            model.setType("2");
        } else {
            model.setType("3");
        }
        //获取波长
        String wave = "";
        wave = rowRecords.get(i).get(1).toString().trim();
        //获取TH1
        String one = "";
        one = rowRecords.get(i).get(3).toString().trim();
        //获取TH2
        String two = "";
        two = rowRecords.get(i).get(5).toString().trim();
        //获取TH3
        String three = "";
        three = rowRecords.get(i).get(7).toString().trim();
        if (ObjectUtil.isNotEmpty(one)) {
            model.setNumOne(new BigDecimal(one));
        }
        if (ObjectUtil.isNotEmpty(two)) {
            model.setNumTwo(new BigDecimal(two));
        }
        if (ObjectUtil.isNotEmpty(three)) {
            model.setNumThree(new BigDecimal(three));
        }
        if (ObjectUtil.isNotEmpty(wave)) {
            model.setWave(wave);
        }
        recordsMasterCorrWaveList.add(model);
    }

    /**
     * 处理滑床板部分
     *
     * @param recordsMasterTurnoutInfoList
     * @param list
     * @param realname
     * @param id
     */
    public void uploadSwitchPlate(List<RecordsMasterTurnoutInfo> recordsMasterTurnoutInfoList, List<Object> list, String realname, String id, String type,String switchCode, String switchCodeNum) {
        String str1 = list.get(1).toString().trim();
        String[] n = str1.split("þ");
        String s = n[0];
        String s1 = n[1];
        RecordsMasterTurnoutInfo model = new RecordsMasterTurnoutInfo();
        model.setId(IdWorker.get32UUID());
        model.setDelFlag("0");
        model.setRecordsMasterId(id);
        model.setSwitchCodeNum(switchCodeNum);
        model.setSwitchCode(switchCode);
        model.setCreateTime(new Date());
        model.setUpdateTime(new Date());
        model.setCreateBy(realname);
        model.setUpdateBy(realname);
        model.setType(type);
        if (s.contains("不合格")) {
            model.setQualified("2");
            String noQualifiedRemark = "";
            noQualifiedRemark = s1.substring(s1.indexOf("不合格说明") + 6).trim();
            model.setNoQualifiedRemark(noQualifiedRemark);
        } else {
            model.setQualified("1");
        }
        recordsMasterTurnoutInfoList.add(model);
    }

    /**
     * 处理轮缘槽部分
     *
     * @param recordsMasterTurnoutInfoList
     * @param list
     * @param realname
     * @param id
     */
    public void uploadFlange(List<RecordsMasterTurnoutInfo> recordsMasterTurnoutInfoList, List<Object> list, String realname, String id, String switchCode, String switchCodeNum) {
        RecordsMasterTurnoutInfo model = new RecordsMasterTurnoutInfo();
        model.setId(IdWorker.get32UUID());
        model.setDelFlag("0");
        model.setRecordsMasterId(id);
        model.setCreateTime(new Date());
        model.setUpdateTime(new Date());
        model.setCreateBy(realname);
        model.setUpdateBy(realname);
        model.setType("4");
        model.setSwitchCode(switchCode);
        model.setSwitchCodeNum(switchCodeNum);
        String one = "";
        one = list.get(1).toString().trim();
        if (ObjectUtil.isNotEmpty(one)) {
            model.setNumOne(one);
        }
        String two = "";
        two = list.get(3).toString().trim();
        if (ObjectUtil.isNotEmpty(two)) {
            model.setNumTwo(two);
        }
        String three = "";
        three = list.get(5).toString().trim();
        if (ObjectUtil.isNotEmpty(three)) {
            model.setNumThree(three);
        }
        String four = "";
        four = list.get(7).toString().trim();
        if (ObjectUtil.isNotEmpty(four)) {
            model.setNumFour(four);
        }
        String five = "";
        five = list.get(9).toString().trim();
        if (ObjectUtil.isNotEmpty(five)) {
            model.setNumFive(five);
        }
        String six = "";
        six = list.get(11).toString().trim();
        if (ObjectUtil.isNotEmpty(six)) {
            model.setNumSix(six);
        }
        String seven = "";
        seven = list.get(13).toString().trim();
        if (ObjectUtil.isNotEmpty(seven)) {
            model.setNumSeven(seven);
        }
        String eight = "";
        eight = list.get(15).toString().trim();
        if (ObjectUtil.isNotEmpty(eight)) {
            model.setNumEight(eight);
        }
        String nine = "";
        nine = list.get(17).toString().trim();
        if (ObjectUtil.isNotEmpty(nine)) {
            model.setNumNine(nine);
        }
        String ten = "";
        ten = list.get(20).toString().trim();
        if (ObjectUtil.isNotEmpty(ten)) {
            model.setNumTen(two);
        }
        recordsMasterTurnoutInfoList.add(model);
    }

    /**
     * 处理支距部分
     *
     * @param recordsMasterTurnoutInfoList
     * @param offsetList
     * @param realname
     * @param id
     */
    public void uploadOffset(List<RecordsMasterTurnoutInfo> recordsMasterTurnoutInfoList, List<Object> offsetList, String realname, String id, String switchCode, String switchCodeNum) {
        RecordsMasterTurnoutInfo model = new RecordsMasterTurnoutInfo();
        model.setId(IdWorker.get32UUID());
        model.setDelFlag("0");
        model.setRecordsMasterId(id);
        model.setCreateTime(new Date());
        model.setUpdateTime(new Date());
        model.setCreateBy(realname);
        model.setUpdateBy(realname);
        model.setType("3");
        model.setSwitchCode(switchCode);
        model.setSwitchCodeNum(switchCodeNum);
        String one = "";
        one = offsetList.get(1).toString().trim();
        if (ObjectUtil.isNotEmpty(one)) {
            model.setNumOne(one);
        }
        String two = "";
        two = offsetList.get(5).toString().trim();
        if (ObjectUtil.isNotEmpty(two)) {
            model.setNumTwo(two);
        }
        String three = "";
        three = offsetList.get(8).toString().trim();
        if (ObjectUtil.isNotEmpty(three)) {
            model.setNumThree(three);
        }
        String four = "";
        four = offsetList.get(11).toString().trim();
        if (ObjectUtil.isNotEmpty(four)) {
            model.setNumFour(four);
        }
        String five = "";
        five = offsetList.get(14).toString().trim();
        if (ObjectUtil.isNotEmpty(five)) {
            model.setNumFive(five);
        }
        String six = "";
        six = offsetList.get(17).toString().trim();
        if (ObjectUtil.isNotEmpty(six)) {
            model.setNumSix(six);
        }
        String seven = "";
        seven = offsetList.get(20).toString().trim();
        if (ObjectUtil.isNotEmpty(seven)) {
            model.setNumSeven(seven);
        }
        recordsMasterTurnoutInfoList.add(model);
    }

    /**
     * @param recordsMasterTurnoutInfoList 最终的轨距集合
     * @param i                            当前行坐标
     * @param realname                     当前登录人姓名
     * @param rowRecords                   总行列数据集合
     * @param id                           主表id
     * @param type                         导入子类型
     */
    public void uploadTrackGauge(List<RecordsMasterTurnoutInfo> recordsMasterTurnoutInfoList, int i, String realname, List<List<Object>> rowRecords, String id, String type, String switchCode, String switchCodeNum) {
        //初始化公里总结报告表
        RecordsMasterTurnoutInfo model = new RecordsMasterTurnoutInfo();
        model.setId(IdWorker.get32UUID());
        model.setDelFlag("0");
        model.setRecordsMasterId(id);
        model.setCreateTime(new Date());
        model.setUpdateTime(new Date());
        model.setCreateBy(realname);
        model.setUpdateBy(realname);
        model.setType(type);
        model.setSwitchCode(switchCode);
        model.setSwitchCodeNum(switchCodeNum);

        //轨距->前顺坡终点S1
        String one = "";
        one = rowRecords.get(i).get(1).toString().trim();
        if (ObjectUtil.isNotEmpty(one)) {
            model.setNumOne(one);
        }
        String two = "";
        two = rowRecords.get(i).get(2).toString().trim();
        if (ObjectUtil.isNotEmpty(two)) {
            model.setNumTwo(two);
        }
        String three = "";
        three = rowRecords.get(i).get(3).toString().trim();
        if (ObjectUtil.isNotEmpty(three)) {
            model.setNumThree(three);
        }
        String four = "";
        four = rowRecords.get(i).get(4).toString().trim();
        if (ObjectUtil.isNotEmpty(four)) {
            model.setNumFour(four);
        }
        String five = "";
        five = rowRecords.get(i).get(5).toString().trim();
        if (ObjectUtil.isNotEmpty(five)) {
            model.setNumFive(five);
        }
        String six = "";
        six = rowRecords.get(i).get(6).toString().trim();
        if (ObjectUtil.isNotEmpty(six)) {
            model.setNumSix(six);
        }
        String seven = "";
        seven = rowRecords.get(i).get(7).toString().trim();
        if (ObjectUtil.isNotEmpty(seven)) {
            model.setNumSeven(seven);
        }
        String eight = "";
        eight = rowRecords.get(i).get(8).toString().trim();
        if (ObjectUtil.isNotEmpty(eight)) {
            model.setNumEight(eight);
        }
        String nine = "";
        nine = rowRecords.get(i).get(9).toString().trim();
        if (ObjectUtil.isNotEmpty(nine)) {
            model.setNumNine(nine);
        }
        String ten = "";
        ten = rowRecords.get(i).get(10).toString().trim();
        if (ObjectUtil.isNotEmpty(ten)) {
            model.setNumTen(ten);
        }
        String tenOne = "";
        tenOne = rowRecords.get(i).get(11).toString().trim();
        if (ObjectUtil.isNotEmpty(tenOne)) {
            model.setNumTenOne(tenOne);
        }
        String tenTwo = "";
        tenTwo = rowRecords.get(i).get(12).toString().trim();
        if (ObjectUtil.isNotEmpty(tenTwo)) {
            model.setNumTenTwo(tenTwo);
        }
        String tenThree = "";
        tenThree = rowRecords.get(i).get(13).toString().trim();
        if (ObjectUtil.isNotEmpty(tenThree)) {
            model.setNumTenThree(tenThree);
        }
        String tenFour = "";
        tenFour = rowRecords.get(i).get(14).toString().trim();
        if (ObjectUtil.isNotEmpty(tenFour)) {
            model.setNumTenFour(tenFour);
        }
        String tenFive = "";
        tenFive = rowRecords.get(i).get(15).toString().trim();
        if (ObjectUtil.isNotEmpty(tenFive)) {
            model.setNumTenFive(tenFive);
        }
        String tenSix = "";
        tenSix = rowRecords.get(i).get(16).toString().trim();
        if (ObjectUtil.isNotEmpty(tenSix)) {
            model.setNumTenSix(tenSix);
        }
        String tenSeven = "";
        tenSeven = rowRecords.get(i).get(17).toString().trim();
        if (ObjectUtil.isNotEmpty(tenSeven)) {
            model.setNumTenSeven(tenSeven);
        }
        String tenEight = "";
        tenEight = rowRecords.get(i).get(18).toString().trim();
        if (ObjectUtil.isNotEmpty(tenEight)) {
            model.setNumTenEight(tenEight);
        }
        String tenNine = "";
        tenNine = rowRecords.get(i).get(19).toString().trim();
        if (ObjectUtil.isNotEmpty(tenNine)) {
            model.setNumTenNine(tenNine);
        }
        String twenty = "";
        twenty = rowRecords.get(i).get(20).toString().trim();
        if (ObjectUtil.isNotEmpty(twenty)) {
            model.setNumTwenty(twenty);
        }
        String twentyOne = "";
        twentyOne = rowRecords.get(i).get(21).toString().trim();
        if (ObjectUtil.isNotEmpty(twentyOne)) {
            model.setNumTwentyOne(twentyOne);
        }
        String twentyTwo = "";
        twentyTwo = rowRecords.get(i).get(22).toString().trim();
        if (ObjectUtil.isNotEmpty(twentyTwo)) {
            model.setNumTwentyTwo(twentyTwo);
        }
        recordsMasterTurnoutInfoList.add(model);
    }

//************************其他接口******************************************************************************
    /**
     * 设备检查记录导出excel
     * @param request
     * @param recordsMasterCheck
     * @return
     */
//    @AutoLog(value = "设备检查记录导出excel")
//    @ApiOperation(value = "设备检查记录导出excel", notes = "设备检查记录导出excel")
//    @GetMapping(value = "/exportXls")
//    public ModelAndView exportXls(HttpServletRequest request,RecordsMasterCheck recordsMasterCheck) {
//        return super.exportXls(request, recordsMasterCheck, RecordsMasterCheck.class, "道床使用情况检查");
//    }

    /**
     * 导出excel
     *
     * @param request
     */
//    @AutoLog(value = "设备检查记录-导出")
//    @ApiOperation(value = "设备检查记录-导出", notes = "设备检查记录-导出")
//    @GetMapping(value = "/exportXl")
//    public ModelAndView exportXl(RecordsMasterCheck recordsMasterCheck, HttpServletRequest request) {
//        // Step.1 组装查询条件
//        //Step.2 AutoPoi 导出Excel
//        ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
//        List<RecordsMasterCheck> resultList = this.service.list(new LambdaQueryWrapper<RecordsMasterCheck>()
//                .like(ObjectUtil.isNotEmpty(recordsMasterCheck.getEkCode()), RecordsMasterCheck::getEkCode, recordsMasterCheck.getEkCode())
//                .eq(ObjectUtil.isNotEmpty(recordsMasterCheck.getSubwaySectionId()), RecordsMasterCheck::getSubwaySectionId, recordsMasterCheck.getSubwaySectionId())
//                .eq(ObjectUtil.isNotEmpty(recordsMasterCheck.getLightRailId()), RecordsMasterCheck::getLightRailId, recordsMasterCheck.getLightRailId())
//                .eq(ObjectUtil.isNotEmpty(recordsMasterCheck.getLineAliasId()), RecordsMasterCheck::getLineAliasId, recordsMasterCheck.getLineAliasId())
//                .eq(ObjectUtil.isNotEmpty(recordsMasterCheck.getLineAliasId()), RecordsMasterCheck::getType, recordsMasterCheck.getType())
//                .orderByAsc(RecordsMasterCheck::getCreateTime));
//        //导出文件名称
//        mv.addObject(NormalExcelConstants.FILE_NAME, "道床使用情况检查");
//        mv.addObject(NormalExcelConstants.CLASS, RecordsMasterCheck.class);
//        LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
//        mv.addObject(NormalExcelConstants.PARAMS, new ExportParams("道床使用情况检查列表数据", "导出人:", "导出信息"));
//        mv.addObject(NormalExcelConstants.DATA_LIST, resultList);
//        return mv;
//    }

    /**
     * 设备检查记录-导出
     *
     * @param response
     */
    @AutoLog(value = "设备检查记录-导出")
    @ApiOperation(value = "设备检查记录-导出", notes = "设备检查记录-导出")
    @GetMapping("/exportXls2")
    public void export(RecordsMasterCheck recordsMasterCheck, HttpServletResponse response) {
        List<RecordsMasterCheck> resultList = this.service.list(new LambdaQueryWrapper<RecordsMasterCheck>()
                .like(ObjectUtil.isNotEmpty(recordsMasterCheck.getEkCode()), RecordsMasterCheck::getEkCode, recordsMasterCheck.getEkCode())
                .eq(ObjectUtil.isNotEmpty(recordsMasterCheck.getSubwaySectionId()), RecordsMasterCheck::getSubwaySectionId, recordsMasterCheck.getSubwaySectionId())
                .eq(ObjectUtil.isNotEmpty(recordsMasterCheck.getLightRailId()), RecordsMasterCheck::getLightRailId, recordsMasterCheck.getLightRailId())
                .eq(ObjectUtil.isNotEmpty(recordsMasterCheck.getLineAliasId()), RecordsMasterCheck::getLineAliasId, recordsMasterCheck.getLineAliasId())
                .eq(ObjectUtil.isNotEmpty(recordsMasterCheck.getLineAliasId()), RecordsMasterCheck::getType, recordsMasterCheck.getType())
                .orderByAsc(RecordsMasterCheck::getCreateTime));
        int num = 0;
        for (RecordsMasterCheck s : resultList) {
            num = num + 1;
            s.setRowNum(num);
        }
        ExcelUtils.export(response, "设备检查记录", resultList, RecordsMasterCheck.class);
    }
}
