package org.jeecg.modules.checkData.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 检查数据-设备检查记录数据-钢轨波磨设备检查记录表
 * </p>
 *
 * @author hkl
 * @since 2024-07-11
 */
@Getter
@Setter
@ApiModel(value = "CorrugationRecord对象", description = "检查数据-设备检查记录数据-钢轨波磨设备检查记录表	")

public class CorrugationRecordDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("检查编号")
    private String ekCode;

    @ApiModelProperty("开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    @ApiModelProperty("结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTime;


}
