package org.jeecg.modules.checkData.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 动静态几何尺寸数据主表
 * </p>
 *
 * @author hkl
 * @since 2023-07-11
 */
@Data
public class MovementRecordsMasterDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("动态几何尺寸类型（1：人工静态检查；2：轨检仪静态检查; 3:轨检车检查；4：添乘仪检查）")
    private String type;

    @ApiModelProperty("检查批次编号")
    private String ekCode;

    @ApiModelProperty("轨检车号")
    private String trackCode;

    @ApiModelProperty("工单编号")
    private String workCode;

    @ApiModelProperty("检查区间id")
    private String subwaySectionId;

    @ApiModelProperty("检查区间名称")
    private String subwaySectionName;

    @ApiModelProperty("所属线路id")
    private String lightRailId;

    @ApiModelProperty("所属线路名称")
    private String lightRailName;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("开始速度等级")
    private String startLevel;

    @ApiModelProperty("结束速度等级")
    private String endLevel;

    @ApiModelProperty("轨梁方向(1:正；2：反)")
    private Integer direction;

    @ApiModelProperty("钢轨单元数量")
    private Integer railNum;

    @ApiModelProperty("曲线数量")
    private Integer curveNum;

    @ApiModelProperty("竖曲线数量")
    private Integer verticalCurveNum;

    @ApiModelProperty("道岔数量")
    private Integer switchNum;

    @ApiModelProperty("检查人姓名")
    private String checkBy;

    @ApiModelProperty("检查日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date checkTime;

    @ApiModelProperty("审核人姓名")
    private String verifyBy;

    @ApiModelProperty("审核时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date verifyTime;

    @ApiModelProperty("打印日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date printTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    private String delFlag;

}
