package org.jeecg.modules.checkData.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 轨检车-》TQI公里总结报告
 * </p>
 *
 * @author hkl
 * @since 2023-07-27
 */
@Data
public class MovementTqiKilometerReportDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    private String movementMasterId;

    @ApiModelProperty("公里")
    private String kilometer;

    @ApiModelProperty("标准")
    private String standard;

    @ApiModelProperty("未超标")
    private String notAboveStandard;

    @ApiModelProperty("超标")
    private String aboveStandard;

    @ApiModelProperty("超标10")
    private String aboveStandardTen;

    @ApiModelProperty("超标20")
    private String aboveStandardTwenty;

    @ApiModelProperty("T值")
    private String comeUpon;

    @ApiModelProperty("评价")
    private String rate;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    private Integer sort;


}
