package org.jeecg.modules.checkData.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 轨检车-》200m区段轨道不平顺质量指数TQI管理标准(单位：mm)
 * </p>
 *
 * @author hkl
 * @since 2023-07-27
 */
@Data
public class MovementTqiStandardManagerDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    private String movementMasterId;

    @ApiModelProperty("最小速度等级")
    private String minSpendLevel;

    @ApiModelProperty("最大速度等级")
    private String maxSpendLevel;

    @ApiModelProperty("高低（mm）")
    private String height;

    @ApiModelProperty("轨向（mm）")
    private String trackAlignment;

    @ApiModelProperty("轨距（mm）")
    private String trackGauge;

    @ApiModelProperty("水平（mm）")
    private String level;

    @ApiModelProperty("三角坑（mm）")
    private String triangularPit;

    @ApiModelProperty("TQI")
    private String tqiValue;

    @ApiModelProperty("超标<=10%->TQI最小值")
    private String minTqiExceedTen;

    @ApiModelProperty("超标<=10%->TQI最大值")
    private String maxTqiExceedTen;

    @ApiModelProperty("超标<=10%->扣分")
    private String tqiExceedTenDeduct;

    @ApiModelProperty("超标<=20%->TQI最小值")
    private String minTqiExceedTwenty;

    @ApiModelProperty("超标<=20%->TQI最大值")
    private String maxTqiExceedTwenty;

    @ApiModelProperty("超标<=20%->扣分")
    private String tqiExceedTwentyDeduct;

    @ApiModelProperty("超标>20%->TQI最小值")
    private String minTqiExceedPassTwenty;

    @ApiModelProperty("超标>20%->TQI扣分")
    private String tqiExceedPassTwentyDeduct;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    private Integer sort;


}
