package org.jeecg.modules.checkData.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 线路巡查记录-协助情况表-巡道员使用
 * </p>
 *
 * @author hkl
 * @since 2023-07-08
 */
@Data
public class RecordPatrolMasterAssistDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty("线路巡查记录主表id-外键")
    private String recordMasterId;

    @ApiModelProperty("巡查区间id")
    private String subwaySectionId;

    @ApiModelProperty("巡查区间名称")
    private String subwaySectionName;

    @ApiModelProperty("线别id")
    private String lineAliasId;

    @ApiModelProperty("线别名称")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("问题记录")
    private String problemRecord;

    @ApiModelProperty("处理情况")
    private String handingLog;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    private String delFlag;


}
