package org.jeecg.modules.checkData.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 检查数据设备-设备检查记录数据-道岔使用情况检查数据
 * </p>
 *
 * @author hkl
 * @since 2023-08-01
 */
@Data
public class RecordsMasterTurnoutInfoDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("设备检查记录主表id")
    private String recordsMasterId;

    @ApiModelProperty("道岔编号")
    private String switchCode;

    @ApiModelProperty("检查项目类型（1：轨距；2：水平；3：支距；4：轮缘槽；5：滑床板；6：顶铁；7：接头螺栓；8：护轨螺栓）")
    private String type;

    @ApiModelProperty("值1")
    private String numOne;

    @ApiModelProperty("值2")
    private String numTwo;

    @ApiModelProperty("值3")
    private String numThree;

    @ApiModelProperty("值4")
    private String numFour;

    @ApiModelProperty("值5")
    private String numFive;

    @ApiModelProperty("值6")
    private String numSix;


    @ApiModelProperty("值7")
    private String numSeven;

    @ApiModelProperty("值8")
    private String numEight;

    @ApiModelProperty("值9")
    private String numNine;

    @ApiModelProperty("值10")
    private String numTen;

    @ApiModelProperty("值11")
    private String numTenOne;

    @ApiModelProperty("值12")
    private String numTenTwo;

    @ApiModelProperty("值13")
    private String numTenThree;

    @ApiModelProperty("值14")
    private String numTenFour;

    @ApiModelProperty("值15")
    private String numTenFive;

    @ApiModelProperty("值16")
    private String numTenSix;

    @ApiModelProperty("值17")
    private String numTenSeven;

    @ApiModelProperty("值18")
    private String numTenEight;

    @ApiModelProperty("值19")
    private String numTenNine;

    @ApiModelProperty("值20")
    private String numTwenty;

    @ApiModelProperty("值21")
    private String numTwentyOne;

    @ApiModelProperty("值22")
    private String numTwentyTwo;

    @ApiModelProperty("是否合格（1：合格；2：不合格）")
    private String qualified;

    @ApiModelProperty("不合格说明")
    private String noQualifiedRemark;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    private String delFlag;

    @ApiModelProperty("导入道岔顺序")
    private Integer sort;
}
