package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 动静态几何尺寸对应的添乘仪详情表
 * </p>
 *
 * @author hkl
 * @since 2023-07-17
 */
@Getter
@Setter
@TableName("t_djt_movement_additive_info")
@ApiModel(value = "MovementAdditiveInfo对象", description = "动静态几何尺寸对应的添乘仪详情表")
public class MovementAdditiveInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    @TableField("movement_master_id")
    private String movementMasterId;

    @ApiModelProperty("测点里程")
    @TableField(" point_mileage")
    private BigDecimal pointMileage;

    @ApiModelProperty("水平加速度")
    @TableField("zontal_speed")
    private BigDecimal zontalSpeed;

    @ApiModelProperty("水平加速度等级")
    @TableField("zontal_speed_level")
    private Integer zontalSpeedLevel;

    @ApiModelProperty("垂直加速度")
    @TableField("vertical_speed")
    private BigDecimal verticalSpeed;

    @ApiModelProperty("垂直加速度等级")
    @TableField("vertical_speed_level")
    private Integer verticalSpeedLevel;

    @ApiModelProperty("速度")
    @TableField("speed")
    private BigDecimal speed;

    @ApiModelProperty("手动标记")
    @TableField("mark")
    private String mark;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("排序字段")
    @TableField("info_sort")
    private Integer infoSort;


}
