package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 动静态几何尺寸-检查数据单元映射表
 * </p>
 *
 * @author hkl
 * @since 2023-08-02
 */
@Getter
@Setter
@TableName("t_djt_movement_check_data_unit_device_map")
@ApiModel(value = "MovementCheckDataUnitDeviceMap对象", description = "动静态几何尺寸-检查数据单元映射表")
public class MovementCheckDataUnitDeviceMap implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;
    @ApiModelProperty("创建人")

    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("设备单元id")
    @TableField("unit_id")
    private String unitId;

    @ApiModelProperty("设备单元编码")
    @TableField("unit_code")
    private String unitCode;

    @ApiModelProperty("设备单元类型 ")
    @TableField("unit_type")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    @TableField("unit_type_name")
    private String unitTypeName;

    @ApiModelProperty("设备单元起始里程")
    @TableField("unit_starting_mileage")
    private BigDecimal unitStartingMileage;

    @ApiModelProperty("设备单元中心里程")
    @TableField("unit_center_mileage")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元终点里程")
    @TableField("unit_end_mileage")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查")
    @TableField("check_type")
    private Integer checkType;

    @ApiModelProperty("检查主表id")
    @TableField("check_id")
    private String checkId;


    @ApiModelProperty("检查项目id[注:轨检车是tqi的id]")
    @TableField("check_item_id")
    private String checkItemId;

    @ApiModelProperty("检查开始里程 [注:轨检车和添乘仪此id为null]")
    @TableField("check_item_starting_mileage")
    private BigDecimal checkItemStartingMileage;

    @ApiModelProperty("检查结束里程 [注:轨检车和添乘仪此id为null]")
    @TableField("check_item_end_mileage")
    private BigDecimal checkItemEndMileage;

    @ApiModelProperty("检查文本")
    @TableField("check_item_text")
    private String checkItemText;

    @ApiModelProperty("检查详情id")
    @TableField("check_detail_id")
    private String checkDetailId;

    @ApiModelProperty("检查开始里程")
    @TableField("check_detail_starting_mileage")
    private BigDecimal checkDetailStartingMileage;

    @ApiModelProperty("检查结束里程")
    @TableField("check_detail_end_mileage")
    private BigDecimal checkDetailEndMileage;

    @ApiModelProperty("测点")
    @TableField("measure_point")
    private Integer measurePoint;

    @ApiModelProperty("轨距")
    @TableField("track_gauge")
    private String trackGauge;

    @ApiModelProperty("水平")
    @TableField("level")
    private String level;

    @ApiModelProperty("三角坑")
    @TableField("triangular_pit")
    private String triangularPit;

    @ApiModelProperty("方向")
    @TableField("direction")
    private String direction;

    @ApiModelProperty("高低")
    @TableField("height")
    private String height;

    @ApiModelProperty("结构")
    @TableField("structure")
    private String structure;

    @ApiModelProperty("整改")
    @TableField("rectification")
    private String rectification;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;


}
