package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 轨检车-》超限记录报告	
 * </p>
 *
 * @author hkl
 * @since 2023-07-27
 */
@Getter
@Setter
@TableName("t_djt_movement_over_report")
@ApiModel(value = "MovementOverReport对象", description = "轨检车-》超限记录报告	")
public class MovementOverReport implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    @TableField("movement_master_id")
    private String movementMasterId;

    @ApiModelProperty("序号")
    @TableField("xuhao")
    private String xuhao;

    @ApiModelProperty("里程(m)")
    @TableField("mileage")
    private BigDecimal mileage;

    @ApiModelProperty("区间名称")
    @TableField("section_name")
    private String sectionName;

    @ApiModelProperty("超限类型")
    @TableField("overrun_type")
    private String overrunType;

    @ApiModelProperty("超限等级")
    @TableField("overrun_level")
    private String overrunLevel;

    @ApiModelProperty("长度")
    @TableField("longitude")
    private String longitude;

    @ApiModelProperty("峰值（mm或g）")
    @TableField("peak_value")
    private String peakValue;

    @ApiModelProperty("管理数据差")
    @TableField("data_difference")
    private String dataDifference;

    @ApiModelProperty("线性")
    @TableField("xianxing")
    private String xianxing;

    @ApiModelProperty("检测标准")
    @TableField("standard")
    private String standard;

    @ApiModelProperty("速度（km/h）")
    @TableField("spend")
    private String spend;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    @TableField("sort")
    private Integer sort;


}
