package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 轨检车-》公里总结报告表	
 * </p>
 *
 * @author hkl
 * @since 2023-07-27
 */
@Getter
@Setter
@TableName("t_djt_movement_summary_report")
@ApiModel(value = "MovementSummaryReport对象", description = "轨检车-》公里总结报告表	")
public class MovementSummaryReport implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    @TableField("movement_master_id")
    private String movementMasterId;

    @ApiModelProperty("公里")
    @TableField("kilometer")
    private String kilometer;

    @ApiModelProperty("长度(m)")
    @TableField("longitude")
    private String longitude;

    @ApiModelProperty("左高低1")
    @TableField("left_high_low_one")
    private String leftHighLowOne;

    @ApiModelProperty("左高低2")
    @TableField("left_high_low_two")
    private String leftHighLowTwo;

    @ApiModelProperty("左高低3")
    @TableField("left_high_low_three")
    private String leftHighLowThree;

    @ApiModelProperty("左高低4")
    @TableField("left_high_low_four")
    private String leftHighLowFour;

    @ApiModelProperty("右高低1")
    @TableField("right_high_low_one")
    private String rightHighLowOne;

    @ApiModelProperty("右高低2")
    @TableField("right_high_low_two")
    private String rightHighLowTwo;

    @ApiModelProperty("右高低3")
    @TableField("right_high_low_three")
    private String rightHighLowThree;

    @ApiModelProperty("右高低4")
    @TableField("right_high_low_four")
    private String rightHighLowFour;

    @ApiModelProperty("左轨向1")
    @TableField("left_track_one")
    private String leftTrackOne;

    @ApiModelProperty("左轨向2")
    @TableField("left_track_two")
    private String leftTrackTwo;

    @ApiModelProperty("左轨向3")
    @TableField("left_track_three")
    private String leftTrackThree;

    @ApiModelProperty("左轨向4")
    @TableField("left_track_four")
    private String leftTrackFour;

    @ApiModelProperty("右轨向1")
    @TableField("right_track_one")
    private String rightTrackOne;

    @ApiModelProperty("右轨向2")
    @TableField("right_track_two")
    private String rightTrackTwo;

    @ApiModelProperty("右轨向3")
    @TableField("right_track_three")
    private String rightTrackThree;

    @ApiModelProperty("右轨向4")
    @TableField("right_track_four")
    private String rightTrackFour;

    @ApiModelProperty("轨距1")
    @TableField("track_gauge_one")
    private String trackGaugeOne;

    @ApiModelProperty("轨距2")
    @TableField("track_gauge_two")
    private String trackGaugeTwo;

    @ApiModelProperty("轨距3")
    @TableField("track_gauge_three")
    private String trackGaugeThree;

    @ApiModelProperty("轨距4")
    @TableField("track_gauge_four")
    private String trackGaugeFour;

    @ApiModelProperty("水平1")
    @TableField("level_one")
    private String levelOne;

    @ApiModelProperty("水平2")
    @TableField("level_two")
    private String levelTwo;

    @ApiModelProperty("水平3")
    @TableField("level_three")
    private String levelThree;

    @ApiModelProperty("水平4")
    @TableField("level_four")
    private String levelFour;

    @ApiModelProperty("三角坑1")
    @TableField("triangular_pit_one")
    private String triangularPitOne;

    @ApiModelProperty("三角坑2")
    @TableField("triangular_pit_two")
    private String triangularPitTwo;

    @ApiModelProperty("三角坑3")
    @TableField("triangular_pit_three")
    private String triangularPitThree;

    @ApiModelProperty("三角坑4")
    @TableField("triangular_pit_four")
    private String triangularPitFour;

    @ApiModelProperty("曲率1")
    @TableField("curvature_one")
    private String curvatureOne;

    @ApiModelProperty("曲率2")
    @TableField("curvature_two")
    private String curvatureTwo;

    @ApiModelProperty("曲率3")
    @TableField("curvature_three")
    private String curvatureThree;

    @ApiModelProperty("曲率4")
    @TableField("curvature_four")
    private String curvatureFour;

    @ApiModelProperty("垂向加速度1")
    @TableField("droop_velocity_one")
    private String droopVelocityOne;

    @ApiModelProperty("垂向加速度2")
    @TableField("droop_velocity_two")
    private String droopVelocityTwo;

    @ApiModelProperty("垂向加速度3")
    @TableField("droop_velocity_three")
    private String droopVelocityThree;

    @ApiModelProperty("垂向加速度4")
    @TableField("droop_velocity_four")
    private String droopVelocityFour;

    @ApiModelProperty("横向加速度1")
    @TableField("across_velocity_one")
    private String acrossVelocityOne;

    @ApiModelProperty("横向加速度2")
    @TableField("across_velocity_two")
    private String acrossVelocityTwo;

    @ApiModelProperty("横向加速度3")
    @TableField("across_velocity_three")
    private String acrossVelocityThree;

    @ApiModelProperty("横向加速度4")
    @TableField("across_velocity_four")
    private String acrossVelocityFour;

    @ApiModelProperty("曲率变化率1")
    @TableField("curvature_change_one")
    private String curvatureChangeOne;

    @ApiModelProperty("曲率变化率2")
    @TableField("curvature_change_two")
    private String curvatureChangeTwo;

    @ApiModelProperty("轨距变化率1")
    @TableField("track_gauge_change_one")
    private String trackGaugeChangeOne;

    @ApiModelProperty("轨距变化率2")
    @TableField("track_gauge_change_two")
    private String trackGaugeChangeTwo;

    @ApiModelProperty("公里扣分")
    @TableField("kilometer_deduct")
    private String kilometerDeduct;

    @ApiModelProperty("评定")
    @TableField("evaluate")
    private String evaluate;

    @ApiModelProperty("速度（km/h）")
    @TableField("speed")
    private String speed;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    @TableField("sort")
    private Integer sort;


}
