package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 轨检车-》TQI公里总结报告	
 * </p>
 *
 * @author hkl
 * @since 2023-07-27
 */
@Getter
@Setter
@TableName("t_djt_movement_tqi_kilometer_report")
@ApiModel(value = "MovementTqiKilometerReport对象", description = "轨检车-》TQI公里总结报告	")
public class MovementTqiKilometerReport implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    @TableField("movement_master_id")
    private String movementMasterId;

    @ApiModelProperty("公里")
    @TableField("kilometer")
    private String kilometer;

    @ApiModelProperty("标准")
    @TableField("standard")
    private String standard;

    @ApiModelProperty("未超标")
    @TableField("not_above_standard")
    private String notAboveStandard;

    @ApiModelProperty("超标")
    @TableField("above_standard")
    private String aboveStandard;

    @ApiModelProperty("超标10")
    @TableField("above_standard_ten")
    private String aboveStandardTen;

    @ApiModelProperty("超标20")
    @TableField("above_standard_twenty")
    private String aboveStandardTwenty;

    @ApiModelProperty("T值")
    @TableField("come_upon")
    private String comeUpon;

    @ApiModelProperty("评价")
    @TableField("rate")
    private String rate;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    @TableField("sort")
    private Integer sort;


}
