package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 检查数据-动静态几何尺寸数据-轨检仪静态检查数据-检查项目-明细表
 * </p>
 *
 * @author hkl
 * @since 2023-07-16
 */
@Getter
@Setter
@TableName("t_dsg_rail_inspection_equipment_item_detail")
@ApiModel(value = "RailInspectionEquipmentItemDetail对象", description = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-检查项目-明细表")
public class RailInspectionEquipmentItemDetail implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("轨检仪静态检查数据id")
    @TableField("rail_inspection_equipment_id")
    private String railInspectionEquipmentId;

    @ApiModelProperty("轨检仪静态检查数据检查项id")
    @TableField("rail_inspection_equipment_item_id")
    private String railInspectionEquipmentItemId;

    @ApiModelProperty("检查项目")
    @TableField("check_item")
    private String checkItem;

    @ApiModelProperty("测点")
    @TableField("measure_point")
    private Integer measurePoint;

    @ApiModelProperty("轨距")
    @TableField("track_gauge")
    private String trackGauge;

    @ApiModelProperty("水平")
    @TableField("level")
    private String level;

    @ApiModelProperty("三角坑")
    @TableField("triangular_pit")
    private String triangularPit;

    @ApiModelProperty("轨向、高低及其它")
    @TableField("other")
    private String other;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("排序字段")
    @TableField("info_sort")
    private Integer infoSort;

    @ApiModelProperty("当前格子的起始里程:计算用")
    @TableField(exist = false)
    @JsonIgnore
    private BigDecimal currentStartMileage;

    @ApiModelProperty("当前格子的起始里程:计算用")
    @TableField(exist = false)
    @JsonIgnore
    private BigDecimal currentEndEndMileage;


}
