package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.jeecg.modules.utils.DicMap;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 线路巡查记录主表-巡道员使用
 * </p>
 *
 * @author hkl
 * @since 2023-07-08
 */
@Getter
@Setter
@TableName("t_xd_record_patrol_master")
@ApiModel(value = "RecordPatrolMaster对象", description = "线路巡查记录主表-巡道员使用")
public class RecordPatrolMaster implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty("检查批次编号")
    @TableField("ek_code")
    @Excel(name = "检查批次编号", width = 15, orderNum = "1")
    private String ekCode;

    @ApiModelProperty("工单编号")
    @TableField("work_code")
    @Excel(name = "工单编号", width = 15, orderNum = "2")
    private String workCode;

    @ApiModelProperty("检查日期")
    @TableField("inspect_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "检查日期", width = 15,format = "yyyy-MM-dd",orderNum = "3")
    private Date inspectTime;

    @ApiModelProperty("天气")
    @TableField("weather")
    @Excel(name = "天气", width = 15, orderNum = "4")
    private String weather;

    @ApiModelProperty("巡查线路id")
    @TableField("light_rail_id")
    private String lightRailId;

    @ApiModelProperty("巡查线路名称")
    @TableField("light_rail_name")
    @Excel(name = "巡查线路", width = 15, orderNum = "5")
    private String lightRailName;

    @ApiModelProperty("计划巡道里程（km）")
    @TableField("planned_patrol_mileage")
    @Excel(name = "计划巡道里程", width = 15, orderNum = "6")
    private BigDecimal plannedPatrolMileage;

    @ApiModelProperty("巡道线别id")
    @TableField("line_alias_id")
    private String lineAliasId;

    @ApiModelProperty("巡道线别名称")
    @TableField("line_alias_name")
    @Excel(name = "巡道线别", width = 15, orderNum = "7")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    @TableField("starting_mileage")
    @Excel(name = "起始里程", width = 15, orderNum = "8")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    @TableField("end_mileage")
    @Excel(name = "终点里程", width = 15, orderNum = "9")
    private BigDecimal endMileage;

    @ApiModelProperty("完成里程")
    @TableField("completed_mileage")
    @Excel(name = "完成里程", width = 15, orderNum = "10")
    private BigDecimal completedMileage;

    @ApiModelProperty("巡道类型(1:步行巡道 2:乘车巡道)")
    @TableField("patrol_type")
    private String patrolType;

    @ApiModelProperty("巡道类型翻译(1:步行巡道 2:乘车巡道)")
    @Excel(name = "巡道类型", width = 15, orderNum = "11")
    @TableField(exist = false)
    private String patrolTypeStr;
    public String getPatrolTypeStr() {
        return  DicMap.PATROL_TYPE_MAP.get(patrolType);
    }


    @ApiModelProperty("巡道工时")
    @TableField("patrol_hourse")
    @Excel(name = "巡道工时", width = 15, orderNum = "12")
    private BigDecimal patrolHourse;

    @ApiModelProperty("检查人姓名")
    @TableField("check_by")
    @Excel(name = "检查人姓名", width = 15, orderNum = "13")
    private String checkBy;

    @ApiModelProperty("清点时间")
    @TableField("check_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd hh:mm")
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm")
    @Excel(name = "清点时间", width = 15, format = "yyyy-MM-dd hh:mm", orderNum = "14")
    private Date checkTime;

    @ApiModelProperty("销点时间")
    @TableField("pinpoint_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd hh:mm")
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm")
    @Excel(name = "销点时间", width = 15, format = "yyyy-MM-dd hh:mm", orderNum = "15")
    private Date pinpointTime;

    @ApiModelProperty("审核人姓名")
    @TableField("verify_by")
    @Excel(name = "审核人姓名", width = 15, orderNum = "16")
    private String verifyBy;

    @ApiModelProperty("审核时间")
    @TableField("verify_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "审核时间", width = 15, format= "yyyy-MM-dd", orderNum = "17")
    private Date verifyTime;

    @ApiModelProperty("巡道员备忘录")
    @TableField("remark")
    private String remark;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    @TableField("del_flag")
    private String delFlag;


}
