package org.jeecg.modules.checkData.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.modules.checkData.entity.MovementCheckDataUnitDeviceMap;
import org.jeecg.modules.checkData.mapper.MovementCheckDataUnitDeviceMapMapper;
import org.jeecg.modules.checkData.service.IMovementCheckDataUnitDeviceMapService;
import org.jeecg.modules.unitDevice.dto.CaseReportCheckDataDTO;
import org.jeecg.modules.unitDevice.vo.CaseReportCheckDataVO;
import org.jeecg.modules.unitDevice.vo.StaticCheckVO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 动静态几何尺寸-检查数据单元映射表 服务实现类
 * </p>
 *
 * @author hkl
 * @since 2023-08-02
 */
@Service
public class MovementCheckDataUnitDeviceMapServiceImpl extends ServiceImpl<MovementCheckDataUnitDeviceMapMapper, MovementCheckDataUnitDeviceMap> implements IMovementCheckDataUnitDeviceMapService {

    @Override
    public List<StaticCheckVO> getUnitDeviceData(String unitDeviceId, int unitDeviceType, int checkType, String checkId) {
        return this.baseMapper.getUnitDeviceData(unitDeviceId, unitDeviceType, checkType,checkId);
    }

    @Override
    public Page<CaseReportCheckDataVO> queryUnitDeviceCheckRel(Page<CaseReportCheckDataVO> pageData, CaseReportCheckDataDTO dto) {
        return this.baseMapper.queryUnitDeviceCheckRel(pageData, dto);
    }
}
