package org.jeecg.modules.checkData.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
* <p>
    * 轨检车-》区段总结报告	
    * </p>
*
* @author hkl
* @since 2023-07-27
*/
@Data
public class MovementSectionReportVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    private String movementMasterId;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("个数->一级")
    private String numberOne;

    @ApiModelProperty("个数->二级")
    private String numberTwo;

    @ApiModelProperty("个数->三级")
    private String numberThree;

    @ApiModelProperty("个数->四级")
    private String numberFour;

    @ApiModelProperty("个数->总数")
    private String numberSum;

    @ApiModelProperty("个数->个数/公里")
    private String numberAve;

    @ApiModelProperty("个数->百分比")
    private String numberPer;

    @ApiModelProperty("扣分->扣分总计")
    private String deductSum;

    @ApiModelProperty("扣分->扣分/公里")
    private String deductAve;

    @ApiModelProperty("扣分->扣分百分比")
    private String deductPer;

    @ApiModelProperty("TQI->平均指数")
    private String tqiAve;

    @ApiModelProperty("TQI->超标段数")
    private String tqiExceedNum;

    @ApiModelProperty("TQI->超标百分比")
    private String tqiExceedPer;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    private Integer sort;


}
