package org.jeecg.modules.checkData.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
* <p>
    * 轨检车-》TQI总结报告	
    * </p>
*
* @author hkl
* @since 2023-07-27
*/
@Data
public class MovementTqiReportVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    private String movementMasterId;

    @ApiModelProperty("开始里程(m)")
    private BigDecimal startMileage;

    @ApiModelProperty("终点里程(m)")
    private BigDecimal endMileage;

    @ApiModelProperty("区间名称")
    private String sectionName;

    @ApiModelProperty("高低左")
    private String highLowLeft;

    @ApiModelProperty("高低右")
    private String highLowRight;

    @ApiModelProperty("轨向左")
    private String trackLeft;

    @ApiModelProperty("轨向右")
    private String trackRight;

    @ApiModelProperty("水平（mm）")
    private String level;

    @ApiModelProperty("轨距（mm）")
    private String trackGauge;

    @ApiModelProperty("三角坑（mm）")
    private String triangularPit;

    @ApiModelProperty("TQI数值")
    private String tqiComeUpon;

    @ApiModelProperty("TQI超标")
    private String tqiAboveStandard;

    @ApiModelProperty("扣分")
    private String deduct;

    @ApiModelProperty("检测标准")
    private String standard;

    @ApiModelProperty("速度（km/h）")
    private String spend;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    private Integer sort;


}
