package org.jeecg.modules.checkData.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 线路巡查记录详情表-巡道员使用
 * </p>
 *
 * @author hkl
 * @since 2023-07-08
 */
@Data
public class RecordPatrolMasterInfoVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty("线路巡查记录主表id-外键")
    private String recordMasterId;

    @ApiModelProperty("检查项目名称")
    private String ekProjectName;

    @ApiModelProperty("重点检查项目内容")
    private String ekProjectContent;

    @ApiModelProperty("问题记录")
    private String problemRecord;

    @ApiModelProperty("处理情况")
    private String handingLog;

    @ApiModelProperty("是否满足（1：是；2：否）")
    private String status;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    private String delFlag;


}
