package org.jeecg.modules.checkData.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 设备检查记录数据-钢轨波磨情况检查数据-波长详情
 * </p>
 *
 * @author hkl
 * @since 2023-08-04
 */
@Data
public class RecordsMasterCorrWaveInfoVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("设备检查记录主表id")
    private String recordsMasterId;

    @ApiModelProperty("类型（1：RMS；2：AP2P；3：FIL）")
    @TableField("type")
    private String type;

    @ApiModelProperty("编号")
    private String code;

    @ApiModelProperty("里程")
    private String mileage;

    @ApiModelProperty("波长")
    private String waveNum;

    @ApiModelProperty("值")
    private String numOne;

    @ApiModelProperty("限定值")
    private String restrictNum;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    private Integer sort;


}
