package org.jeecg.modules.checkData.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecg.modules.utils.DicMap;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 设备检查记录数据-道床使用情况记录数据返回扩展类
 * </p>
 *
 * @author hkl
 * @since 2023-07-07
 */
@Data
public class TrackBedManagementCheckVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty("设备检查记录主表id->外键")
    private String recordsMasterCheckId;

    @ApiModelProperty("道床id->外键")
    private String trakBedManagementId;

    @ApiModelProperty("检查项目名称")
    private String ekProjectName;

    @ApiModelProperty("检查项目内容")
    private String ekProjectContent;

    @ApiModelProperty("检查合格评判标准")
    private String ekProjectTemplate;

    @ApiModelProperty("现场检查项目状态（1：合格；2：良好；3：不合格）")
    private String ekProjectStatus;

    @ApiModelProperty("现场检查项目状态翻译（1：合格；2：良好；3：不合格）")
    private String ekProjectStatusStr;

    public String getEkProjectStatusStr() {
        return DicMap.EK_APPROVAL_STATUS_MAP.get(ekProjectStatus);
    }

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    private String delFlag;


}
