package org.jeecg.modules.deviceAsset.controller;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.deviceAsset.dto.FastenerManagementDTO;
import org.jeecg.modules.deviceAsset.entity.FastenerManagement;
import org.jeecg.modules.deviceAsset.service.IFastenerManagementService;
import org.jeecg.modules.deviceAsset.vo.FastenerManagementVO;
import org.jeecg.modules.subwayNetwork.entity.LightRail;
import org.jeecg.modules.subwayNetwork.entity.LineAlias;
import org.jeecg.modules.subwayNetwork.service.ILightRailService;
import org.jeecg.modules.subwayNetwork.service.ILineAliasService;
import org.jeecg.modules.utils.UnitCodeUtil;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Arrays;

/**
 * <p>
 * 资产管理-扣件管理 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@RestController
@RequestMapping("/deviceAsset/fastenerManagement")
@Api(tags = "资产管理-扣件管理")
public class FastenerManagementController extends JeecgController<FastenerManagement, IFastenerManagementService> {

    @Resource
    private ILightRailService lightRailService;

    @Resource
    private ILineAliasService lineAliasService;

    @AutoLog(value = "资产管理-扣件管理-分页列表查询")
    @ApiOperation(value = "资产管理-道岔管理-分页列表查询", notes = "资产管理-道岔管理-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<FastenerManagementVO>> queryPageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                             @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                             FastenerManagementDTO dto) {
        Page<FastenerManagementVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.queryPageList(pageData, dto);
        return Result.OK(pageData);
    }


    @AutoLog(value = "资产管理-扣件管理-编辑")
    @ApiOperation(value = "资产管理-扣件管理-编辑", notes = "资产管理-扣件管理-编辑")
    @PostMapping(value = "/edit")
    public Result<String> edit(@RequestBody FastenerManagement fastenerManagement) {

        if (ObjectUtil.isEmpty(fastenerManagement.getId())) {
            fastenerManagement.setId(UUIDGenerator.generate());
            fastenerManagement.setFastenerCode(UnitCodeUtil.fastenerManagementUtil(fastenerManagement.getLineAliasId()));
            this.service.save(fastenerManagement);
        } else {
            this.service.updateById(fastenerManagement);
        }

        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "资产管理-扣件管理-通过id删除")
    @ApiOperation(value = "资产管理-扣件管理-通过id删除", notes = "资产管理-扣件管理-通过id删除")
    @GetMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name = "id", required = true) String id) {
        this.service.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "资产管理-扣件管理-批量删除")
    @ApiOperation(value = "资产管理-扣件管理-批量删除", notes = "资产管理-扣件管理-批量删除")
    @GetMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.service.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }


    @AutoLog(value = "资产管理-扣件管理-校验扣件管理编码重复")
    @ApiOperation(value = "资产管理-扣件管理-校验扣件管理编码重复", notes = "资产管理-扣件管理-校验扣件管理编码重复")
    @GetMapping(value = "/checkFastenerCodeRepeat")
    public Result<String> checkFastenerCodeRepeat(String id, String lightRailId, String fastenerCode) {
        Long count = 0L;
        if (ObjectUtil.isNotEmpty(lightRailId)) {
            count = this.service.checkFastenerCodeRepeat(id, lightRailId, fastenerCode);
        }
        if (count > 0) {
            throw JeecgBootException.error("");
        }
        return Result.OK("未重复");
    }
}
