package org.jeecg.modules.deviceAsset.controller;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.modules.deviceAsset.dto.CurveManagementDTO;
import org.jeecg.modules.deviceAsset.dto.VerticalCurveManagementDTO;
import org.jeecg.modules.deviceAsset.entity.CurveManagement;
import org.jeecg.modules.deviceAsset.entity.VerticalCurveManagement;
import org.jeecg.modules.deviceAsset.service.IRailManagementService;
import org.jeecg.modules.deviceAsset.service.IVerticalCurveManagementService;
import org.jeecg.modules.deviceAsset.vo.CurveManagementQueryVO;
import org.jeecg.modules.deviceAsset.vo.VerticalCurveManagementVO;
import org.springframework.web.bind.annotation.*;

import org.jeecg.common.system.base.controller.JeecgController;

import javax.annotation.Resource;
import java.util.Arrays;

/**
 * <p>
 * 资产管理-竖曲线管理 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@RestController
@RequestMapping("/deviceAsset/verticalCurveManagement")
@Api(tags = "资产管理-竖曲线管理")
public class VerticalCurveManagementController extends JeecgController<VerticalCurveManagement, IVerticalCurveManagementService> {
    @Resource
    private IRailManagementService railManagementService;

    @AutoLog(value = "资产管理-竖曲线管理-分页列表查询")
    @ApiOperation(value = "资产管理-竖曲线管理-分页列表查询", notes = "资产管理-竖曲线管理-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<VerticalCurveManagementVO>> queryPageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                                  @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                                  VerticalCurveManagementDTO dto) {
        Page<VerticalCurveManagementVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.queryPageList(pageData, dto);
        return Result.OK(pageData);
    }


    @AutoLog(value = "资产管理-竖曲线管理-编辑")
    @ApiOperation(value = "资产管理-竖曲线管理-编辑", notes = "资产管理-竖曲线管理-编辑")
    @PostMapping(value = "/edit")
    public Result<String> edit(@RequestBody VerticalCurveManagement verticalCurveManagement) {

        railManagementService.verifyUnitDeviceConflicts(
                verticalCurveManagement.getId(),
                verticalCurveManagement.getLightRailId(),
                verticalCurveManagement.getLineAliasId(),
                verticalCurveManagement.getStartingMileage(),
                verticalCurveManagement.getEndMileage()
        );


        this.service.edit(verticalCurveManagement);

        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "资产管理-竖曲线管理-通过id删除")
    @ApiOperation(value = "资产管理-竖曲线管理-通过id删除", notes = "资产管理-竖曲线管理-通过id删除")
    @GetMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name = "id", required = true) String id) {
        this.service.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "资产管理-竖曲线管理-批量删除")
    @ApiOperation(value = "资产管理-竖曲线管理-批量删除", notes = "资产管理-竖曲线管理-批量删除")
    @GetMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.service.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }


    @AutoLog(value = "资产管理-竖曲线管理-校验竖曲线编码重复")
    @ApiOperation(value = "资产管理-竖曲线管理-校验竖曲线编码重复", notes = "资产管理-竖曲线管理-校验竖曲线编码重复")
    @GetMapping(value = "/checkVerticalCurveCodeRepeat")
    public Result<String> checkVerticalCurveCodeRepeat(String id, String lightRailId, String verticalCurveCode) {
        Long count = 0L;
        if (ObjectUtil.isNotEmpty(lightRailId)) {
            count = this.service.checkVerticalCurveCodeRepeat(id, lightRailId, verticalCurveCode);
        }
        if (count > 0) {
            throw JeecgBootException.error("");
        }
        return Result.OK("未重复");
    }
}
