package org.jeecg.modules.deviceAsset.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description: 资产管理-曲线管理
 */
@Data
@TableName("t_da_curve_management")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "t_da_curve_management对象", description = "资产管理-曲线管理")
public class CurveManagement implements Serializable {
    private static final long serialVersionUID = 1L;


    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;

    @ApiModelProperty(value = "创建人")
    private String createBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;

    @ApiModelProperty(value = "更新人")
    private String updateBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;

    @ApiModelProperty(value = "曲线编号")
    private String curveCode;

    @ApiModelProperty(value = "单元编码")
    private String unitCode;

    @ApiModelProperty(value = "曲线偏角 a   (°′″)")
    private String curveDeflectionAngle;

    @ApiModelProperty(value = "曲线半径R(m)")
    private BigDecimal curveRadius;

    @ApiModelProperty(value = "缓和曲线长I(m)")
    private String transitionCurveLen;

    @ApiModelProperty(value = "切线长T(m)")
    private BigDecimal tangentLen;

    @ApiModelProperty("曲线长L(m)")
    private BigDecimal curveLen;

    @ApiModelProperty(value = "直缓（直圆）里程ZH(ZY)")
    private BigDecimal curveMileageZh;

    @ApiModelProperty(value = "缓圆里程(HY)")
    private BigDecimal curveMileageHy;

    @ApiModelProperty(value = "圆缓里程(YH)")
    private BigDecimal curveMileageYh;

    @ApiModelProperty(value = "缓直（圆直）里程HZ(YZ)")
    private BigDecimal curveMileageHz;

    @ApiModelProperty(value = "超高H(mm)")
    private BigDecimal superHigh;

    @ApiModelProperty(value = "区间id")
    private String sectionId;

    @ApiModelProperty(value = "线别id")
    private String lineAliasId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "线路id")
    @TableField(exist = false)
    private String lightRailId;

}
