package org.jeecg.modules.deviceAsset.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 资产管理-钢轨管理
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@Data
@TableName("t_da_rail_management")
@ApiModel(value = "RailManagement对象", description = "资产管理-钢轨管理")
public class RailManagement implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    @TableField("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("钢轨序号")
    @TableField("rail_order_num")
    private Integer railOrderNum;

    @ApiModelProperty("钢轨编码")
    @TableField("rail_code")
    private String railCode;

    @ApiModelProperty(value = "单元编码")
    @TableField("unit_code")
    private String unitCode;

    @ApiModelProperty("线路id")
    @TableField("light_rail_id")
    private String lightRailId;

    @ApiModelProperty("区间id")
    @TableField("section_id")
    private String sectionId;

    @ApiModelProperty("线别id")
    @TableField("line_alias_id")
    private String lineAliasId;

    @ApiModelProperty("起始里程")
    @TableField("starting_mileage")
    private BigDecimal startingMileage;

    @ApiModelProperty("中心里程")
    @TableField("center_mileage")
    private BigDecimal centerMileage;

    @ApiModelProperty("结束里程")
    @TableField("end_mileage")
    private BigDecimal endMileage;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;


}
