package org.jeecg.modules.deviceAsset.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 资产管理-轨行区标识牌管理
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@Getter
@Setter
@TableName("t_da_sign_board_management")
@ApiModel(value = "SignBoardManagement对象", description = "资产管理-轨行区标识牌管理")
public class SignBoardManagement implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableField("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("轨行区标识牌编号")
    @TableField("sign_board_code")
    private String signBoardCode;

    @ApiModelProperty("轨行区标识牌类型")
    @TableField("sign_board_type")
    private String signBoardType;

    @ApiModelProperty("区间id")
    @TableField("section_id")
    private String sectionId;

    @ApiModelProperty("线别id")
    @TableField("line_alias_id")
    private String lineAliasId;

    @ApiModelProperty("里程")
    @TableField("mileage")
    private BigDecimal mileage;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty(value = "线路id")
    @TableField(exist = false)
    private String lightRailId;
}
