package org.jeecg.modules.deviceAsset.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description: 资产管理-道岔管理
 */
@Data
@TableName("t_da_switch_management")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "t_da_switch_management对象", description = "资产管理-道岔管理")
public class SwitchManagement implements Serializable {
    private static final long serialVersionUID = 1L;


    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;

    @ApiModelProperty(value = "创建人")
    private String createBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;

    @ApiModelProperty(value = "更新人")
    private String updateBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;

    @ApiModelProperty(value = "道岔编号")
    private String switchCode;

    @ApiModelProperty(value = "单元编码")
    private String unitCode;

    @ApiModelProperty(value = "道岔型号")
    private String switchModel;

    @ApiModelProperty(value = "线别Id")
    private String lineAliasId;

    @ApiModelProperty(value = "开向")
    private String openTo;

    @ApiModelProperty(value = "岔前/岔前里程")
    private BigDecimal byroadPreMileage;

    @ApiModelProperty(value = "岔心里程")
    private BigDecimal byroadCenterMileage;

    @ApiModelProperty(value = "岔前/岔后里程")
    private BigDecimal byroadEndMileage;

    @ApiModelProperty(value = "区间车站mapId")
    private String sectionStationMapId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "线路id")
    @TableField(exist = false)
    private String lightRailId;

}
