package org.jeecg.modules.deviceAsset.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.jeecg.modules.deviceAsset.dto.TrackBedManagementDTO;
import org.jeecg.modules.deviceAsset.entity.TrackBedManagement;
import org.jeecg.modules.deviceAsset.vo.TrackBedManagementVO;

import java.util.List;

/**
 * <p>
 * 资产管理-道床管理 Mapper 接口
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
public interface TrackBedManagementMapper extends BaseMapper<TrackBedManagement> {

    Page<TrackBedManagementVO> queryPageList(Page<TrackBedManagementVO> pageData, TrackBedManagementDTO dto);

    List<TrackBedManagement> getTrackBedById(String id);

    Long checkTrackBedCodeRepeat(String id, String lightRailId, String trackBedCode);
}
