package org.jeecg.modules.deviceAsset.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.deviceAsset.dto.CurveManagementDTO;
import org.jeecg.modules.deviceAsset.entity.CurveManagement;
import org.jeecg.modules.deviceAsset.mapper.CurveManagementMapper;
import org.jeecg.modules.deviceAsset.service.ICurveManagementService;
import org.jeecg.modules.deviceAsset.vo.CurveManagementQueryVO;
import org.jeecg.modules.subwayNetwork.mapper.LineAliasMapper;
import org.jeecg.modules.utils.UnitCodeUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * <p>
 * 资产管理-曲线管理 服务实现类
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@Service
public class CurveManagementServiceImpl extends ServiceImpl<CurveManagementMapper, CurveManagement> implements ICurveManagementService {

    @Override
    public Page<CurveManagementQueryVO> queryPageList(Page<CurveManagementQueryVO> pageData, CurveManagementDTO dto) {
        return this.baseMapper.queryPageList(pageData, dto);
    }

    @Override
    public void edit(CurveManagement curveManagement) {
        if (ObjectUtil.isEmpty(curveManagement.getId())) {
            curveManagement.setId(UUIDGenerator.generate());
            String utilCode = UnitCodeUtil.curveUnitCodeUtil(curveManagement.getLineAliasId());
            curveManagement.setUnitCode(utilCode);

            this.save(curveManagement);
        } else {
            this.updateById(curveManagement);
        }

    }

    @Override
    public Long checkCurveCodeRepeat(String id, String lightRailId, String curveCode) {
        return this.baseMapper.checkCurveCodeRepeat(id, lightRailId, curveCode);
    }
}
