package org.jeecg.modules.deviceAsset.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.api.dto.PageSearch;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.deviceAsset.dto.SwitchManagementQueryDTO;
import org.jeecg.modules.deviceAsset.entity.SwitchManagement;
import org.jeecg.modules.deviceAsset.mapper.SwitchManagementMapper;
import org.jeecg.modules.deviceAsset.service.ISwitchManagementService;
import org.jeecg.modules.deviceAsset.vo.SwitchManagementQueryVO;
import org.jeecg.modules.subwayNetwork.dto.LightRailQueryDTO;
import org.jeecg.modules.subwayNetwork.entity.LightRail;
import org.jeecg.modules.subwayNetwork.mapper.LightRailMapper;
import org.jeecg.modules.subwayNetwork.service.ILightRailService;
import org.jeecg.modules.subwayNetwork.vo.LightRailQueryVO;
import org.jeecg.modules.utils.UnitCodeUtil;
import org.springframework.stereotype.Service;

/**
 * @Description: 线路车站-轻轨线路
 * @Author: jeecg-boot
 * @Date: 2023-06-14
 * @Version: V1.0
 */
@Service
public class SwitchManagementServiceImpl extends ServiceImpl<SwitchManagementMapper, SwitchManagement> implements ISwitchManagementService {

    @Override
    public Page<SwitchManagementQueryVO> queryPageList(Page<SwitchManagementQueryVO> pageData, SwitchManagementQueryDTO dto) {
        return this.baseMapper.queryPageList(pageData, dto);
    }

    @Override
    public void edit(SwitchManagement switchManagement) {
        if (ObjectUtil.isEmpty(switchManagement.getId())) {
            switchManagement.setId(UUIDGenerator.generate());
            String utilCode = UnitCodeUtil.switchUnitCodeUtil(switchManagement.getLineAliasId());
            switchManagement.setUnitCode(utilCode);
            this.save(switchManagement);
        } else {
            this.updateById(switchManagement);
        }
    }

    @Override
    public Long checkSwitchCodeRepeat(String id, String lightRailId, String switchCode) {
        return this.baseMapper.checkSwitchCodeRepeat(id,lightRailId,switchCode);
    }
}
