package org.jeecg.modules.deviceAsset.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.deviceAsset.dto.VerticalCurveManagementDTO;
import org.jeecg.modules.deviceAsset.entity.VerticalCurveManagement;
import org.jeecg.modules.deviceAsset.mapper.VerticalCurveManagementMapper;
import org.jeecg.modules.deviceAsset.service.IVerticalCurveManagementService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.modules.deviceAsset.vo.VerticalCurveManagementVO;
import org.jeecg.modules.utils.UnitCodeUtil;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 资产管理-竖曲线管理 服务实现类
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@Service
public class VerticalCurveManagementServiceImpl extends ServiceImpl<VerticalCurveManagementMapper, VerticalCurveManagement> implements IVerticalCurveManagementService {

    @Override
    public Page<VerticalCurveManagementVO> queryPageList(Page<VerticalCurveManagementVO> pageData, VerticalCurveManagementDTO dto) {
        return this.baseMapper.queryPageList(pageData, dto);
    }

    @Override
    public void edit(VerticalCurveManagement verticalCurveManagement) {
        if (ObjectUtil.isEmpty(verticalCurveManagement.getId())) {
            verticalCurveManagement.setId(UUIDGenerator.generate());
            String utilCode = UnitCodeUtil.verticalCurveUnitCodeUtil(verticalCurveManagement.getLineAliasId());
            verticalCurveManagement.setUnitCode(utilCode);
            this.save(verticalCurveManagement);
        } else {
            this.updateById(verticalCurveManagement);
        }
    }

    @Override
    public Long checkVerticalCurveCodeRepeat(String id, String lightRailId, String verticalCurveCode) {
        return this.baseMapper.checkVerticalCurveCodeRepeat(id,lightRailId,verticalCurveCode);
    }
}
