package org.jeecg.modules.deviceAsset.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 资产管理-钢轨管理
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@Data
@ApiModel(value = "RailManagementVO对象", description = "资产管理-钢轨管理")
public class RailManagementVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("钢轨序号")
    private Integer railOrderNum;

    @ApiModelProperty("钢轨编码")
    private String railCode;

    @ApiModelProperty("线路id")
    private String lightRailId;

    @ApiModelProperty("线路名称")
    private String lightRailName;

    @ApiModelProperty("区间id")
    private String sectionId;

    @ApiModelProperty("区间名称")
    private String sectionName;

    @ApiModelProperty("线别id")
    private String lineAliasId;

    @ApiModelProperty("线别名称")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("中心里程")
    private BigDecimal centerMileage;

    @ApiModelProperty("结束里程")
    private BigDecimal endMileage;

    @ApiModelProperty("备注")
    private String remark;

}
