package org.jeecg.modules.diseaseAnalysis.algorithm;

import lombok.extern.slf4j.Slf4j;

/**
 * 多生产者模型-单消费者模型
 * 单消费者
 */
@Slf4j
public class SingleConsumerLine {
    private static AnalysisAlgorithmLine analysisAlgorithmLine;

    public static void setService(AnalysisAlgorithmLine analysisAlgorithmLine) {
        SingleConsumerLine.analysisAlgorithmLine = analysisAlgorithmLine;
    }


    public static void consume() {

        while (true) {
            try {
                String analysisLineBatchId = Buffer.queue.take();
                log.info("SingleConsumerLine[消费者]|线程id:【" + Thread.currentThread().getId() + "】=============分析批次ID:【" + analysisLineBatchId + "】");

                analysisAlgorithmLine.analysisLine(analysisLineBatchId);

            } catch (Exception e) {
                StackTraceElement[] stackTrace = e.getStackTrace();
                String exceptionMessage = "错误类名:" +
                        stackTrace[0].getClassName() +
                        ".错误方法名:" +
                        stackTrace[0].getMethodName() +
                        ".错误行号:" +
                        stackTrace[0].getLineNumber() +
                        ".异常:" +
                        e.toString();
                log.error("SingleConsumerLine[消费者]|线程id:【" + Thread.currentThread().getId() + "】异常信息:" + exceptionMessage);
                e.printStackTrace();
            }

        }

    }

}
