package org.jeecg.modules.diseaseAnalysis.dto;


import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 线路质量分析	-分析批次表
 * </p>
 *
 * @author hkl
 * @since 2024-07-19
 */
@Getter
@Setter
@ApiModel(value = "AnalysisLineBatch对象", description = "线路质量分析	-分析批次表")

public class AnalysisLineBatchDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("所属线路id")
    private String lightRailId;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty("分析起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("分析终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("分析状态 0-创建 1-分析中  99-分析完成")
    private Integer analysisStatus;

    @ApiModelProperty("1-道岔检查 2-钢轨常规探伤检查 3-曲线钢轨磨耗检查 4-钢轨波磨检查 5-道床检查 6-线路检查）")
    private String ekType;


}
