package org.jeecg.modules.diseaseAnalysis.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * <p>
 * 线路质量分析分析详情
 * </p>
 *
 * @author hkl
 * @since 2024-07-19
 */
@Getter
@Setter
@ApiModel(value = "AnalysisLineBatchInfoDTO对象", description = "线路质量分析分析详情")

public class AnalysisLineBatchInfoDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("分析批次id")
    private String analysisBatchId;

    @ApiModelProperty("单元编号")
    private String unitCode;

    @ApiModelProperty("设备编号")
    private String unitDeviceCode;

    @ApiModelProperty("派工状态（1：未派工，2：已派工）")
    private Integer workStatus;

    @ApiModelProperty("标记状态(1:未标记，2：异常，3：正常)")
    private Integer markStatus;
}
